/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public enum ErrMsg {
    IMPORT_NOT_FOUND("Imported CIF specification \"%s\" could not be found, is a directory, or for some other reason could not be opened for reading.", 1, SemanticProblemSeverity.ERROR),
    IMPORT_IO_ERROR("Imported CIF specification \"%s\" could not be read.", 1, SemanticProblemSeverity.ERROR),
    IMPORT_SYNTAX_ERROR("Imported CIF specification \"%s\" has a syntax error.", 1, SemanticProblemSeverity.ERROR),
    IMPORT_SYNTAX_WARNING("Imported CIF specification \"%s\" has a syntax warning.", 1, SemanticProblemSeverity.WARNING),
    IMPORT_SELF("Importing a CIF specification into itself has no effect.", 0, SemanticProblemSeverity.WARNING),
    DUPL_IMPORT("Duplicate import of CIF specification \"%s\" from a single file.", 1, SemanticProblemSeverity.WARNING),
    DUPL_NAMESPACE("Duplicate namespace definition in a single file.", 0, SemanticProblemSeverity.ERROR),
    IMPORT_IN_GRP("Invalid import: imports in groups are not allowed.", 0, SemanticProblemSeverity.ERROR),
    NAMESPACE_IN_GRP("Invalid namespace declaration: namespace declarations in groups are not allowed.", 0, SemanticProblemSeverity.ERROR),
    CONVOLUTED_REF("Convoluted reference to %s. Use \"%s\" instead.", 2, SemanticProblemSeverity.WARNING),
    RESERVED_NAME_PREFIX("Name of \"%s\" is invalid, as names starting with \"e_\", \"c_\", or \"u_\" are reserved for events.", 1, SemanticProblemSeverity.WARNING),
    EVENT_NAME_CONTR_MISMATCH("Name of event \"%s\" starts with \"%s\", which is a prefix reserved for %s.", 3, SemanticProblemSeverity.WARNING),
    DUPLICATE_NAME("Duplicate name \"%s\" in %s.", 2, SemanticProblemSeverity.ERROR),
    DUPLICATE_FIELD_NAME("Duplicate tuple type field name \"%s\".", 1, SemanticProblemSeverity.ERROR),
    ALPHABET_DISABLED_EVENT("The alphabet of automaton \"%s\" globally disables event \"%s\", as the event is not used on any of the edges of the automaton.", 2, SemanticProblemSeverity.WARNING),
    MONITOR_EVENT_NO_EDGE("Automaton \"%s\" monitors event \"%s\", but the event is not used on any of the edges of the automaton.", 2, SemanticProblemSeverity.WARNING),
    EXPR_UNKNOWN_TYPE("Could not determine the type of expression \"%s\". Please use a cast expression to explicitly specify the type.", 1, SemanticProblemSeverity.ERROR),
    INT_VALUE_OVERFLOW("Integer value overflow (%s > 2,147,483,647 = 2^31 - 1).", 1, SemanticProblemSeverity.ERROR),
    REAL_VALUE_OVERFLOW("Real value overflow (%s).", 1, SemanticProblemSeverity.ERROR),
    TYPE_RANGE_BOUND_NON_INT("The %s bound value of %s type must be of type \"int\".", 2, SemanticProblemSeverity.ERROR),
    EMPTY_TYPE_RANGE("Empty %s type range [%s .. %s].", 3, SemanticProblemSeverity.ERROR),
    TYPE_RANGE_BOUND_NEG("The %s bound value (%s) of %s type must not be negative.", 3, SemanticProblemSeverity.ERROR),
    CAST_INVALID_TYPES("Invalid cast from type \"%s\" to type \"%s\".", 2, SemanticProblemSeverity.ERROR),
    TUPLE_TYPE_ONE_FIELD("Tuple types must have at least two fields.", 0, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_ALG_VAR("Cannot statically evaluate algebraic variable \"%s\".", 1, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_INPUT_VAR("Cannot statically evaluate input variable \"%s\".", 1, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_CONT_VAR("Cannot statically evaluate %scontinuous variable \"%s\".", 2, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_LOC("Cannot statically evaluate location \"%s\".", 1, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_DISC_VAR("Cannot statically evaluate %s \"%s\".", 2, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_SAMPLE("Cannot statically evaluate unary operator \"sample\".", 0, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_TIME("Cannot statically evaluate variable \"time\".", 0, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_DIST("Cannot statically evaluate distribution standard library function \"%s\".", 1, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_FCALL_USER_DEF_FUNC("Cannot statically evaluate user-defined function \"%s\".", 1, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_RCV_VALUE("Cannot statically evaluate the value received by a communication.", 0, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_AUT_REF("Cannot statically evaluate automaton \"%s\" to its active location.", 1, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_SELF("Cannot statically evaluate an automaton \"self\" reference.", 0, SemanticProblemSeverity.ERROR),
    STATIC_EVAL_COMP_PARAM("Cannot statically evaluate component parameter \"%s\".", 1, SemanticProblemSeverity.ERROR),
    DEF_USE_CYCLE("Definition/use cycle detected: \"%s\" is recursively defined in terms of itself: %s.", 2, SemanticProblemSeverity.ERROR),
    COMP_DEF_INST_CYCLE("Component definition \"%s\" is directly or indirectly instantiated in itself, resulting in an infinite specification: %s.", 2, SemanticProblemSeverity.ERROR),
    RESOLVE_NOT_FOUND("Could not find a declaration with name \"%s\" in %s%s.", 3, SemanticProblemSeverity.ERROR),
    RESOLVE_VIA_NON_SCOPE("Could not resolve \"%s\" via \"%s\", as the latter is not a scope.", 2, SemanticProblemSeverity.ERROR),
    RESOLVE_VIA_COMPDEF("Could not resolve \"%s\" via component definition \"%s\", as the definition needs to be instantiated first.", 2, SemanticProblemSeverity.ERROR),
    RESOLVE_VIA_FUNC("Could not resolve \"%s\" via function \"%s\", as declarations in functions are local to the function itself.", 2, SemanticProblemSeverity.ERROR),
    RESOLVE_NOT_IN_FUNC_SCOPE("\"%s\" may not be used inside function \"%s\".", 2, SemanticProblemSeverity.ERROR),
    RESOLVE_NOT_COMP_DEF("\"%s\" is not a component definition.", 1, SemanticProblemSeverity.ERROR),
    COMP_INST_DEF_NOT_IN_SCOPE("Component definition \"%s\" is not in scope.", 1, SemanticProblemSeverity.ERROR),
    COMP_PARAM_NOT_IN_SCOPE("Component parameter \"%s\" is not in scope.", 1, SemanticProblemSeverity.ERROR),
    DER_OF_NON_CONT_VAR("Invalid derivative: %s\"%s\" is not a continuous variable.", 2, SemanticProblemSeverity.ERROR),
    ALG_VAR_TYPE_VALUE_MISMATCH("The type \"%s\" of the value of algebraic variable \"%s\" is incompatible with the type \"%s\" of the algebraic variable.", 3, SemanticProblemSeverity.ERROR),
    CONST_TYPE_VALUE_MISMATCH("The type \"%s\" of the value of constant \"%s\" is incompatible with the type \"%s\" of the constant.", 3, SemanticProblemSeverity.ERROR),
    DISC_VAR_TYPE_VALUE_MISMATCH("The type \"%s\" of %s initial value of %svariable \"%s\" is incompatible with the type \"%s\" of the variable.", 5, SemanticProblemSeverity.ERROR),
    CONT_VAR_TYPE_VALUE_MISMATCH("The type \"%s\" of the initial value of continuous variable \"%s\" is incompatible with the type \"real\" of the variable.", 2, SemanticProblemSeverity.ERROR),
    CONT_VAR_DER_TYPE("The type \"%s\" of the derivative of continuous variable \"%s\" is incompatible with the type \"real\" of the variable.", 2, SemanticProblemSeverity.ERROR),
    EQN_CONT_NON_DER("Specifying the value of continuous variable \"%s\" using an equation is not allowed.", 1, SemanticProblemSeverity.ERROR),
    EQN_ALG_DER("Specifying the derivative of algebraic variable \"%s\" (using an equation) is not allowed.", 1, SemanticProblemSeverity.ERROR),
    EQN_VAR_NOT_IN_SCOPE("Invalid equation: \"%s\" is not an algebraic or continuous variable declared in %s.", 2, SemanticProblemSeverity.ERROR),
    DUPL_DER_FOR_CONT_VAR("Duplicate derivative for \"%s\".", 1, SemanticProblemSeverity.ERROR),
    DUPL_VALUE_FOR_ALG_VAR("Duplicate value for \"%s\".", 1, SemanticProblemSeverity.ERROR),
    CONT_VAR_NO_DER("Missing derivative for continuous variable \"%s\".", 1, SemanticProblemSeverity.ERROR),
    ALG_VAR_NO_VALUE("Missing value for algebraic variable \"%s\".", 1, SemanticProblemSeverity.ERROR),
    EVENT_PARAM_DUPL_FLAG("Duplicate \"%s\" flag for event parameter \"%s\".", 2, SemanticProblemSeverity.ERROR),
    EVENT_PARAM_FLAG_ORDER("Flag \"%s\" should be before flag \"%s\", for event parameter \"%s\".", 3, SemanticProblemSeverity.WARNING),
    EVENT_PARAM_FLAG_NON_CHAN("Illegal flag: event parameter \"%s\" is not a channel (has no data type).", 1, SemanticProblemSeverity.ERROR),
    COMP_PARAM_INVALID_TYPE("The type of component parameter \"%s\" is not a component definition.", 1, SemanticProblemSeverity.ERROR),
    DECL_INVALID_TYPE("%s \"%s\" is of type \"%s\", which is a component or component definition.", 3, SemanticProblemSeverity.ERROR),
    TYPE_INVALID_TYPE("Type \"%s\" is not allowed for %s.", 2, SemanticProblemSeverity.ERROR),
    TYPE_ONE_VALUE("The %stype \"%s\" of %s \"%s\" allows only one value. Consider whether the type is correct, or use a constant instead of the %s.", 5, SemanticProblemSeverity.WARNING),
    INVALID_TYPE_REF("\"%s\" is not a type.", 1, SemanticProblemSeverity.ERROR),
    COMPDEF_REF_IN_EXPR("Cannot use \"%s\" as a value, as it is a component definition.", 1, SemanticProblemSeverity.ERROR),
    TYPE_REF_IN_EXPR("Cannot use \"%s\" as a value, as it is a type.", 1, SemanticProblemSeverity.ERROR),
    INV_REF_IN_EXPR("Cannot use \"%s\" as a value, as it is an invariant.", 1, SemanticProblemSeverity.ERROR),
    INV_DUPL_EVENT("Duplicate invariant for event \"%s\".", 1, SemanticProblemSeverity.WARNING),
    INV_DUPL_STATE("Duplicate state invariant.", 0, SemanticProblemSeverity.WARNING),
    INV_EVENT_NOT_IN_ALPHABET("Event \"%s\" is not in the synchronization, send or receive alphabet of the specification, and thus will never occur; restricting it has no effect.", 1, SemanticProblemSeverity.WARNING),
    UNOP_INVALID_CHILD_TYPE("Unary operator \"%s\" can not be applied to a value of type \"%s\".", 2, SemanticProblemSeverity.ERROR),
    UNOP_NEGATE_OVERFLOW("Unary operator \"-\" is applied to a value of type \"%s\" and this could result in integer overflow.", 1, SemanticProblemSeverity.ERROR),
    FCALL_NON_FUNC("Can't call a value of type \"%s\", as it is not a function.", 1, SemanticProblemSeverity.ERROR),
    FCALL_WRONG_ARG_COUNT("Function %s needs %s, but %s given.", 3, SemanticProblemSeverity.ERROR),
    FCALL_WRONG_ARG_TYPES("Function %s can not be called with arguments of types %s.", 2, SemanticProblemSeverity.ERROR),
    FCALL_ABS_OVERFLOW("The \"abs\" function is applied to a value of type \"%s\", and this could result in integer overflow.", 1, SemanticProblemSeverity.ERROR),
    FCALL_POW_OVERFLOW("The \"pow\" function is applied to values of type \"%s\" and \"%s\", and this could result in integer overflow.", 2, SemanticProblemSeverity.ERROR),
    FCALL_DELETE_OUT_OF_BOUNDS("The \"del\" function is applied to values of type \"%s\" and \"%s\", and this results in an index out of bounds error.", 2, SemanticProblemSeverity.ERROR),
    FCALL_FMT_NOT_PATTERN("The first argument for the \"fmt\" standard library function must be a format pattern (string literal).", 0, SemanticProblemSeverity.ERROR),
    STDLIB_OCCURRENCE("Distribution standard library function \"%s\" may only be used in the initial values of discrete variables, declared in automata.", 1, SemanticProblemSeverity.ERROR),
    GUARD_NON_BOOL("Guard must be of type \"bool\", but is of type \"%s\".", 1, SemanticProblemSeverity.ERROR),
    INIT_NON_BOOL("Initialization predicate must be of type \"bool\", but is of type \"%s\".", 1, SemanticProblemSeverity.ERROR),
    INV_NON_BOOL("Invariant predicate must be of type \"bool\", but is of type \"%s\".", 1, SemanticProblemSeverity.ERROR),
    MARKED_NON_BOOL("Marker predicate must be of type \"bool\", but is of type \"%s\".", 1, SemanticProblemSeverity.ERROR),
    PRINT_TXT_COMP_TYPE("The print declaration %s text is of type \"%s\", which is a component or component definition.", 2, SemanticProblemSeverity.ERROR),
    PRINT_WHEN_NON_BOOL("Print declaration \"when %s\" filter must be of type \"bool\", but is of type \"%s\".", 2, SemanticProblemSeverity.ERROR),
    IFEXPR_INCOMPAT_TYPES("Incompatible result types for if expression: then type \"%s\" is incompatible with %s type \"%s\".", 3, SemanticProblemSeverity.ERROR),
    SWITCH_NO_VALUE_EQ("Values of type \"%s\" do not support value equality, and may not be used as a control value of a switch.", 1, SemanticProblemSeverity.ERROR),
    SWITCH_CASE_KEY_TYPE("The switch \"case\" key is of type \"%s\", which is not compatible with type \"%s\" of the control value of the switch.", 2, SemanticProblemSeverity.ERROR),
    SWITCH_CASE_LOC_ID("The switch \"case\" key must be a name of a location of automaton \"%s\".", 1, SemanticProblemSeverity.ERROR),
    SWITCH_CASE_LOC_REF("The switch \"case\" key refers to \"%s\", which is not a location of automaton \"%s\".", 2, SemanticProblemSeverity.ERROR),
    SWITCH_EXPR_INCOMPAT_TYPES("Incompatible result types for switch expression: type \"%s\" is incompatible with type \"%s\".", 2, SemanticProblemSeverity.ERROR),
    SWITCH_MISSING_ELSE("The switch is missing an \"else\".", 0, SemanticProblemSeverity.ERROR),
    SWITCH_DUPL_CASE("Duplicate switch \"case\" for %s \"%s\".", 2, SemanticProblemSeverity.ERROR),
    SWITCH_MISSING_CASE("Missing switch \"case\" for %s \"%s\".", 2, SemanticProblemSeverity.ERROR),
    SWITCH_MISSING_CASE_LARGE("Missing switch \"case\" for some %s.", 1, SemanticProblemSeverity.ERROR),
    SWITCH_SUPERFLUOUS_ELSE("Switch \"else\" is superfluous, as all %s already have a \"case\".", 1, SemanticProblemSeverity.WARNING),
    SWITCH_SINGLE_CASE("The switch expression has only one case, which is deprecated.", 0, SemanticProblemSeverity.WARNING),
    CONTAINER_EXPR_INCOMPAT_TYPES("Incompatible types \"%s\" and \"%s\" for %s.", 3, SemanticProblemSeverity.ERROR),
    PROJ_CHILD_TYPE("Can't project a value of type \"%s\".", 1, SemanticProblemSeverity.ERROR),
    PROJ_INDEX_TYPE("Can't project a value of type \"%s\", with an index value of type \"%s\", as an index value of type \"%s\"%s is expected.", 4, SemanticProblemSeverity.ERROR),
    PROJ_LIST_OUT_OF_BOUNDS("Can't project a list of type \"%s\", with an index of type \"%s\", as the index is out of bounds for the list.", 2, SemanticProblemSeverity.ERROR),
    PROJ_TUPLE_INDEX_BOUNDS("Can't project a tuple of type \"%s\", with index %s, as the index is out of bounds.", 2, SemanticProblemSeverity.ERROR),
    SLICE_CHILD_TYPE("Can't slice a value of type \"%s\".", 1, SemanticProblemSeverity.ERROR),
    SLICE_IDX_NON_INT("Slice %s index must be of type \"int\".", 1, SemanticProblemSeverity.ERROR),
    BINOP_INVALID_TYPES("Binary operator \"%s\" can not be applied to values of type \"%s\" and \"%s\".", 3, SemanticProblemSeverity.ERROR),
    BINOP_OVERFLOW("Binary operator \"%s\" is applied to values of type \"%s\" and \"%s\", and this could result in integer overflow.", 3, SemanticProblemSeverity.ERROR),
    COMP_INST_ARG_COUNT("The number of arguments (%s) of component instantiation \"%s\" does not match the number of parameters (%s) of component definition \"%s\".", 4, SemanticProblemSeverity.ERROR),
    COMP_INST_ARG_TYPE("Definition/instantiation mismatch: the %s parameter (named \"%s\") of definition \"%s\" requires %s, but the supplied argument of instantiation \"%s\" is not %s.", 6, SemanticProblemSeverity.ERROR),
    COMP_INST_ARG_ALG_TYPES("Definition/instantiation mismatch: the %s parameter (named \"%s\") of definition \"%s\" is an algebraic parameter of type \"%s\", while the supplied argument of instantiation \"%s\" is of type \"%s\".", 6, SemanticProblemSeverity.ERROR),
    COMP_INST_ARG_INPUT_TYPES("Definition/instantiation mismatch: the %s parameter (named \"%s\") of definition \"%s\" is an input parameter of type \"%s\", while the supplied argument of instantiation \"%s\" is of type \"%s\".", 6, SemanticProblemSeverity.ERROR),
    COMP_INST_ARG_COMP_TYPES("Definition/instantiation mismatch: the %s parameter (named \"%s\") of definition \"%s\" is of type \"%s\", while the supplied argument of instantiation \"%s\" is of type \"%s\".", 6, SemanticProblemSeverity.ERROR),
    COMP_INST_ARG_CONTR_MISMATCH("Definition/instantiation mismatch: the %s parameter (named \"%s\") of definition \"%s\" requires %s event, while the event supplied as argument of instantiation \"%s\" is \"%s\".", 6, SemanticProblemSeverity.ERROR),
    COMP_INST_ARG_EVENT_TYPES("Definition/instantiation mismatch: the %s parameter (named \"%s\") of definition \"%s\" requires an event %s, while the event supplied as argument of instantiation \"%s\" %s.", 6, SemanticProblemSeverity.ERROR),
    COMP_INST_ARG_EVENT_FLAG("Definition/instantiation mismatch: the %s parameter (named \"%s\") of definition \"%s\" requires an event that allows %s usage, while the event supplied as argument of instantiation \"%s\" doesn't allow that usage.", 5, SemanticProblemSeverity.ERROR),
    AUT_NO_INIT_LOC("Automaton \"%s\" has no initial location.", 1, SemanticProblemSeverity.WARNING),
    LOC_UNREACHABLE("Location \"%s\" is not reachable from any of the initial locations of automaton \"%s\".", 2, SemanticProblemSeverity.WARNING),
    AUT_DUPL_ALPHABET("Duplicate alphabet definition in automaton \"%s\".", 1, SemanticProblemSeverity.ERROR),
    AUT_DUPL_MONITOR("Duplicate monitor definition in automaton \"%s\".", 1, SemanticProblemSeverity.ERROR),
    LOC_DUPL_URGENT("Duplicate urgent property for %s.", 1, SemanticProblemSeverity.WARNING),
    NAMELESS_LOC_NOT_ALONE("Nameless location in automaton \"%s\" cannot coexist with other locations in the same automaton.", 1, SemanticProblemSeverity.ERROR),
    RESOLVE_NON_EVENT("\"%s\" is not an event.", 1, SemanticProblemSeverity.ERROR),
    RESOLVE_NON_ASGN_VAR("\"%s\" is not a discrete or continuous variable.", 1, SemanticProblemSeverity.ERROR),
    RESOLVE_NON_SVG_ASGN_VAR("\"%s\" is not an input variable.", 1, SemanticProblemSeverity.ERROR),
    RESOLVE_NON_FUNC_VAR("\"%s\" is not a variable or parameter of function \"%s\".", 2, SemanticProblemSeverity.ERROR),
    ALPHABET_NON_SYNC_PARAM("Event parameter \"%s\" does not allow synchronization, and may thus not be in the alphabet of automaton \"%s\".", 2, SemanticProblemSeverity.ERROR),
    ALPHABET_DUPL_EVENT("Duplicate event \"%s\" in alphabet of automaton \"%s\".", 2, SemanticProblemSeverity.WARNING),
    EVENT_AUT_USAGE_CONFLICT("Event \"%s\" is used in automaton \"%s\" to %s and to %s.", 4, SemanticProblemSeverity.ERROR),
    MONITORS_DUPL_EVENT("Duplicate monitor event \"%s\" in automaton \"%s\".", 2, SemanticProblemSeverity.WARNING),
    MONITOR_EVENT_NOT_IN_ALPHABET("Monitor event \"%s\" is not in the alphabet of automaton \"%s\".", 2, SemanticProblemSeverity.ERROR),
    MONITOR_EMPTY_ALPHABET("Monitoring all events in the alphabet of automaton \"%s\" has no effect, as its alphabet is empty.", 1, SemanticProblemSeverity.WARNING),
    EDGE_DUPL_EVENT("Duplicate event \"%s\" on a single edge in automaton \"%s\".", 2, SemanticProblemSeverity.WARNING),
    EDGE_NON_LOC_TARGET("\"%s\" is not a location.", 1, SemanticProblemSeverity.ERROR),
    EDGE_TGT_LOC_PARAM("Target location \"%s\" is a location parameter, while a location of automaton \"%s\" is expected.", 2, SemanticProblemSeverity.ERROR),
    EDGE_EVT_PARAM_ILLEGAL_USE("Event parameter \"%s\" does not allow %s usage.", 2, SemanticProblemSeverity.ERROR),
    CHANNEL_COMM_NON_CHAN("Can't %s over event \"%s\", as the event is not a channel (it has no data type).", 2, SemanticProblemSeverity.ERROR),
    CHANNEL_VOID_WITH_VALUE("Can't send a value over channel \"%s\" of type \"void\".", 1, SemanticProblemSeverity.ERROR),
    CHANNEL_SEND_TYPE_MISMATCH("Can't send a value of type \"%s\" over channel \"%s\" of type \"%s\".", 3, SemanticProblemSeverity.ERROR),
    CHANNEL_NON_VOID_NEED_VALUE("A value to send over the channel is required for channel \"%s\" of type \"%s\".", 2, SemanticProblemSeverity.ERROR),
    EDGE_RCV_EXPECTED("%s may not be combined with receiving over a channel, on the same edge.", 1, SemanticProblemSeverity.ERROR),
    CHANNEL_RCVS_TYPE_MISMATCH("Incompatible types \"%s\" and \"%s\" for received values of channel communications on a single edge.", 2, SemanticProblemSeverity.ERROR),
    EVENT_NOT_IN_ALPHABET("Event \"%s\" is missing in the alphabet of automaton \"%s\".", 2, SemanticProblemSeverity.ERROR),
    ASGN_NON_LOCAL_VAR("Cannot assign variable \"%s\", as it is not declared in automaton \"%s\".", 2, SemanticProblemSeverity.ERROR),
    ASGN_STRING_PROJ("Cannot assign a part of variable \"%s\", as partial updates of \"string\" typed variables are not allowed.", 1, SemanticProblemSeverity.ERROR),
    ASGN_TYPE_VALUE_MISMATCH("The type \"%s\" of the value of the assignment is incompatible with type \"%s\" of the addressable.", 2, SemanticProblemSeverity.ERROR),
    DUPL_VAR_ASGN_EDGE("Variable \"%s\", or a part of it, may have been assigned twice on a single edge, for assignments to \"%s\" and \"%s\".", 3, SemanticProblemSeverity.ERROR),
    DUPL_VAR_ASGN_FUNC("Variable \"%s\", or a part of it, may have been assigned twice in a single assignment, for assignments to \"%s\" and \"%s\"", 3, SemanticProblemSeverity.ERROR),
    DUPL_VAR_ASGN_SVG("Variable \"%s\", or a part of it, may have been assigned twice in a single SVG input mapping, for assignments to \"%s\" and \"%s\"", 3, SemanticProblemSeverity.ERROR),
    EDGE_URG_LOC_URG("Edge is redundantly urgent, since its source location (%s) is also urgent.", 1, SemanticProblemSeverity.WARNING),
    EVAL_FAILURE("Evaluation failure: %s", 1, SemanticProblemSeverity.ERROR),
    UNUSED_DECL("%s \"%s\" is not used anywhere in the specification.", 2, SemanticProblemSeverity.WARNING),
    STAT_UNREACHABLE("Statement is unreachable.", 0, SemanticProblemSeverity.WARNING),
    STAT_NOT_IN_WHILE("The \"%s\" statement may only be used inside \"while\" statements.", 1, SemanticProblemSeverity.ERROR),
    STAT_RETURN_TYPE("The return value of type \"%s\" is incompatible with the return type \"%s\" of function \"%s\".", 3, SemanticProblemSeverity.ERROR),
    FUNC_NOT_END_RETURN("Function \"%s\" does not end with a return statement.", 1, SemanticProblemSeverity.ERROR),
    TIME_IN_FUNC("Invalid use of time dependent variable \"time\" in a function.", 0, SemanticProblemSeverity.ERROR),
    RCVD_VALUE_OCCURRENCE("The received value of a communication is only available in updates of edges that receive a value.", 0, SemanticProblemSeverity.ERROR),
    RCVD_VALUE_VOID("The received value of a communication is not available for channels of type \"void\".", 0, SemanticProblemSeverity.ERROR),
    SELF_OCCURRENCE("Using \"self\" to refer to the automaton itself is not allowed in %s, as it's not an automaton or automaton definition.", 1, SemanticProblemSeverity.ERROR),
    EVENT_OCCURRENCE("Invalid use of event \"%s\" as a variable or a value.", 1, SemanticProblemSeverity.ERROR),
    UNSUPPORTED_EXT_FUNC_LANG("Language \"%s\" is not supported for external user-defined functions.", 1, SemanticProblemSeverity.ERROR),
    CLS_PATH_NOT_FOUND("Class path entry \"%s\" could not be found.", 1, SemanticProblemSeverity.ERROR),
    EXT_FUNC_PARAM_RET_TYPE("The %s %s of function \"%s\" has type \"%s\", which is not supported for external user-defined %s functions.", 5, SemanticProblemSeverity.ERROR),
    SVG_DUPL_FILE("Duplicate SVG image file declared in %s.", 1, SemanticProblemSeverity.ERROR),
    SVG_DECL_NO_FILE("Missing SVG file declaration for a CIF/SVG declaration in %s.", 1, SemanticProblemSeverity.ERROR),
    SVG_FILE_NOT_FOUND("SVG image file \"%s\" could not be found, is a directory, or for some other reason could not be opened for reading.", 1, SemanticProblemSeverity.ERROR),
    SVG_FILE_IO_ERROR("SVG image file \"%s\" could not be read, is empty, is incomplete, is not an SVG file, or is an invalid SVG file.", 1, SemanticProblemSeverity.ERROR),
    SVG_FILE_INVALID_FILE("SVG image file \"%s\" is not an SVG file, is an invalid SVG file, or contains unsupported SVG features.", 1, SemanticProblemSeverity.ERROR),
    SVG_ID_NON_STR("SVG element id must be of type \"string\", but is of type \"%s\".", 1, SemanticProblemSeverity.ERROR),
    SVG_NON_STATIC("%s cannot be evaluated statically.", 1, SemanticProblemSeverity.ERROR),
    SVG_NAME_INVALID("%s \"%s\" is not a valid SVG name%s.", 3, SemanticProblemSeverity.ERROR),
    SVG_UNKNOWN_NAME_ELEM("The SVG element with id \"%s\" in SVG file \"%s\" has name \"%s\", which is not part of the SVG 1.1 standard.", 3, SemanticProblemSeverity.WARNING),
    SVG_UNKNOWN_NAME_ATTR("The SVG element with id \"%s\" in SVG file \"%s\" has name \"%s\", which according to the SVG 1.1 standard does not have a \"%s\" attribute.", 4, SemanticProblemSeverity.WARNING),
    SVG_ATTR_UNSUPPORTED("Changing the \"%s\" attribute of an SVG element is not supported.", 1, SemanticProblemSeverity.ERROR),
    SVG_ELEM_ID_NOT_FOUND("Could not find an SVG element with id \"%s\" in SVG file \"%s\".", 2, SemanticProblemSeverity.ERROR),
    SVG_ELEM_NO_TEXT("The SVG element with id \"%s\" in SVG file \"%s\" is not an element for which text can be set.", 2, SemanticProblemSeverity.ERROR),
    SVG_DUPL_MOVE_ID("Duplicate move declaration for SVG element with id \"%s\" in SVG file \"%s\".", 2, SemanticProblemSeverity.ERROR),
    SVG_DUPL_MOVE_TRANSFORM("The SVG element with id \"%s\" in SVG file \"%s\" is moved, and must therefore not also have an output mapping for its \"transform\" attribute.", 2, SemanticProblemSeverity.ERROR),
    SVG_DUPL_OUTPUT_ID_ATTR("Duplicate output mapping for attribute \"%s\" of the SVG element with id \"%s\" in SVG file \"%s\".", 3, SemanticProblemSeverity.ERROR),
    SVG_DUPL_OUTPUT_TEXT("Duplicate text output for SVG elements with ids \"%s\" and \"%s\" in SVG file \"%s\".", 3, SemanticProblemSeverity.ERROR),
    SVG_DUPL_INPUT_ID("Duplicate input mapping for SVG element with id \"%s\" in SVG file \"%s\".", 2, SemanticProblemSeverity.ERROR),
    SVG_OUT_VALUE_COMP_TYPE("The SVG output mapping value is of type \"%s\", which is a component or component definition.", 1, SemanticProblemSeverity.ERROR),
    SVG_TRANSFORM_OVERWRITE("The SVG output mapping overwrites the current \"transform\" value \"%s\".", 1, SemanticProblemSeverity.WARNING),
    SVG_TRANSFORM_AFFECTED_BY_ANCESTOR("The SVG output mapping specifies a transformation that is combined with transformation \"%s\" of %s.", 2, SemanticProblemSeverity.WARNING),
    FMT_PAT_DECODE_ERR("%s", 1, SemanticProblemSeverity.ERROR),
    FMT_PAT_IDX_OVERFLOW("Invalid format specifier: the explicit index causes integer overflow.", 0, SemanticProblemSeverity.ERROR),
    FMT_PAT_IDX_OUT_OF_RANGE("Invalid format specifier: the %s value is used, which does not exist.", 1, SemanticProblemSeverity.ERROR),
    FMT_PAT_WRONG_TYPE("Invalid \"%%%s\" format specifier: a value of type \"%s\" is required, but the %s value of type \"%s\" is used.", 4, SemanticProblemSeverity.ERROR),
    FMT_PAT_COMP_TYPE("Invalid \"%%%s\" format specifier: the %s value of type \"%s\" is used, which is a component or component definition.", 3, SemanticProblemSeverity.ERROR),
    FMT_PAT_UNUSED_VALUE("The %s value is not used in the format pattern.", 1, SemanticProblemSeverity.WARNING),
    SVG_COPY_NO_PRE_POST("The SVG copy declaration must specify a prefix, a postfix, or both.", 0, SemanticProblemSeverity.ERROR),
    SVG_COPY_NON_STR("The SVG copy declaration %s must have a \"string\" type, but is of type \"%s\".", 2, SemanticProblemSeverity.ERROR),
    SVG_COPY_ROOT("Copying the SVG element with id \"%s\" in SVG file \"%s\" is not supported, as the element is the root element of the SVG file.", 2, SemanticProblemSeverity.ERROR),
    SVG_COPY_OVERLAP("Copying the SVG element with id \"%s\" in SVG file \"%s\" overlaps with copying the SVG element with id \"%s\".", 3, SemanticProblemSeverity.WARNING),
    SVG_COPY_DUPL_ID("Copying the SVG element with id \"%s\" in SVG file \"%s\" resulted in a copy of the SVG element with id \"%s\" to id \"%s\", which already exists.", 4, SemanticProblemSeverity.ERROR),
    SVG_MOVE_NON_NUM("The SVG move declaration %s coordinate must have a numeric type, but is of type \"%s\".", 2, SemanticProblemSeverity.ERROR),
    PRINT_DUPL_FILE("Duplicate print file declared in %s.", 1, SemanticProblemSeverity.ERROR),
    PRINT_DUPL_FOR("Duplicate print declaration \"for\" filter: %s.", 1, SemanticProblemSeverity.WARNING),
    ANNO_SPECIFIC_ERR("Annotation \"%s\": %s", 2, SemanticProblemSeverity.ERROR),
    ANNO_SPECIFIC_WARN("Annotation \"%s\": %s", 2, SemanticProblemSeverity.WARNING),
    ANNO_UNREGISTERED_NAME("Unknown annotation name \"%s\": no annotation provider is registered for it in the current environment.", 1, SemanticProblemSeverity.WARNING),
    ANNO_DUPL_ARG("Duplicate argument \"%s\" for annotation \"%s\".", 2, SemanticProblemSeverity.ERROR),
    ANNO_PROVIDER_ERROR("Annotation \"%s\": %s", 2, SemanticProblemSeverity.ERROR);

    private final String message;
    private final int argCount;
    private final SemanticProblemSeverity severity;

    private ErrMsg(String message, int argCount, SemanticProblemSeverity severity) {
        this.message = message;
        this.argCount = argCount;
        this.severity = severity;
    }

    public SemanticProblemSeverity getSeverity() {
        return this.severity;
    }

    public String format(String ... args) {
        Assert.check((args.length == this.argCount ? 1 : 0) != 0);
        return Strings.fmt((String)this.message, (Object[])args);
    }
}

