/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.options;

import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.java.Strings;

public class SimulinkSampleOffsetOption
extends StringOption {
    private static final String NAME = "Simulink sample offset";
    private static final String OPT_DIALOG_DESCR = "Set Simulink sample offset. Possible values are \"fixed\" or a floating point sample offset.";
    private static final String DEFAULT_VALUE = "0.0";
    private static final boolean EMPTY_AS_NULL = false;
    private static final String DESCRIPTION = Strings.fmt((String)"%s [DEFAULT=%s]", (Object[])new Object[]{"Set Simulink sample offset. Possible values are \"fixed\" or a floating point sample offset.", "0.0"});
    private static final Character CMD_SHORT = null;
    private static final String CMD_LONG = "simulink-sample-offset";
    private static final String CMD_VALUE = "OFFSET";
    private static final boolean SHOW_IN_DIALOG = true;
    private static final String OPT_DIALOG_TEXT = "Sample offset:";

    public SimulinkSampleOffsetOption() {
        super(NAME, DESCRIPTION, CMD_SHORT, CMD_LONG, CMD_VALUE, DEFAULT_VALUE, false, true, OPT_DIALOG_DESCR, OPT_DIALOG_TEXT);
    }

    public static String getSampleOffset() {
        return Strings.makeUppercase((String)((String)Options.get(SimulinkSampleOffsetOption.class)));
    }

    public static boolean sampleOffsetIsFixed() {
        String value = SimulinkSampleOffsetOption.getSampleOffset();
        return value.equals("FIXED");
    }

    public static Double offsetGetValue() {
        try {
            Double d = Double.parseDouble(SimulinkSampleOffsetOption.getSampleOffset());
            return d;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static boolean sampleOffsetIsZero() {
        Double d = SimulinkSampleOffsetOption.offsetGetValue();
        if (d != null) {
            return d == 0.0;
        }
        return false;
    }

    public static boolean sampleOffsetIsValidReal() {
        Double d = SimulinkSampleOffsetOption.offsetGetValue();
        if (d != null) {
            return d >= 0.0;
        }
        return false;
    }
}

