/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks;

import com.github.javabdd.BDDFactory;
import java.util.Collections;
import java.util.EnumSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.bdd.conversion.CifToBddConverter;
import org.eclipse.escet.cif.bdd.settings.AllowNonDeterminism;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.settings.CifBddStatistics;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.CifBddApplyPlantInvariants;
import org.eclipse.escet.cif.cif2cif.RelabelSupervisorsAsPlants;
import org.eclipse.escet.cif.controllercheck.ControllerCheckerSettings;
import org.eclipse.escet.cif.controllercheck.checks.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.ControllerCheckerCheck;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public abstract class ControllerCheckerBddBasedCheck<T extends CheckConclusion>
implements ControllerCheckerCheck<T> {
    public static final int SATURATION_INSTANCE_NONBLOCKING_CCP = 1;
    public static final int SATURATION_INSTANCE_NONBLOCKING_BAD = 2;

    @Override
    public T performCheck(Specification spec, String specAbsPath, ControllerCheckerSettings checkerSettings) {
        Termination termination = checkerSettings.getTermination();
        DebugNormalOutput debugOutput = checkerSettings.getDebugOutput();
        debugOutput.line("Converting CIF specification to a BDD representation:");
        debugOutput.inc();
        CifBddSpec cifBddSpec = this.convertToBdd(spec, specAbsPath, checkerSettings);
        debugOutput.dec();
        debugOutput.line();
        termination.throwIfRequested();
        return this.performCheck(cifBddSpec);
    }

    protected abstract T performCheck(CifBddSpec var1);

    private CifBddSpec convertToBdd(Specification spec, String specAbsPath, ControllerCheckerSettings checkerSettings) {
        Termination termination = checkerSettings.getTermination();
        spec = (Specification)EMFHelper.deepclone((EObject)spec);
        termination.throwIfRequested();
        new RelabelSupervisorsAsPlants().transform(spec);
        CifBddSettings cifBddSettings = this.createCifBddSettings(checkerSettings);
        cifBddSettings.setModificationAllowed(false);
        CifToBddConverter converter = new CifToBddConverter("CIF controller properties checker");
        converter.preprocess(spec, specAbsPath, cifBddSettings.getWarnOutput(), cifBddSettings.getDoPlantsRefReqsWarn(), cifBddSettings.getTermination());
        BDDFactory factory = CifToBddConverter.createFactory((CifBddSettings)cifBddSettings, Collections.emptyList(), Collections.emptyList());
        CifBddSpec cifBddSpec = converter.convert(spec, cifBddSettings, factory);
        termination.throwIfRequested();
        cifBddSpec.freeIntermediateBDDs(true);
        termination.throwIfRequested();
        CifBddApplyPlantInvariants.applyStateEvtExclPlantsInvs((CifBddSpec)cifBddSpec, (String)"system", () -> null, (boolean)cifBddSettings.getDebugOutput().isEnabled());
        termination.throwIfRequested();
        for (CifBddEdge edge : cifBddSpec.edges) {
            edge.initApply();
            termination.throwIfRequested();
        }
        return cifBddSpec;
    }

    protected CifBddSettings createCifBddSettings(ControllerCheckerSettings checkerSettings) {
        CifBddSettings cifBddSettings = new CifBddSettings();
        cifBddSettings.setTermination(checkerSettings.getTermination());
        cifBddSettings.setDebugOutput(checkerSettings.getDebugOutput());
        cifBddSettings.setNormalOutput(checkerSettings.getNormalOutput());
        cifBddSettings.setWarnOutput(checkerSettings.getWarnOutput());
        cifBddSettings.setIndentAmount(4);
        cifBddSettings.setCifBddStatistics(EnumSet.noneOf(CifBddStatistics.class));
        cifBddSettings.setDoPlantsRefReqsWarn(false);
        cifBddSettings.setAllowNonDeterminism(AllowNonDeterminism.UNCONTROLLABLE);
        return cifBddSettings;
    }
}

