/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.Format;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.Styler;

public abstract class AxisTickCalculator_
implements AxisTickCalculator {
    final List<Double> tickLocations = new LinkedList<Double>();
    final List<String> tickLabels = new LinkedList<String>();
    final Axis.Direction axisDirection;
    final double workingSpace;
    final double minValue;
    final double maxValue;
    List<Double> axisValues;
    final AxesChartStyler styler;
    Format axisFormat;

    AxisTickCalculator_(Axis.Direction axisDirection, double workingSpace, double minValue, double maxValue, AxesChartStyler styler) {
        this.axisDirection = axisDirection;
        this.workingSpace = workingSpace;
        this.minValue = AxisTickCalculator_.getAxisMinValue(styler, axisDirection, minValue);
        this.maxValue = AxisTickCalculator_.getAxisMaxValue(styler, axisDirection, maxValue);
        this.styler = styler;
    }

    AxisTickCalculator_(Axis.Direction axisDirection, double workingSpace, double minValue, double maxValue, List<Double> axisValues, AxesChartStyler styler) {
        this.axisDirection = axisDirection;
        this.workingSpace = workingSpace;
        LinkedHashSet<Double> axisValuesWithMinMax = new LinkedHashSet<Double>();
        axisValuesWithMinMax.add(minValue);
        axisValuesWithMinMax.addAll(axisValues);
        axisValuesWithMinMax.add(maxValue);
        this.axisValues = new ArrayList<Double>(axisValuesWithMinMax);
        this.minValue = AxisTickCalculator_.getAxisMinValue(styler, axisDirection, minValue);
        this.maxValue = AxisTickCalculator_.getAxisMaxValue(styler, axisDirection, maxValue);
        this.styler = styler;
    }

    double getFirstPosition(double gridStep) {
        return this.minValue - this.minValue % gridStep - gridStep;
    }

    @Override
    public List<Double> getTickLocations() {
        return this.tickLocations;
    }

    @Override
    public List<String> getTickLabels() {
        return this.tickLabels;
    }

    boolean willLabelsFitInTickSpaceHint(List<String> tickLabels, int tickSpacingHint) {
        String sampleLabel = "Y";
        if (Axis.Direction.X.equals((Object)this.axisDirection)) {
            for (String tickLabel : tickLabels) {
                if (tickLabel == null || tickLabel.length() <= sampleLabel.length()) continue;
                sampleLabel = tickLabel;
            }
        }
        TextLayout textLayout = new TextLayout(sampleLabel, this.styler.getAxisTickLabelsFont(), new FontRenderContext(null, true, false));
        AffineTransform rot = this.styler.getXAxisLabelRotation() == 0 ? null : AffineTransform.getRotateInstance(-1.0 * Math.toRadians(this.styler.getXAxisLabelRotation()));
        Shape shape = textLayout.getOutline(rot);
        Rectangle rectangle = shape.getBounds();
        double largestLabelWidth = Axis.Direction.X.equals((Object)this.axisDirection) ? ((RectangularShape)rectangle).getWidth() : ((RectangularShape)rectangle).getHeight();
        return largestLabelWidth * 1.1 < (double)tickSpacingHint;
    }

    @Override
    public Format getAxisFormat() {
        return this.axisFormat;
    }

    protected void calculate() {
        int gridStepInChartSpace;
        if (this.minValue == this.maxValue) {
            this.tickLabels.add(this.getAxisFormat().format(BigDecimal.valueOf(this.maxValue).doubleValue()));
            this.tickLocations.add(this.workingSpace / 2.0);
            return;
        }
        if (this.minValue > this.maxValue && this.minValue == Double.MAX_VALUE) {
            this.tickLabels.add(this.getAxisFormat().format(0.0));
            this.tickLocations.add(this.workingSpace / 2.0);
            return;
        }
        double tickSpace = this.styler.getPlotContentSize() * this.workingSpace;
        if (this.axisDirection == Axis.Direction.X && tickSpace < (double)this.styler.getXAxisTickMarkSpacingHint()) {
            return;
        }
        if (this.axisDirection == Axis.Direction.Y && tickSpace < (double)this.styler.getYAxisTickMarkSpacingHint()) {
            return;
        }
        double margin = Utils.getTickStartOffset(this.workingSpace, tickSpace);
        double span = Math.abs(Math.min(this.maxValue - this.minValue, Double.MAX_VALUE));
        if (this.axisValues != null && this.areValuesEquallySpaced(this.axisValues)) {
            this.calculateForEquallySpacedAxisValues(tickSpace, margin);
            return;
        }
        int tickSpacingHint = (this.axisDirection == Axis.Direction.X ? this.styler.getXAxisTickMarkSpacingHint() : this.styler.getYAxisTickMarkSpacingHint()) - 5;
        if (this.axisDirection == Axis.Direction.Y && tickSpace < 160.0) {
            tickSpacingHint = 20;
        }
        do {
            BigDecimal cleanedFirstPosition;
            this.tickLabels.clear();
            this.tickLocations.clear();
            double significand = span / tickSpace * (double)(tickSpacingHint += 5);
            int exponent = 0;
            if (significand == 0.0) {
                exponent = 1;
            } else if (significand < 1.0) {
                while (significand < 1.0) {
                    significand *= 10.0;
                    --exponent;
                }
            } else {
                while (significand >= 10.0 || significand == Double.NEGATIVE_INFINITY) {
                    significand /= 10.0;
                    ++exponent;
                }
            }
            double gridStep = significand > 7.5 ? 10.0 * Utils.pow(10.0, exponent) : (significand > 3.5 ? 5.0 * Utils.pow(10.0, exponent) : (significand > 1.5 ? 2.0 * Utils.pow(10.0, exponent) : Utils.pow(10.0, exponent)));
            gridStepInChartSpace = (int)(gridStep / span * tickSpace);
            BigDecimal gridStepBigDecimal = new BigDecimal(gridStep, MathContext.DECIMAL64);
            int scale = Math.min(10, gridStepBigDecimal.scale());
            BigDecimal cleanedGridStep0 = gridStepBigDecimal.setScale(scale, RoundingMode.HALF_UP).stripTrailingZeros();
            BigDecimal cleanedGridStep = cleanedGridStep0.setScale(scale, RoundingMode.HALF_DOWN).stripTrailingZeros();
            BigDecimal firstPosition = null;
            double firstPositionAsDouble = this.getFirstPosition(cleanedGridStep.doubleValue());
            if (Double.isNaN(firstPositionAsDouble)) {
                this.tickLabels.add(this.getAxisFormat().format(BigDecimal.valueOf((this.maxValue + this.minValue) / 2.0)));
                double averageValue = (this.maxValue + this.minValue) / 2.0;
                this.tickLocations.add(this.workingSpace / 2.0);
                return;
            }
            if (firstPositionAsDouble == Double.NEGATIVE_INFINITY) {
                firstPosition = BigDecimal.valueOf(-1.7976931348623157E308);
            } else {
                try {
                    firstPosition = BigDecimal.valueOf(firstPositionAsDouble);
                }
                catch (NumberFormatException e) {
                    System.out.println("Some debug stuff. This happens once in a blue moon, and I don't know why.");
                    System.out.println("scale: " + scale);
                    System.out.println("exponent: " + exponent);
                    System.out.println("gridStep: " + gridStep);
                    System.out.println("cleanedGridStep: " + cleanedGridStep);
                    System.out.println("cleanedGridStep.doubleValue(): " + cleanedGridStep.doubleValue());
                    System.out.println("NumberFormatException caused by this number: " + this.getFirstPosition(cleanedGridStep.doubleValue()));
                }
            }
            BigDecimal value = cleanedFirstPosition = firstPosition.setScale(10, RoundingMode.HALF_UP).stripTrailingZeros();
            while (value.compareTo(BigDecimal.valueOf(this.maxValue + 2.0 * cleanedGridStep.doubleValue() == Double.POSITIVE_INFINITY ? Double.MAX_VALUE : this.maxValue + 2.0 * cleanedGridStep.doubleValue())) < 0) {
                String tickLabel = this.getAxisFormat().format(value.doubleValue());
                this.tickLabels.add(tickLabel);
                double tickLabelPosition = margin + (value.doubleValue() - this.minValue) / (this.maxValue - this.minValue) * tickSpace;
                this.tickLocations.add(tickLabelPosition);
                value = value.add(cleanedGridStep);
            }
        } while (!this.areAllTickLabelsUnique(this.tickLabels) || !this.willLabelsFitInTickSpaceHint(this.tickLabels, gridStepInChartSpace));
    }

    private boolean areValuesEquallySpaced(List<Double> values) {
        if (values.size() < 2) {
            return false;
        }
        double space = values.get(1) - values.get(0);
        double threshold = 1.0E-4;
        if (threshold > Math.abs(this.maxValue - this.minValue)) {
            return false;
        }
        return IntStream.range(1, values.size()).mapToDouble(i -> (Double)values.get(i) - (Double)values.get(i - 1)).allMatch(x -> Math.abs(x - space) < threshold);
    }

    private void calculateForEquallySpacedAxisValues(double tickSpace, double margin) {
        List tickLabelValues;
        int gridStepInChartSpace;
        if (this.axisValues == null) {
            throw new IllegalStateException("No axis values.");
        }
        int tickValuesHint = 0;
        do {
            this.tickLabels.clear();
            int finalTickValuesHint = ++tickValuesHint;
            tickLabelValues = IntStream.range(0, this.axisValues.size()).filter(it -> it % finalTickValuesHint == 0).mapToDouble(this.axisValues::get).boxed().collect(Collectors.toList());
            double tickLabelMaxValue = tickLabelValues.stream().mapToDouble(x -> x).max().orElse(this.maxValue);
            double tickLabelMinValue = tickLabelValues.stream().mapToDouble(x -> x).min().orElse(this.minValue);
            this.tickLabels.addAll(tickLabelValues.stream().map(x -> this.getAxisFormat().format(x)).collect(Collectors.toList()));
            double span = Math.abs(Math.min(tickLabelMaxValue - tickLabelMinValue, Double.MAX_VALUE));
            double gridStep = span / (double)(tickLabelValues.size() - 1);
            gridStepInChartSpace = (int)(gridStep / span * tickSpace);
        } while (!this.areAllTickLabelsUnique(this.tickLabels) || !this.willLabelsFitInTickSpaceHint(this.tickLabels, gridStepInChartSpace));
        this.tickLocations.clear();
        this.tickLocations.addAll(tickLabelValues.stream().map(value -> margin + (value - this.minValue) / (this.maxValue - this.minValue) * tickSpace).collect(Collectors.toList()));
    }

    boolean areAllTickLabelsUnique(List<?> tickLabels) {
        return new LinkedHashSet(tickLabels).size() == tickLabels.size();
    }

    private static double getAxisMinValue(Styler styler, Axis.Direction axisDirection, double dataMinValue) {
        CategoryStyler categoryStyler;
        if (styler instanceof CategoryStyler && ((categoryStyler = (CategoryStyler)styler).getDefaultSeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.Bar || categoryStyler.getDefaultSeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.Stick) && dataMinValue > 0.0) {
            return 0.0;
        }
        return dataMinValue;
    }

    private static double getAxisMaxValue(Styler styler, Axis.Direction axisDirection, double dataMaxValue) {
        if (Axis.Direction.Y.equals((Object)axisDirection) && styler instanceof CategoryStyler && dataMaxValue < 0.0) {
            return 0.0;
        }
        return dataMaxValue;
    }
}

