/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.support;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.ui.behavior.fsm.provider.BaseDiagramProvider;
import org.eclipse.etrice.ui.behavior.fsm.support.IPositionProvider;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@FinalFieldsConstructor
public class BaseDiagramPositionProvider
implements IPositionProvider {
    private final BaseDiagramProvider baseDiagram;
    private int x;
    private int y;
    private double sx;
    private double sy;

    public int getMargin(StateGraphNode node) {
        int n = 0;
        boolean bl = false;
        if (node instanceof State) {
            bl = true;
            n = 30;
        }
        if (!bl && node instanceof TrPoint) {
            bl = true;
            n = 40;
        }
        if (!bl) {
            n = 0;
        }
        return n;
    }

    public int getMargin(StateGraph graph) {
        return 0;
    }

    private IPositionProvider.PosAndSize toPosAndSize(PictogramElement pe, int margin) {
        IPositionProvider.PosAndSize posAndSize = null;
        EObject eObject = pe.eContainer();
        GraphicsAlgorithm borderGa = (GraphicsAlgorithm)IterableExtensions.head((Iterable)((PictogramElement)eObject).getGraphicsAlgorithm().getGraphicsAlgorithmChildren());
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        int n = ga.getX();
        int n2 = borderGa.getWidth();
        double d = (double)n / (double)n2;
        double d2 = d * this.sx;
        double x = d2 + (double)margin;
        int n3 = ga.getY();
        int n4 = borderGa.getHeight();
        double d3 = (double)n3 / (double)n4;
        double d4 = d3 * this.sy;
        double y = d4 + (double)margin;
        int n5 = ga.getWidth();
        int n6 = n5 - 2 * margin;
        int n7 = borderGa.getWidth();
        double d5 = (double)n6 / (double)n7;
        double width = d5 * this.sx;
        int n8 = ga.getHeight();
        int n9 = n8 - 2 * margin;
        int n10 = borderGa.getHeight();
        double d6 = (double)n9 / (double)n10;
        double height = d6 * this.sy;
        posAndSize = new IPositionProvider.PosAndSize((int)x, (int)y, (int)width, (int)height);
        return posAndSize;
    }

    @Override
    public IPositionProvider.PosAndSize getGraphPosAndSize(StateGraph sg) {
        IPositionProvider.PosAndSize posAndSize = null;
        Functions.Function1 function1 = it -> {
            EObject eObject = this.getParentBo((PictogramElement)it);
            return eObject instanceof ModelComponent;
        };
        PictogramElement pe = (PictogramElement)IterableExtensions.findFirst(this.baseDiagram.getPictograms((EObject)sg), (Functions.Function1)function1);
        IPositionProvider.PosAndSize posAndSize2 = null;
        if (pe != null) {
            IPositionProvider.PosAndSize posAndSize3 = null;
            GraphicsAlgorithm visibleGa = (GraphicsAlgorithm)IterableExtensions.head((Iterable)pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren());
            int n = pe.getGraphicsAlgorithm().getX();
            int n2 = pe.getGraphicsAlgorithm().getY();
            int n3 = visibleGa.getWidth();
            int n4 = visibleGa.getHeight();
            posAndSize2 = posAndSize3 = new IPositionProvider.PosAndSize(n, n2, n3, n4);
        }
        posAndSize = posAndSize2;
        return posAndSize;
    }

    @Override
    public List<IPositionProvider.Pos> getPoints(Transition trans) {
        ArrayList arrayList = null;
        PictogramElement pe = (PictogramElement)IterableExtensions.head(this.baseDiagram.getPictograms((EObject)trans));
        ArrayList arrayList2 = CollectionLiterals.newArrayList();
        Procedures.Procedure1 procedure1 = pointList -> {
            if (pe instanceof Connection) {
                EObject eObject = trans.eContainer();
                IPositionProvider.PosAndSize graphPosAndSize = this.getGraphPosAndSize((StateGraph)eObject);
                Functions.Function1 function1 = it -> it.getGraphicsAlgorithm();
                Text text = (Text)IterableExtensions.head((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)((Connection)pe).getConnectionDecorators(), (Functions.Function1)function1), Text.class));
                if (text != null) {
                    int n = text.getX();
                    int n2 = graphPosAndSize.getWidth();
                    double d = (double)n / (double)n2;
                    double d2 = d * this.sx;
                    int n3 = text.getY();
                    int n4 = graphPosAndSize.getHeight();
                    double d3 = (double)n3 / (double)n4;
                    double d4 = d3 * this.sy;
                    IPositionProvider.Pos pos = new IPositionProvider.Pos((int)d2, (int)d4);
                    pointList.add(pos);
                    if (pe instanceof FreeFormConnection) {
                        Functions.Function1 function12 = pt -> {
                            int n = pt.getX();
                            int n2 = graphPosAndSize.getWidth();
                            double d = (double)n / (double)n2;
                            double d2 = d * this.sx;
                            double d3 = d2 + (double)this.x;
                            int n3 = (int)d3 - 40;
                            int n4 = pt.getY();
                            int n5 = graphPosAndSize.getHeight();
                            double d4 = (double)n4 / (double)n5;
                            double d5 = d4 * this.sy;
                            double d6 = d5 + (double)this.y;
                            int n6 = (int)d6 - 40;
                            return new IPositionProvider.Pos(n3, n6);
                        };
                        List list = ListExtensions.map((List)((FreeFormConnection)pe).getBendpoints(), (Functions.Function1)function12);
                        Iterables.addAll((Collection)pointList, (Iterable)list);
                    }
                }
            }
        };
        arrayList = (ArrayList)ObjectExtensions.operator_doubleArrow((Object)arrayList2, (Procedures.Procedure1)procedure1);
        return arrayList;
    }

    @Override
    public IPositionProvider.PosAndSize getPosition(StateGraphNode node) {
        Functions.Function1 function1;
        Functions.Function1 getBasePos = function1 = it -> {
            Functions.Function1 function1 = it_1 -> {
                EObject eObject = this.getParentBo((PictogramElement)it_1);
                return eObject instanceof StateGraph;
            };
            PictogramElement pictogramElement = (PictogramElement)IterableExtensions.findFirst(this.baseDiagram.getPictograms((EObject)it), (Functions.Function1)function1);
            IPositionProvider.PosAndSize posAndSize = null;
            if (pictogramElement != null) {
                posAndSize = this.toPosAndSize(pictogramElement, this.getMargin(node));
            }
            return posAndSize;
        };
        IPositionProvider.PosAndSize posAndSize = null;
        if (node instanceof RefinedState) {
            IPositionProvider.PosAndSize posAndSize2;
            IPositionProvider.PosAndSize posAndSize3 = null;
            IPositionProvider.PosAndSize posAndSize4 = (IPositionProvider.PosAndSize)getBasePos.apply((Object)node);
            posAndSize3 = posAndSize4 != null ? posAndSize4 : (posAndSize2 = (IPositionProvider.PosAndSize)getBasePos.apply((Object)((RefinedState)node).getTarget()));
            posAndSize = posAndSize3;
        } else {
            posAndSize = (IPositionProvider.PosAndSize)getBasePos.apply((Object)node);
        }
        return posAndSize;
    }

    @Override
    public StateGraph getInitialPoint(StateGraph stateGraph) {
        EObject sourceAnchorBo;
        PictogramElement initTransPe = (PictogramElement)IterableExtensions.head(this.baseDiagram.getPictograms((EObject)IterableExtensions.head((Iterable)Iterables.filter((Iterable)stateGraph.getTransitions(), InitialTransition.class))));
        if (initTransPe instanceof Connection && (sourceAnchorBo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)((Connection)initTransPe).getStart())) instanceof StateGraph) {
            return (StateGraph)sourceAnchorBo;
        }
        return null;
    }

    @Override
    public IPositionProvider.PosAndSize getPosition(StateGraph graph) {
        Functions.Function1 function1 = it -> {
            EObject eObject = this.getParentBo((PictogramElement)it);
            return eObject instanceof StateGraph;
        };
        PictogramElement pictogramElement = (PictogramElement)IterableExtensions.findFirst(this.baseDiagram.getPictograms((EObject)graph), (Functions.Function1)function1);
        IPositionProvider.PosAndSize posAndSize = null;
        if (pictogramElement != null) {
            posAndSize = this.toPosAndSize(pictogramElement, this.getMargin(graph));
        }
        return posAndSize;
    }

    @Override
    public <T extends StateGraphNode> List<IPositionProvider.PosAndSize> getPositions(List<T> items) {
        Functions.Function1 function1 = it -> {
            PictogramElement pictogramElement = (PictogramElement)IterableExtensions.head(this.baseDiagram.getPictograms((EObject)it));
            IPositionProvider.PosAndSize posAndSize = null;
            if (pictogramElement != null) {
                posAndSize = this.toPosAndSize(pictogramElement, this.getMargin((StateGraphNode)it));
            }
            return posAndSize;
        };
        return ListExtensions.map(items, (Functions.Function1)function1);
    }

    @Override
    public double[] getSubPosition(StateGraphNode subNode) {
        Functions.Function1 function1 = it -> {
            EObject eObject = this.getParentBo((PictogramElement)it);
            return eObject instanceof State;
        };
        PictogramElement pe = (PictogramElement)IterableExtensions.findFirst(this.baseDiagram.getPictograms((EObject)subNode), (Functions.Function1)function1);
        if (pe != null) {
            EObject eObject = pe.eContainer();
            PictogramElement parentPe = (PictogramElement)eObject;
            int n = pe.getGraphicsAlgorithm().getX();
            int n2 = parentPe.getGraphicsAlgorithm().getWidth();
            int n3 = n2 - 60;
            double relX = (double)n / (double)n3;
            int n4 = pe.getGraphicsAlgorithm().getY();
            int n5 = parentPe.getGraphicsAlgorithm().getHeight();
            int n6 = n5 - 60;
            double relY = (double)n4 / (double)n6;
            return new double[]{relX, relY};
        }
        return null;
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setScale(double sx, double sy) {
        this.sx = sx;
        this.sy = sy;
    }

    private EObject getParentBo(PictogramElement pe) {
        EObject eObject = pe.eContainer();
        return Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)eObject);
    }

    public BaseDiagramPositionProvider(BaseDiagramProvider baseDiagram) {
        this.baseDiagram = baseDiagram;
    }
}

