/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.actioneditor;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.etrice.expressions.detailcode.IDetailExpressionProvider;
import org.eclipse.etrice.ui.behavior.fsm.Activator;
import org.eclipse.etrice.ui.behavior.fsm.actioneditor.IActionCodeEditor;
import org.eclipse.etrice.ui.behavior.fsm.actioneditor.IActionCodeEditorFactory;
import org.eclipse.swt.widgets.Composite;

public class ActionCodeEditorRegistry {
    public static final ActionCodeEditorRegistry INSTANCE = new ActionCodeEditorRegistry();
    public static final String TAG_EDITOR = "editor";
    public static final String ATT_NAME = "editorName";
    public static final String ATT_CLASS = "class";
    public static final String ATT_ID = "id";
    public static final String ATT_TARGET_LANGUAGE = "targetLanguage";
    public static final String TARGET_LANGUAGE_ALL = "ALL";
    public static final String TARGET_LANGUAGE_JAVA = "JAVA";
    public static final String TARGET_LANGUAGE_CPP = "C++";
    public static final String TARGET_LANGUAGE_OTHER = "OTHER";
    private ActionCodeEditorRegistryEntry[] cachedEditorEntries;

    private ActionCodeEditorRegistry() {
    }

    public ActionCodeEditorRegistryEntry getEditorWithId(String id) {
        ActionCodeEditorRegistryEntry[] entries;
        ActionCodeEditorRegistryEntry[] actionCodeEditorRegistryEntryArray = entries = this.getEditors();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ActionCodeEditorRegistryEntry entry = actionCodeEditorRegistryEntryArray[n2];
            if (entry.getId().equals(id)) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    public ActionCodeEditorRegistryEntry[] getEditorsForTargetLanguage(String targetLanguage) {
        ActionCodeEditorRegistryEntry[] entries = this.getEditors();
        ArrayList<ActionCodeEditorRegistryEntry> found = new ArrayList<ActionCodeEditorRegistryEntry>();
        ActionCodeEditorRegistryEntry[] actionCodeEditorRegistryEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ActionCodeEditorRegistryEntry entry = actionCodeEditorRegistryEntryArray[n2];
            String editorTargetLanguage = entry.getTargetLanguage();
            if (editorTargetLanguage.equals(targetLanguage) || editorTargetLanguage.equals(TARGET_LANGUAGE_ALL)) {
                found.add(entry);
            }
            ++n2;
        }
        return found.toArray(new ActionCodeEditorRegistryEntry[found.size()]);
    }

    public ActionCodeEditorRegistryEntry[] getEditors() {
        if (this.cachedEditorEntries != null) {
            return this.cachedEditorEntries;
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.etrice.ui.behavior.fsm", "actionCodeEditor").getExtensions();
        ArrayList<ActionCodeEditorRegistryEntry> found = new ArrayList<ActionCodeEditorRegistryEntry>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElement = iConfigurationElementArray[n4];
                ActionCodeEditorRegistryEntry entry = this.parseEditorEntries(configElement);
                if (entry != null) {
                    found.add(entry);
                }
                ++n4;
            }
            ++n2;
        }
        this.cachedEditorEntries = found.toArray(new ActionCodeEditorRegistryEntry[found.size()]);
        return this.cachedEditorEntries;
    }

    private ActionCodeEditorRegistryEntry parseEditorEntries(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_EDITOR)) {
            return null;
        }
        try {
            return new ActionCodeEditorRegistryEntry(configElement);
        }
        catch (Exception e) {
            String id = configElement.getAttribute(ATT_ID);
            if (id == null) {
                id = "[missing id attribute]";
            }
            String msg = "Failed to load action code editor with id " + id + " in " + configElement.getDeclaringExtension().getNamespaceIdentifier();
            Activator.getDefault().getLog().log((IStatus)new MultiStatus("org.eclipse.etrice.ui.behavior.fsm", 4, msg, (Throwable)e));
            return null;
        }
    }

    public void dispose() {
        if (this.cachedEditorEntries == null) {
            return;
        }
        int i = 0;
        while (i < this.cachedEditorEntries.length) {
            this.cachedEditorEntries[i].dispose();
            ++i;
        }
        this.cachedEditorEntries = null;
    }

    private static String getAttribute(IConfigurationElement configElem, String attrName) {
        String value = configElem.getAttribute(attrName);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Missing " + attrName + " attribute");
    }

    public class ActionCodeEditorRegistryEntry {
        private IConfigurationElement configElem;
        private final String name;
        private final String id;
        private final String targetLanguage;
        private IActionCodeEditorFactory factory;

        public ActionCodeEditorRegistryEntry(IConfigurationElement configElem) {
            this.configElem = configElem;
            this.name = ActionCodeEditorRegistry.getAttribute(configElem, ActionCodeEditorRegistry.ATT_NAME);
            this.id = ActionCodeEditorRegistry.getAttribute(configElem, ActionCodeEditorRegistry.ATT_ID);
            this.targetLanguage = ActionCodeEditorRegistry.getAttribute(configElem, ActionCodeEditorRegistry.ATT_TARGET_LANGUAGE);
            ActionCodeEditorRegistry.getAttribute(configElem, ActionCodeEditorRegistry.ATT_CLASS);
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public String getTargetLanguage() {
            return this.targetLanguage;
        }

        public IActionCodeEditor newActionCodeEditor(Composite parent, String text, IDetailExpressionProvider exprProvider) {
            IActionCodeEditorFactory factory = this.getFactory();
            if (factory == null) {
                return null;
            }
            return factory.createActionCodeEditor(parent, text, exprProvider);
        }

        private IActionCodeEditorFactory getFactory() {
            if (this.factory != null) {
                return this.factory;
            }
            try {
                this.factory = (IActionCodeEditorFactory)this.configElem.createExecutableExtension(ActionCodeEditorRegistry.ATT_CLASS);
            }
            catch (Exception e) {
                MultiStatus status = new MultiStatus("org.eclipse.etrice.ui.behavior.fsm", 4, "Failed to instantiate factory: " + this.configElem.getAttribute(ActionCodeEditorRegistry.ATT_CLASS) + " in id: " + this.id + " in plugin: " + this.configElem.getDeclaringExtension().getNamespaceIdentifier(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            return this.factory;
        }

        public void dispose() {
            if (this.factory == null) {
                return;
            }
            this.factory.dispose();
            this.factory = null;
        }

        protected ActionCodeEditorRegistryEntry() {
            this.name = "Unknown";
            this.id = "Unknown";
            this.targetLanguage = ActionCodeEditorRegistry.TARGET_LANGUAGE_OTHER;
            this.configElem = null;
        }
    }
}

