/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.meta.features.update;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fmc.blockdiagram.editor.algorithm.connection.FMCConnectionAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.meta.features.update.FMCConnectionUpdateFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.profile.IStereotypeProvider;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.mm.Access;
import org.eclipse.fmc.mm.AccessType;
import org.eclipse.fmc.mm.Agent;
import org.eclipse.fmc.mm.DataflowDirection;
import org.eclipse.fmc.mm.FMCConnection;
import org.eclipse.fmc.mm.Storage;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class AccessUpdateFeature
extends FMCConnectionUpdateFeature {
    public AccessUpdateFeature(IFeatureProvider fp, IStereotypeProvider stereotypeProvider) {
        super(fp, stereotypeProvider);
    }

    public boolean update(IUpdateContext context) {
        Connection conShape = (Connection)context.getPictogramElement();
        FMCConnectionAlgorithm algorithm = this.factory.getAlgorithm((PictogramElement)conShape);
        Access access = (Access)FMCUtil.getBO((PictogramElement)context.getPictogramElement());
        EObject start = FMCUtil.getBO((PictogramElement)conShape.getStart().getParent());
        if (!this.equalsAccessType(conShape, access)) {
            switch (access.getType()) {
                case UNSPECIFIED: {
                    algorithm.setDirection(conShape, DataflowDirection.UNSPECIFIED, this.getDiagram());
                    break;
                }
                case READ: {
                    algorithm.setDirection(conShape, start instanceof Agent ? DataflowDirection.OTHER : DataflowDirection.DEFAULT, this.getDiagram());
                    break;
                }
                case WRITE: {
                    algorithm.setDirection(conShape, start instanceof Storage ? DataflowDirection.OTHER : DataflowDirection.DEFAULT, this.getDiagram());
                    break;
                }
            }
        }
        return false;
    }

    @Override
    protected IReason updateNeeded(Connection conShape, FMCConnection connection) {
        Access access = (Access)connection;
        if (!this.equalsAccessType(conShape, access)) {
            return Reason.createTrueReason((String)"The access type property is not in synch with domain model");
        }
        return Reason.createFalseReason();
    }

    private boolean equalsAccessType(Connection conShape, Access access) {
        EObject start = FMCUtil.getBO((PictogramElement)conShape.getStart().getParent());
        FMCConnectionAlgorithm algorithm = this.factory.getAlgorithm((PictogramElement)conShape);
        DataflowDirection direction = algorithm.getDirection(conShape);
        boolean write = false;
        if (direction == DataflowDirection.UNSPECIFIED) {
            return access.getType() == AccessType.UNSPECIFIED;
        }
        if (direction == DataflowDirection.DEFAULT) {
            write = start instanceof Agent;
        }
        if (direction == DataflowDirection.OTHER) {
            write = start instanceof Storage;
        }
        return access.getType() == AccessType.WRITE == write;
    }
}

