/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.algorithm.node;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.AbstractPolygonAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.LPolygonAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Shape;

public abstract class AbstractLPolygonAlgorithm
extends AbstractPolygonAlgorithm
implements LPolygonAlgorithm {
    @Override
    public List<Point> getInitialPoints(int x, int y, int width, int height) {
        int outerCornerSize = this.hasRoundedCorners() ? 15 : 0;
        int innerCornerSize = this.hasRoundedCorners() ? outerCornerSize * 2 / 3 : 0;
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(this.ga.createPoint(x, y + height - 30, outerCornerSize, outerCornerSize));
        points.add(this.ga.createPoint(x, y + height, outerCornerSize, outerCornerSize));
        points.add(this.ga.createPoint(x + width, y + height, outerCornerSize, outerCornerSize));
        points.add(this.ga.createPoint(x + width, y, outerCornerSize, outerCornerSize));
        points.add(this.ga.createPoint(x + width - 30, y, outerCornerSize, outerCornerSize));
        points.add(this.ga.createPoint(x + width - 30, y + height - 30, innerCornerSize, innerCornerSize));
        return points;
    }

    @Override
    public int getBottomPartSize(Polygon polygon) {
        EList points = polygon.getPoints();
        if (this.isFlattened(polygon)) {
            return Math.abs(((Point)points.get(1)).getX() - ((Point)points.get(5)).getX());
        }
        return Math.abs(((Point)points.get(1)).getY() - ((Point)points.get(5)).getY());
    }

    @Override
    public int getRightPartSize(Polygon polygon) {
        EList points = polygon.getPoints();
        if (this.isFlattened(polygon)) {
            return Math.abs(((Point)points.get(3)).getY() - ((Point)points.get(4)).getY());
        }
        return Math.abs(((Point)points.get(3)).getX() - ((Point)points.get(4)).getX());
    }

    @Override
    public void resizeBottomPart(Polygon polygon, int size) {
        if (size < 30) {
            size = 30;
        }
        int oldSize = this.getBottomPartSize(polygon);
        int sizeDif = this.isFlipped((GraphicsAlgorithm)polygon) ? oldSize - size : size - oldSize;
        EList points = polygon.getPoints();
        if (sizeDif != 0) {
            switch (this.getAngle((GraphicsAlgorithm)polygon)) {
                case 90: {
                    ((Point)points.get(0)).setX(((Point)points.get(0)).getX() + sizeDif);
                    ((Point)points.get(5)).setX(((Point)points.get(5)).getX() + sizeDif);
                    break;
                }
                case 180: {
                    ((Point)points.get(0)).setY(((Point)points.get(0)).getY() + sizeDif);
                    ((Point)points.get(5)).setY(((Point)points.get(5)).getY() + sizeDif);
                    break;
                }
                case 270: {
                    ((Point)points.get(0)).setX(((Point)points.get(0)).getX() - sizeDif);
                    ((Point)points.get(5)).setX(((Point)points.get(5)).getX() - sizeDif);
                    break;
                }
                default: {
                    ((Point)points.get(0)).setY(((Point)points.get(0)).getY() - sizeDif);
                    ((Point)points.get(5)).setY(((Point)points.get(5)).getY() - sizeDif);
                }
            }
            if (this.hasRoundedCorners()) {
                int cornerSize = this.getBottomPartLeftCornerSize(polygon);
                int innerCornerSize = this.getBottomPartRightCornerSize(polygon);
                ((Point)points.get(0)).setBefore(cornerSize);
                ((Point)points.get(0)).setAfter(cornerSize);
                ((Point)points.get(1)).setBefore(cornerSize);
                ((Point)points.get(1)).setAfter(cornerSize);
                ((Point)points.get(2)).setBefore(innerCornerSize);
                ((Point)points.get(5)).setAfter(innerCornerSize);
            }
        }
        EList graphicsAlgorithmChildren = polygon.getGraphicsAlgorithmChildren();
        int i = 0;
        while (i < graphicsAlgorithmChildren.size()) {
            if (graphicsAlgorithmChildren.get(i) instanceof Polygon) {
                this.resizeBottomPart((Polygon)graphicsAlgorithmChildren.get(i), size);
            }
            if (i == graphicsAlgorithmChildren.size() - 1) {
                this.createBoxAnchorSet((Shape)this.getContainerShape((GraphicsAlgorithm)polygon));
            }
            ++i;
        }
    }

    @Override
    public void resizeRightPart(Polygon polygon, int size) {
        if (size < 30) {
            size = 30;
        }
        int oldSize = this.getRightPartSize(polygon);
        int sizeDif = size - oldSize;
        EList points = polygon.getPoints();
        if (sizeDif != 0) {
            switch (this.getAngle((GraphicsAlgorithm)polygon)) {
                case 90: {
                    ((Point)points.get(4)).setY(((Point)points.get(4)).getY() - sizeDif);
                    ((Point)points.get(5)).setY(((Point)points.get(5)).getY() - sizeDif);
                    break;
                }
                case 180: {
                    ((Point)points.get(4)).setX(((Point)points.get(4)).getX() + sizeDif);
                    ((Point)points.get(5)).setX(((Point)points.get(5)).getX() + sizeDif);
                    break;
                }
                case 270: {
                    ((Point)points.get(4)).setY(((Point)points.get(4)).getY() + sizeDif);
                    ((Point)points.get(5)).setY(((Point)points.get(5)).getY() + sizeDif);
                    break;
                }
                default: {
                    ((Point)points.get(4)).setX(((Point)points.get(4)).getX() - sizeDif);
                    ((Point)points.get(5)).setX(((Point)points.get(5)).getX() - sizeDif);
                }
            }
            if (this.hasRoundedCorners()) {
                int cornerSize = this.getRightPartTopCornerSize(polygon);
                int innerCornerSize = this.getRightPartBottomCornerSize(polygon);
                ((Point)points.get(3)).setBefore(cornerSize);
                ((Point)points.get(3)).setAfter(cornerSize);
                ((Point)points.get(4)).setBefore(cornerSize);
                ((Point)points.get(4)).setAfter(cornerSize);
                ((Point)points.get(5)).setBefore(innerCornerSize);
                ((Point)points.get(2)).setAfter(innerCornerSize);
            }
        }
        this.relocateText((GraphicsAlgorithm)polygon);
        EList graphicsAlgorithmChildren = polygon.getGraphicsAlgorithmChildren();
        int i = 0;
        while (i < graphicsAlgorithmChildren.size()) {
            if (graphicsAlgorithmChildren.get(i) instanceof Polygon) {
                this.resizeRightPart((Polygon)graphicsAlgorithmChildren.get(i), size);
            }
            if (i == graphicsAlgorithmChildren.size() - 1) {
                this.createBoxAnchorSet((Shape)this.getContainerShape((GraphicsAlgorithm)polygon));
            }
            ++i;
        }
    }

    @Override
    public int getRightPartTopCornerSize(Polygon polygon) {
        return this.getRightPartSize(polygon) / 2;
    }

    @Override
    public int getBottomPartLeftCornerSize(Polygon polygon) {
        return this.getBottomPartSize(polygon) / 2;
    }

    @Override
    public int getRightPartBottomCornerSize(Polygon polygon) {
        return this.getRightPartTopCornerSize(polygon);
    }

    @Override
    public int getBottomPartRightCornerSize(Polygon polygon) {
        return this.getBottomPartLeftCornerSize(polygon);
    }

    @Override
    public int getAngle(GraphicsAlgorithm graphicsAlgorithm) {
        Polygon polygon = (Polygon)graphicsAlgorithm;
        EList points = polygon.getPoints();
        Point point1 = (Point)points.get(1);
        Point point2 = (Point)points.get(2);
        if (point2.getY() == point1.getY()) {
            return point2.getX() > point1.getX() ? 0 : 180;
        }
        return point2.getY() > point1.getY() ? 90 : 270;
    }

    @Override
    public boolean isFlipped(GraphicsAlgorithm graphicsAlgorithm) {
        Polygon polygon = (Polygon)graphicsAlgorithm;
        EList points = polygon.getPoints();
        Point point2 = (Point)points.get(2);
        Point point3 = (Point)points.get(3);
        switch (this.getAngle((GraphicsAlgorithm)polygon)) {
            case 90: {
                return point2.getX() >= point3.getX();
            }
            case 180: {
                return point2.getY() >= point3.getY();
            }
            case 270: {
                return point2.getX() <= point3.getX();
            }
        }
        return point2.getY() <= point3.getY();
    }

    protected boolean isFlattened(Polygon polygon) {
        double oldAngle = this.getAngle((GraphicsAlgorithm)polygon);
        return oldAngle % 180.0 == 90.0;
    }

    @Override
    public void resize(GraphicsAlgorithm algorithm, int x, int y, int width, int height) {
        int[] resizeY;
        int[] resizeX;
        Polygon polygon = (Polygon)algorithm;
        int angle = this.getAngle((GraphicsAlgorithm)polygon);
        if (this.isFlipped((GraphicsAlgorithm)polygon)) {
            switch (angle) {
                case 90: {
                    resizeX = new int[]{0, 1, 2, 5};
                    resizeY = new int[]{2, 3, 4, 5};
                    break;
                }
                case 180: {
                    resizeX = new int[]{0, 1};
                    resizeY = new int[]{0, 1, 2, 5};
                    break;
                }
                case 270: {
                    resizeX = new int[]{3, 4};
                    resizeY = new int[]{0, 1};
                    break;
                }
                default: {
                    resizeX = new int[]{2, 3, 4, 5};
                    resizeY = new int[]{3, 4};
                    break;
                }
            }
        } else {
            switch (angle) {
                case 90: {
                    resizeX = new int[]{3, 4};
                    resizeY = new int[]{2, 3, 4, 5};
                    break;
                }
                case 180: {
                    resizeX = new int[]{0, 1};
                    resizeY = new int[]{3, 4};
                    break;
                }
                case 270: {
                    resizeX = new int[]{0, 1, 2, 5};
                    resizeY = new int[]{0, 1};
                    break;
                }
                default: {
                    resizeX = new int[]{2, 3, 4, 5};
                    resizeY = new int[]{0, 1, 2, 5};
                }
            }
        }
        int oldHeight = polygon.getHeight();
        int oldWidth = polygon.getWidth();
        int heightDif = height - oldHeight;
        int widthDif = width - oldWidth;
        EList points = polygon.getPoints();
        int i = 0;
        while (i < resizeX.length) {
            ((Point)points.get(resizeX[i])).setX(((Point)points.get(resizeX[i])).getX() + widthDif);
            ++i;
        }
        i = 0;
        while (i < resizeY.length) {
            ((Point)points.get(resizeY[i])).setY(((Point)points.get(resizeY[i])).getY() + heightDif);
            ++i;
        }
        if (this.hasRoundedCorners()) {
            int rightCornerSize = this.getRightPartTopCornerSize(polygon);
            int rightInnerBottomCornerSize = this.getRightPartBottomCornerSize(polygon);
            int bottomCornerSize = this.getBottomPartLeftCornerSize(polygon);
            int bottomInnerRightCornerSize = this.getBottomPartRightCornerSize(polygon);
            ((Point)points.get(0)).setBefore(bottomCornerSize);
            ((Point)points.get(0)).setAfter(bottomCornerSize);
            ((Point)points.get(1)).setBefore(bottomCornerSize);
            ((Point)points.get(1)).setAfter(bottomCornerSize);
            ((Point)points.get(2)).setBefore(bottomInnerRightCornerSize);
            ((Point)points.get(2)).setAfter(rightInnerBottomCornerSize);
            ((Point)points.get(3)).setBefore(rightCornerSize);
            ((Point)points.get(3)).setAfter(rightCornerSize);
            ((Point)points.get(4)).setBefore(rightCornerSize);
            ((Point)points.get(4)).setAfter(rightCornerSize);
            ((Point)points.get(5)).setBefore(rightInnerBottomCornerSize);
            ((Point)points.get(5)).setAfter(bottomInnerRightCornerSize);
        }
        this.ga.setLocationAndSize((GraphicsAlgorithm)polygon, x, y, width, height);
        this.relocateText((GraphicsAlgorithm)polygon);
        ContainerShape container = this.getContainerShape((GraphicsAlgorithm)polygon);
        this.createBoxAnchorSet((Shape)container);
        this.synchronizeFirstLevelShape(container);
    }

    @Override
    public void relocateText(GraphicsAlgorithm graphicsAlgorithm) {
        MultiText text = this.getText(graphicsAlgorithm);
        if (text != null) {
            int angle;
            int textContainingPartSize;
            int multipleOffset = 0;
            if (this.isMultipleInstances(this.getContainerShape(graphicsAlgorithm))) {
                multipleOffset = 5;
            }
            int n = textContainingPartSize = (angle = this.getAngle(graphicsAlgorithm)) == 0 || angle == 180 ? this.getBottomPartSize((Polygon)graphicsAlgorithm) : this.getRightPartSize((Polygon)graphicsAlgorithm);
            boolean isOnTop = this.isFlipped(graphicsAlgorithm) ? angle == 0 || angle == 270 : angle == 180 || angle == 270;
            int x = this.textMargin;
            int width = graphicsAlgorithm.getWidth() - 2 * this.textMargin - multipleOffset;
            int y = (isOnTop ? this.textMargin : graphicsAlgorithm.getHeight() - textContainingPartSize + this.textMargin) + multipleOffset;
            int height = textContainingPartSize - 2 * this.textMargin - multipleOffset;
            this.ga.setLocationAndSize((GraphicsAlgorithm)text, x, y, width, height);
        }
    }

    @Override
    protected void addBoxAnchorSet(Shape shape) {
        GraphicsAlgorithm firstLevelPolygon = shape.getGraphicsAlgorithm();
        Polygon secondLevelPolygon = (Polygon)firstLevelPolygon.getGraphicsAlgorithmChildren().get(0);
        int numSides = 6;
        int lineWidth = this.getDefaultLineWidth();
        Point[] point = new Point[numSides];
        int i = 0;
        while (i < point.length) {
            point[i] = (Point)secondLevelPolygon.getPoints().get(i);
            ++i;
        }
        double offsetMultiInstance = 0.0;
        if (firstLevelPolygon.getWidth() != secondLevelPolygon.getWidth()) {
            FMCUtil.removeObsoleteAnchors(shape);
            offsetMultiInstance = 5.0;
        }
        int[] length = new int[numSides];
        length[0] = this.getBottomPartSize(secondLevelPolygon) + lineWidth;
        length[1] = Math.abs(this.isFlattened(secondLevelPolygon) ? point[1].getY() - point[2].getY() : point[1].getX() - point[2].getX());
        length[2] = Math.abs(this.isFlattened(secondLevelPolygon) ? point[2].getX() - point[3].getX() : point[2].getY() - point[3].getY());
        length[3] = this.getRightPartSize(secondLevelPolygon) + lineWidth;
        length[4] = length[2] - length[0];
        length[5] = length[1] - length[3];
        int[] anchoredLength = new int[numSides];
        int i2 = 0;
        while (i2 < numSides) {
            anchoredLength[i2] = Math.max(length[i2] - point[i2].getAfter() - point[(i2 + 1) % numSides].getBefore(), 8);
            ++i2;
        }
        int[] numAnchors = new int[numSides];
        double[][] gaps = new double[numSides][2];
        int i3 = 0;
        while (i3 < gaps.length) {
            int j = 0;
            while (j < gaps[i3].length) {
                gaps[i3][j] = 0.0;
                ++j;
            }
            ++i3;
        }
        double[][] offset = new double[numSides][2];
        switch (this.getAngle((GraphicsAlgorithm)secondLevelPolygon)) {
            case 90: {
                if (this.isFlipped((GraphicsAlgorithm)secondLevelPolygon)) {
                    offset[0][1] = 0.0;
                    offset[0][0] = (double)length[4] + offsetMultiInstance;
                    offset[1][1] = 0.0;
                    offset[1][0] = (double)length[2] + offsetMultiInstance - 8.0;
                    offset[2][1] = (double)length[1] + offsetMultiInstance - 8.0;
                    offset[2][0] = 0.0;
                    offset[3][1] = (double)length[5] + offsetMultiInstance;
                    offset[3][0] = 0.0;
                    offset[4][1] = length[5];
                    offset[4][0] = offsetMultiInstance;
                    offset[5][1] = offsetMultiInstance;
                    offset[5][0] = length[4];
                    length[4] = length[4] - (int)offsetMultiInstance;
                    break;
                }
                offset[0][1] = 0.0;
                offset[0][0] = offsetMultiInstance;
                offset[1][1] = offsetMultiInstance;
                offset[1][0] = 0.0;
                offset[2][1] = (double)length[1] + offsetMultiInstance - 8.0;
                offset[2][0] = 0.0;
                offset[3][1] = length[5];
                offset[3][0] = (double)length[2] + offsetMultiInstance - 8.0;
                offset[4][1] = length[5];
                offset[4][0] = (double)length[0] + offsetMultiInstance;
                offset[5][1] = 0.0;
                offset[5][0] = (double)length[0] + offsetMultiInstance - 8.0;
                break;
            }
            case 180: {
                if (this.isFlipped((GraphicsAlgorithm)secondLevelPolygon)) {
                    offset[0][1] = length[4];
                    offset[0][0] = (double)length[1] + offsetMultiInstance - 8.0;
                    offset[1][1] = (double)length[2] + offsetMultiInstance - 8.0;
                    offset[1][0] = 0.0;
                    offset[2][1] = offsetMultiInstance;
                    offset[2][0] = 0.0;
                    offset[3][1] = 0.0;
                    offset[3][0] = offsetMultiInstance;
                    offset[4][1] = 0.0;
                    offset[4][0] = (double)length[3] + offsetMultiInstance - 8.0;
                    offset[5][1] = length[4];
                    offset[5][0] = (double)length[3] + offsetMultiInstance;
                    break;
                }
                offset[0][1] = 0.0;
                offset[0][0] = (double)length[1] + offsetMultiInstance - 8.0;
                offset[1][1] = 0.0;
                offset[1][0] = offsetMultiInstance;
                offset[2][1] = offsetMultiInstance;
                offset[2][0] = 0.0;
                offset[3][1] = (double)length[2] + offsetMultiInstance - 8.0;
                offset[3][0] = 0.0;
                offset[4][1] = (double)length[0] + offsetMultiInstance;
                offset[4][0] = (double)length[3] + offsetMultiInstance - 8.0;
                offset[5][1] = (double)length[0] + offsetMultiInstance - 8.0;
                offset[5][0] = (double)length[3] + offsetMultiInstance;
                if (!(offsetMultiInstance > (double)point[4].getAfter())) break;
                anchoredLength[4] = anchoredLength[4] - (int)(offsetMultiInstance - (double)point[5].getBefore());
                break;
            }
            case 270: {
                if (this.isFlipped((GraphicsAlgorithm)secondLevelPolygon)) {
                    offset[0][1] = (double)length[1] + offsetMultiInstance - 8.0;
                    offset[0][0] = 0.0;
                    offset[1][1] = offsetMultiInstance;
                    offset[1][0] = 0.0;
                    offset[2][1] = 0.0;
                    offset[2][0] = offsetMultiInstance;
                    offset[3][1] = 0.0;
                    offset[3][0] = (double)length[2] + offsetMultiInstance - 8.0;
                    offset[4][1] = (double)length[3] + offsetMultiInstance - 8.0;
                    offset[4][0] = (double)length[0] + offsetMultiInstance;
                    offset[5][1] = (double)length[3] + offsetMultiInstance;
                    offset[5][0] = (double)length[0] + offsetMultiInstance - 8.0;
                    if (offsetMultiInstance > (double)point[4].getAfter()) {
                        anchoredLength[4] = anchoredLength[4] - (int)(offsetMultiInstance - (double)point[5].getBefore());
                    }
                    if (!(offsetMultiInstance > (double)point[5].getAfter())) break;
                    anchoredLength[5] = anchoredLength[5] - (int)(offsetMultiInstance - (double)point[5].getAfter());
                    break;
                }
                offset[0][1] = (double)length[1] + offsetMultiInstance - 8.0;
                offset[0][0] = length[4];
                offset[1][1] = 0.0;
                offset[1][0] = (double)length[2] + offsetMultiInstance - 8.0;
                offset[2][1] = 0.0;
                offset[2][0] = offsetMultiInstance;
                offset[3][1] = offsetMultiInstance;
                offset[3][0] = 0.0;
                offset[4][1] = (double)length[3] + offsetMultiInstance - 8.0;
                offset[4][0] = 0.0;
                offset[5][1] = (double)length[3] + offsetMultiInstance;
                offset[5][0] = length[4];
                break;
            }
            default: {
                if (this.isFlipped((GraphicsAlgorithm)secondLevelPolygon)) {
                    offset[0][1] = offsetMultiInstance;
                    offset[0][0] = 0.0;
                    offset[1][1] = 0.0;
                    offset[1][0] = offsetMultiInstance;
                    offset[2][1] = 0.0;
                    offset[2][0] = (double)length[1] + offsetMultiInstance - 8.0;
                    offset[3][1] = (double)length[2] + offsetMultiInstance - 8.0;
                    offset[3][0] = length[5];
                    offset[4][1] = (double)length[0] + offsetMultiInstance;
                    offset[4][0] = length[5];
                    offset[5][1] = (double)length[0] + offsetMultiInstance - 8.0;
                    offset[5][0] = 0.0;
                    break;
                }
                offset[0][1] = (double)length[4] + offsetMultiInstance;
                offset[0][0] = 0.0;
                offset[1][1] = (double)length[2] + offsetMultiInstance - 8.0;
                offset[1][0] = 0.0;
                offset[2][1] = 0.0;
                offset[2][0] = (double)length[1] + offsetMultiInstance - 8.0;
                offset[3][1] = 0.0;
                offset[3][0] = (double)length[5] + offsetMultiInstance;
                offset[4][1] = offsetMultiInstance;
                offset[4][0] = length[5];
                offset[5][1] = length[4];
                offset[5][0] = offsetMultiInstance;
                if (!(offsetMultiInstance > (double)point[5].getAfter())) break;
                anchoredLength[5] = anchoredLength[5] - (int)(offsetMultiInstance - (double)point[5].getAfter());
            }
        }
        int i4 = 0;
        while (i4 < numSides) {
            if (point[i4].getX() == point[(i4 + 1) % numSides].getX()) {
                offset[i4][1] = offset[i4][1] + (point[i4].getY() < point[(i4 + 1) % numSides].getY() ? (point[i4].getAfter() > 0 ? (double)point[i4].getAfter() - 4.0 : 0.0) : (point[(i4 + 1) % numSides].getBefore() > 0 ? (double)point[(i4 + 1) % numSides].getBefore() - 4.0 : 0.0));
            } else {
                offset[i4][0] = offset[i4][0] + (point[i4].getX() < point[(i4 + 1) % numSides].getX() ? (point[i4].getAfter() > 0 ? (double)point[i4].getAfter() - 4.0 : 0.0) : (point[(i4 + 1) % numSides].getBefore() > 0 ? (double)point[(i4 + 1) % numSides].getBefore() - 4.0 : 0.0));
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < numSides) {
            numAnchors[i4] = anchoredLength[i4] / 8;
            ++i4;
        }
        int direction = 0;
        int i5 = 0;
        while (i5 < numSides) {
            direction = this.isFlattened(secondLevelPolygon) ? i5 % 2 : (i5 + 1) % 2;
            gaps[i5][direction] = (double)anchoredLength[i5] / (double)numAnchors[i5];
            ++i5;
        }
        i5 = 0;
        while (i5 < numSides) {
            int j = 0;
            while (j < numAnchors[i5]) {
                this.createBoxAnchor(shape, (offset[i5][0] + (double)j * gaps[i5][0]) / (double)firstLevelPolygon.getWidth(), (offset[i5][1] + (double)j * gaps[i5][1]) / (double)firstLevelPolygon.getHeight(), 8, 8);
                ++j;
            }
            ++i5;
        }
    }
}

