/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.meta.model;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.mm.Access;
import org.eclipse.fmc.mm.AccessType;
import org.eclipse.fmc.mm.Agent;
import org.eclipse.fmc.mm.Channel;
import org.eclipse.fmc.mm.Comment;
import org.eclipse.fmc.mm.CommentType;
import org.eclipse.fmc.mm.DataflowDirection;
import org.eclipse.fmc.mm.FmcPackage;
import org.eclipse.fmc.mm.RequestDirection;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MetaFMCTypeHelper
implements FMCTypeChecker {
    public boolean isFMCNode(PictogramElement element) {
        return this.isType(element, FmcPackage.eINSTANCE.getFMCNode());
    }

    public boolean isFMCConnection(PictogramElement element) {
        return this.isType(element, FmcPackage.eINSTANCE.getFMCConnection());
    }

    public boolean isAgent(PictogramElement element) {
        return this.isType(element, FmcPackage.eINSTANCE.getAgent());
    }

    public boolean isHumanAgent(PictogramElement element) {
        EObject bo = FMCUtil.getBO((PictogramElement)element);
        if (bo != null && bo instanceof Agent) {
            return ((Agent)bo).isHuman();
        }
        return false;
    }

    public boolean isStorage(PictogramElement element) {
        return this.isType(element, FmcPackage.eINSTANCE.getStorage());
    }

    public boolean isStructureVariance(PictogramElement element) {
        return this.isType(element, FmcPackage.eINSTANCE.getStructureVariance());
    }

    public boolean isCommunicationChannel(PictogramElement element) {
        return this.isType(element, FmcPackage.eINSTANCE.getChannel());
    }

    public boolean isChannelType(PictogramElement element) {
        return this.isType(element, FmcPackage.eINSTANCE.getChannel());
    }

    public boolean isAccessType(PictogramElement element) {
        return this.isType(element, FmcPackage.eINSTANCE.getAccess());
    }

    public boolean isChannelType(Object obj) {
        return obj.equals(FmcPackage.eINSTANCE.getChannel()) || FmcPackage.eINSTANCE.getChannel().isInstance(obj);
    }

    public boolean isReqRespCommunicationChannel(Object obj) {
        if (obj instanceof Channel) {
            return ((Channel)obj).getChannelType() != RequestDirection.UNSPECIFIED;
        }
        return false;
    }

    public boolean isUnidirectionalCommunicationChannel(Object obj) {
        if (obj instanceof Channel) {
            return ((Channel)obj).getDataflowDirection() == DataflowDirection.DEFAULT;
        }
        return false;
    }

    public boolean isReqRespCommunicationChannel(Connection con) {
        EObject bo = FMCUtil.getBO((PictogramElement)con);
        return this.isReqRespCommunicationChannel(bo);
    }

    private boolean isType(PictogramElement element, EClass clazz) {
        if (element == null) {
            return false;
        }
        if (element.getLink() != null && clazz != null) {
            for (EObject object : element.getLink().getBusinessObjects()) {
                if (!clazz.isInstance((Object)object)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isModifyAccess(PictogramElement element) {
        EObject bo = FMCUtil.getBO((PictogramElement)element);
        if (bo instanceof Access) {
            return ((Access)bo).getType() != AccessType.RW;
        }
        return false;
    }

    public boolean isBrace(PictogramElement element) {
        EObject bo = FMCUtil.getBO((PictogramElement)element);
        if (bo instanceof Comment) {
            return ((Comment)bo).getType() == CommentType.BRACE;
        }
        return false;
    }

    public boolean isAreaBorder(PictogramElement element) {
        EObject bo = FMCUtil.getBO((PictogramElement)element);
        if (bo instanceof Comment) {
            return ((Comment)bo).getType() == CommentType.AREABORDER;
        }
        return false;
    }

    public boolean isDots(PictogramElement element) {
        EObject bo = FMCUtil.getBO((PictogramElement)element);
        if (bo instanceof Comment) {
            return ((Comment)bo).getType() == CommentType.DOTS;
        }
        return false;
    }

    public boolean isTextComment(PictogramElement element) {
        EObject bo = FMCUtil.getBO((PictogramElement)element);
        if (bo instanceof Comment) {
            return ((Comment)bo).getType() == CommentType.TEXT;
        }
        return false;
    }

    public boolean isComment(PictogramElement element) {
        EObject bo = FMCUtil.getBO((PictogramElement)element);
        return bo instanceof Comment;
    }

    public boolean isImage(PictogramElement element) {
        return false;
    }

    public boolean isCommonFeatureArea(PictogramElement element) {
        EObject bo = FMCUtil.getBO((PictogramElement)element);
        if (bo instanceof Comment) {
            return ((Comment)bo).getType() == CommentType.COMMONFEATUREAREA;
        }
        return false;
    }
}

