/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.diagram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.fmc.blockdiagram.editor.algorithm.element.FMCElementAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.element.FMCElementAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.ContainerNode;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.RotatableNode;
import org.eclipse.fmc.blockdiagram.editor.features.CreateShapeAndConnectionFeature;
import org.eclipse.fmc.blockdiagram.editor.features.DirectEditingDoubleclickFeature;
import org.eclipse.fmc.blockdiagram.editor.features.create.ShapeCreateFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.CategoryCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.FMCCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.FlipHorizontallyCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.FlipVerticallyCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.HideContentCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.RotateCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.UnhideContentCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeCheckerFactory;
import org.eclipse.fmc.mm.FmcPackage;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.palette.ICreationToolEntry;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ConnectionCreationToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.palette.impl.PaletteCompartmentEntry;
import org.eclipse.graphiti.palette.impl.StackEntry;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;

public class BlockDiagramToolBehaviorProvider
extends DefaultToolBehaviorProvider {
    public BlockDiagramToolBehaviorProvider(IDiagramTypeProvider diagramTypeProvider) {
        super(diagramTypeProvider);
    }

    public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
        return new DirectEditingDoubleclickFeature(this.getFeatureProvider());
    }

    public IPaletteCompartmentEntry[] getPalette() {
        ArrayList<PaletteCompartmentEntry> ret = new ArrayList<PaletteCompartmentEntry>();
        PaletteCompartmentEntry objects = new PaletteCompartmentEntry("Objects", null);
        PaletteCompartmentEntry connections = new PaletteCompartmentEntry("Connections", null);
        ret.add(objects);
        ret.add(connections);
        this.addCreateShapeFeatures(objects);
        this.addCreateConnectionFeatures(connections);
        return ret.toArray(new IPaletteCompartmentEntry[ret.size()]);
    }

    private void addCreateConnectionFeatures(PaletteCompartmentEntry connections) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        ICreateConnectionFeature[] createConnectionFeatures = featureProvider.getCreateConnectionFeatures();
        ICreateConnectionFeature cf0 = createConnectionFeatures[0];
        ConnectionCreationToolEntry connectionCreationToolEntry0 = new ConnectionCreationToolEntry(cf0.getCreateName(), cf0.getCreateDescription(), cf0.getCreateImageId(), cf0.getCreateLargeImageId());
        connectionCreationToolEntry0.addCreateConnectionFeature(cf0);
        connections.addToolEntry((IToolEntry)connectionCreationToolEntry0);
        int i = 1;
        while (i < createConnectionFeatures.length - 1) {
            ICreateConnectionFeature cf = createConnectionFeatures[i];
            ICreateConnectionFeature cf2 = createConnectionFeatures[i + 1];
            ConnectionCreationToolEntry connectionCreationToolEntry = new ConnectionCreationToolEntry(cf.getCreateName(), cf.getCreateDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId());
            ConnectionCreationToolEntry connectionCreationToolEntry2 = new ConnectionCreationToolEntry(cf2.getCreateName(), cf2.getCreateDescription(), cf2.getCreateImageId(), cf2.getCreateLargeImageId());
            StackEntry stackEntry = new StackEntry(cf.getCreateName(), cf.getCreateDescription(), cf.getCreateImageId());
            stackEntry.addCreationToolEntry((ICreationToolEntry)connectionCreationToolEntry);
            stackEntry.addCreationToolEntry((ICreationToolEntry)connectionCreationToolEntry2);
            connectionCreationToolEntry.addCreateConnectionFeature(cf);
            connectionCreationToolEntry2.addCreateConnectionFeature(cf2);
            connections.addToolEntry((IToolEntry)stackEntry);
            i += 2;
        }
    }

    private void addCreateShapeFeatures(PaletteCompartmentEntry objects) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        ICreateFeature[] createFeatures = featureProvider.getCreateFeatures();
        StackEntry stackEntry = null;
        int stackCount = 0;
        ICreateFeature[] iCreateFeatureArray = createFeatures;
        int n = createFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateFeature cf = iCreateFeatureArray[n2];
            ShapeCreateFeature scf = (ShapeCreateFeature)cf;
            StackEntry objectCreationToolEntry = null;
            if (scf.getModelType() == FmcPackage.Literals.STORAGE || scf.getModelType() == FMCType.Storage) {
                if (stackCount == 0) {
                    objectCreationToolEntry = stackEntry = new StackEntry("Storage", "Storage", "org.eclipse.fmc.IconStorage");
                }
                stackEntry.addCreationToolEntry((ICreationToolEntry)this.createObjectCreationToolEntry(cf));
                stackCount = stackCount == 2 ? 0 : ++stackCount;
            } else if (scf.getModelType() == FmcPackage.Literals.AGENT || scf.getModelType() == FMCType.Agent) {
                if (stackCount == 0) {
                    objectCreationToolEntry = stackEntry = new StackEntry("Agent", "Agent", "org.eclipse.fmc.IconAgent");
                }
                stackEntry.addCreationToolEntry((ICreationToolEntry)this.createObjectCreationToolEntry(cf));
                stackCount = stackCount == 2 ? 0 : ++stackCount;
            } else {
                objectCreationToolEntry = this.createObjectCreationToolEntry(cf);
            }
            objects.addToolEntry((IToolEntry)objectCreationToolEntry);
            ++n2;
        }
    }

    private ObjectCreationToolEntry createObjectCreationToolEntry(ICreateFeature cf) {
        return new ObjectCreationToolEntry(cf.getCreateName(), cf.getCreateDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId(), cf);
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        IContextButtonPadData data = super.getContextButtonPad(context);
        ICreateFeature[] createFeatures = this.getFeatureProvider().getCreateFeatures();
        ICreateConnectionFeature[] createConnectionFeatures = this.getFeatureProvider().getCreateConnectionFeatures();
        CreateConnectionContext createConContext = new CreateConnectionContext();
        createConContext.setSourceAnchor(Graphiti.getPeService().getChopboxAnchor((AnchorContainer)context.getPictogramElement()));
        createConContext.setSourcePictogramElement(context.getPictogramElement());
        FMCTypeChecker typeHelper = FMCTypeCheckerFactory.getInstance();
        if (typeHelper.isFMCNode(context.getPictogramElement())) {
            this.createFmcNodeContext(data, createConnectionFeatures, createConContext);
        }
        if (typeHelper.isAgent(context.getPictogramElement())) {
            this.createAgentContext(data, createFeatures, createConnectionFeatures, createConContext);
        }
        if (typeHelper.isStorage(context.getPictogramElement())) {
            this.createStorageContext(data, createFeatures, createConnectionFeatures, createConContext);
        }
        if (typeHelper.isStorage(context.getPictogramElement()) || typeHelper.isAgent(context.getPictogramElement()) || typeHelper.isBrace(context.getPictogramElement()) || typeHelper.isStructureVariance(context.getPictogramElement())) {
            ContainerShape container = (ContainerShape)context.getPictogramElement();
            FMCElementAlgorithm ea = FMCElementAlgorithmFactory.getInstance().getShape((PictogramElement)container);
            ArrayList<ContextButtonEntry> contextButtonEntries = new ArrayList<ContextButtonEntry>();
            PictogramElement[] pictogramElements = new PictogramElement[]{context.getPictogramElement()};
            CustomContext customContext = new CustomContext(pictogramElements);
            if (ea instanceof RotatableNode) {
                this.createRotateContext(contextButtonEntries, (ICustomContext)customContext);
            }
            if (!contextButtonEntries.isEmpty()) {
                ContextButtonEntry editShapeEntry = new ContextButtonEntry(null, null);
                editShapeEntry.setText("Edit shape");
                editShapeEntry.setIconId("org.eclipse.fmc.EditShape_16");
                data.getDomainSpecificContextButtons().add(editShapeEntry);
                for (ContextButtonEntry contextButtonEntry : contextButtonEntries) {
                    editShapeEntry.addContextButtonMenuEntry((IContextButtonEntry)contextButtonEntry);
                }
            }
            if (ea instanceof ContainerNode) {
                this.createHideContext(data, container, ea, (ICustomContext)customContext);
            }
        }
        return data;
    }

    private void createHideContext(IContextButtonPadData data, ContainerShape container, FMCElementAlgorithm ea, ICustomContext customContext) {
        ContainerNode cn = (ContainerNode)((Object)ea);
        if (!cn.isEmpty(container)) {
            if (!cn.isHiding(container)) {
                HideContentCustomFeature hideContentFeature = new HideContentCustomFeature(this.getFeatureProvider());
                ContextButtonEntry hideContentEntry = new ContextButtonEntry((IFeature)hideContentFeature, (IContext)customContext);
                data.getDomainSpecificContextButtons().add(hideContentEntry);
            } else {
                UnhideContentCustomFeature unhideContentFeature = new UnhideContentCustomFeature(this.getFeatureProvider());
                ContextButtonEntry unhideContentEntry = new ContextButtonEntry((IFeature)unhideContentFeature, (IContext)customContext);
                data.getDomainSpecificContextButtons().add(unhideContentEntry);
            }
        }
    }

    private void createRotateContext(List<ContextButtonEntry> contextButtonEntries, ICustomContext customContext) {
        RotateCustomFeature rotateFeature = new RotateCustomFeature(this.getFeatureProvider());
        ContextButtonEntry rotateEntry = new ContextButtonEntry((IFeature)rotateFeature, (IContext)customContext);
        contextButtonEntries.add(rotateEntry);
        FlipHorizontallyCustomFeature flipHorizontallyFeature = new FlipHorizontallyCustomFeature(this.getFeatureProvider());
        ContextButtonEntry flipHorizontallyEntry = new ContextButtonEntry((IFeature)flipHorizontallyFeature, (IContext)customContext);
        contextButtonEntries.add(flipHorizontallyEntry);
        FlipVerticallyCustomFeature flipVerticallyFeature = new FlipVerticallyCustomFeature(this.getFeatureProvider());
        ContextButtonEntry flipVerticallyEntry = new ContextButtonEntry((IFeature)flipVerticallyFeature, (IContext)customContext);
        contextButtonEntries.add(flipVerticallyEntry);
    }

    private void createStorageContext(IContextButtonPadData data, ICreateFeature[] createFeatures, ICreateConnectionFeature[] createConnectionFeatures, CreateConnectionContext createConContext) {
        data.getDomainSpecificContextButtons().add(this.createShapeContextButton(createConContext, createFeatures[0], createConnectionFeatures[0], "Agent", "Creates an agent connected with unidirectional access", "org.eclipse.fmc.IconAgent_16"));
    }

    private void createFmcNodeContext(IContextButtonPadData data, ICreateConnectionFeature[] createConnectionFeatures, CreateConnectionContext createConContext) {
        data.getDomainSpecificContextButtons().add(this.createConnectionContextButton(createConContext, createConnectionFeatures[0], "Modify Access", "Draw modify access", "org.eclipse.fmc.IconModifyAccess_16"));
        data.getDomainSpecificContextButtons().add(this.createConnectionContextButton(createConContext, createConnectionFeatures[1], "Unidirectional Access", "Draw unidirectional access", "org.eclipse.fmc.IconUnidirectionalAccess_16"));
    }

    private void createAgentContext(IContextButtonPadData data, ICreateFeature[] createFeatures, ICreateConnectionFeature[] createConnectionFeatures, CreateConnectionContext createConContext) {
        data.getDomainSpecificContextButtons().add(this.createConnectionContextButton(createConContext, createConnectionFeatures[7], "Unidirectional Communication Channel", "Draw unidirectional communication channel", "org.eclipse.fmc.IconUnidirectionalCommunicationChannel_16"));
        data.getDomainSpecificContextButtons().add(this.createConnectionContextButton(createConContext, createConnectionFeatures[9], "Req/Resp Communication Channel", "Draw Req/Resp Communication Channel", "org.eclipse.fmc.IconRequestResponseCommunicationChannel_16"));
        data.getDomainSpecificContextButtons().add(this.createShapeContextButton(createConContext, createFeatures[3], createConnectionFeatures[0], "Storage", "Creates an Storage connected with unidirectional access", "org.eclipse.fmc.IconStorage_16"));
        data.getDomainSpecificContextButtons().add(this.createShapeContextButton(createConContext, createFeatures[0], createConnectionFeatures[9], "Agent", "Creates an agent connected with communication channel", "org.eclipse.fmc.IconAgent_16"));
    }

    private ContextButtonEntry createShapeContextButton(CreateConnectionContext createConContext, ICreateFeature createFeature, ICreateConnectionFeature createConnectionFeature, String text, String description, String iconId) {
        CreateShapeAndConnectionFeature feature = new CreateShapeAndConnectionFeature(createFeature, createConnectionFeature, 80, 50);
        ContextButtonEntry shapeEntry = new ContextButtonEntry(null, (IContext)createConContext);
        if (feature.isAvailable((IContext)createConContext) && feature.canStartConnection((ICreateConnectionContext)createConContext)) {
            shapeEntry.addDragAndDropFeature((IFeature)feature);
        }
        shapeEntry.setText(text);
        shapeEntry.setDescription(description);
        shapeEntry.setIconId(iconId);
        return shapeEntry;
    }

    private ContextButtonEntry createConnectionContextButton(CreateConnectionContext createConContext, ICreateConnectionFeature createConnectionFeature, String text, String description, String iconId) {
        ContextButtonEntry connectionEntry = new ContextButtonEntry(null, (IContext)createConContext);
        if (createConnectionFeature.isAvailable((IContext)createConContext) && createConnectionFeature.canStartConnection((ICreateConnectionContext)createConContext)) {
            connectionEntry.addDragAndDropFeature((IFeature)createConnectionFeature);
        }
        connectionEntry.setText(text);
        connectionEntry.setDescription(description);
        connectionEntry.setIconId(iconId);
        return connectionEntry;
    }

    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        IContextMenuEntry[] contextMenu = super.getContextMenu(context);
        HashMap categories = new HashMap();
        ArrayList<IContextMenuEntry> topLevelEntries = new ArrayList<IContextMenuEntry>();
        Object object = contextMenu;
        int n = contextMenu.length;
        int n2 = 0;
        while (n2 < n) {
            IContextMenuEntry contextMenuEntry = object[n2];
            if (contextMenuEntry.getFeature() instanceof FMCCustomFeature) {
                FMCCustomFeature provider = (FMCCustomFeature)contextMenuEntry.getFeature();
                if (provider.getCategory() != null && provider.getCategory().length() > 0) {
                    if (!categories.containsKey(provider.getCategory())) {
                        categories.put(provider.getCategory(), new ArrayList());
                    }
                    ((List)categories.get(provider.getCategory())).add(contextMenuEntry);
                } else {
                    topLevelEntries.add(contextMenuEntry);
                }
            } else {
                topLevelEntries.add(contextMenuEntry);
            }
            ++n2;
        }
        IContextMenuEntry[] newContextMenu = new IContextMenuEntry[topLevelEntries.size() + categories.size()];
        int i = 0;
        object = topLevelEntries.iterator();
        while (object.hasNext()) {
            IContextMenuEntry iContextMenuEntry;
            newContextMenu[i] = iContextMenuEntry = (IContextMenuEntry)object.next();
            ++i;
        }
        for (Map.Entry entry : categories.entrySet()) {
            ContextMenuEntry category = new ContextMenuEntry((IFeature)new CategoryCustomFeature(this.getFeatureProvider(), (String)entry.getKey()), (IContext)context);
            for (IContextMenuEntry contextMenuEntry : (List)entry.getValue()) {
                category.add(contextMenuEntry);
            }
            newContextMenu[i] = category;
            ++i;
        }
        return newContextMenu;
    }
}

