/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.create;

import org.eclipse.fmc.blockdiagram.editor.model.ConnectionStyle;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeCheckerFactory;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.AreaContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.PlatformGraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class ConnectionCreateFeature
extends AbstractCreateConnectionFeature {
    protected Object type = null;
    private String icon = null;
    private ConnectionStyle style = null;
    protected FMCTypeChecker checker = FMCTypeCheckerFactory.getInstance();

    public ConnectionCreateFeature(IFeatureProvider featureProvider, String name, String description, Object type, ConnectionStyle style, String icon) {
        super(featureProvider, name, description);
        this.type = type;
        this.icon = icon;
        this.style = style;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        PictogramElement targetPictogramElement = context.getTargetPictogramElement();
        PictogramElement sourcePictogramElement = context.getSourcePictogramElement();
        if (context.getTargetAnchor() instanceof BoxRelativeAnchor) {
            targetPictogramElement = context.getTargetAnchor().getParent();
        }
        if (context.getSourceAnchor() instanceof BoxRelativeAnchor) {
            sourcePictogramElement = context.getSourceAnchor().getParent();
        }
        if (sourcePictogramElement instanceof Shape && targetPictogramElement instanceof Shape) {
            Shape shapeBehindTextOrPictureSource = ConnectionCreateFeature.getShapeBehindTextOrPicture((Shape)sourcePictogramElement);
            Shape shapeBehindTextOrPictureTarget = ConnectionCreateFeature.getShapeBehindTextOrPicture((Shape)targetPictogramElement);
            if (this.type != FMCType.Dots && !this.isSourceAndTargetTypesValid(shapeBehindTextOrPictureSource, shapeBehindTextOrPictureTarget)) {
                return false;
            }
            return this.type == FMCType.Dots || !(targetPictogramElement instanceof Diagram) && shapeBehindTextOrPictureTarget != null && shapeBehindTextOrPictureSource != null;
        }
        return this.type == FMCType.Dots;
    }

    protected boolean isSourceAndTargetTypesValid(Shape shapeBehindTextOrPictureSource, Shape shapeBehindTextOrPictureTarget) {
        if (this.checker.isChannelType(this.type)) {
            return this.checker.isAgent((PictogramElement)shapeBehindTextOrPictureSource) && this.checker.isAgent((PictogramElement)shapeBehindTextOrPictureTarget);
        }
        return this.checker.isAgent((PictogramElement)shapeBehindTextOrPictureSource) && (this.checker.isStorage((PictogramElement)shapeBehindTextOrPictureTarget) || this.checker.isStructureVariance((PictogramElement)shapeBehindTextOrPictureTarget)) || this.checker.isAgent((PictogramElement)shapeBehindTextOrPictureTarget) && this.checker.isStorage((PictogramElement)shapeBehindTextOrPictureSource);
    }

    public Connection create(ICreateConnectionContext context) {
        Shape container;
        Object source = context.getSourceAnchor();
        Object target = context.getTargetAnchor();
        IPeService pe = Graphiti.getPeService();
        if (source == null && context.getSourcePictogramElement() instanceof Shape && (container = ConnectionCreateFeature.getShapeBehindTextOrPicture((Shape)context.getSourcePictogramElement())) != null) {
            source = container.getAnchors().isEmpty() ? pe.createChopboxAnchor((AnchorContainer)container) : (Anchor)container.getAnchors().get(0);
        }
        if (target == null && context.getTargetPictogramElement() instanceof Shape) {
            container = ConnectionCreateFeature.getShapeBehindTextOrPicture((Shape)context.getTargetPictogramElement());
            if (container != null) {
                target = container.getAnchors().isEmpty() ? pe.createChopboxAnchor((AnchorContainer)container) : (Anchor)container.getAnchors().get(0);
            } else {
                AreaContext areaContext = new AreaContext();
                ILocation targetLocation = context.getTargetLocation();
                areaContext.setLocation(targetLocation.getX(), targetLocation.getY());
                areaContext.setSize(this.getDiagram().getGraphicsAlgorithm().getWidth(), this.getDiagram().getGraphicsAlgorithm().getHeight());
                AddContext addContext = new AddContext((IAreaContext)areaContext, (Object)FMCType.Invisible);
                addContext.setTargetContainer((ContainerShape)this.getDiagram());
                Shape invisible = (Shape)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
                target = (Anchor)invisible.getAnchors().get(0);
            }
        }
        AddConnectionContext addContext = new AddConnectionContext(source, target);
        if (this.type instanceof FMCType) {
            addContext.setNewObject(this.type);
        } else {
            this.createConnectionModel(addContext, (Anchor)source, (Anchor)target);
        }
        addContext.putProperty((Object)"graphicalType", (Object)this.style);
        Connection connection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
        return connection;
    }

    protected void createConnectionModel(AddConnectionContext context, Anchor source, Anchor target) {
    }

    public static Shape getShapeBehindTextOrPicture(Shape shape) {
        if (shape != null) {
            if (!shape.isActive() || shape.getGraphicsAlgorithm() instanceof AbstractText || shape.getGraphicsAlgorithm() instanceof PlatformGraphicsAlgorithm) {
                return shape.getContainer();
            }
            if (shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().size() > 4) {
                return shape.getContainer();
            }
        }
        if (shape instanceof Diagram) {
            return null;
        }
        return shape;
    }

    public static Shape getShapeBehindTextOrPicture(Shape shape, Anchor anchor) {
        Shape shapeBehindTextOrPicture = ConnectionCreateFeature.getShapeBehindTextOrPicture(shape);
        if (anchor != null && shapeBehindTextOrPicture == null && anchor.getParent() instanceof Shape) {
            return (Shape)anchor.getParent();
        }
        return shapeBehindTextOrPicture;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        PictogramElement sourcePictogramElement = context.getSourcePictogramElement();
        Shape shapeBehindTextOrPicture = null;
        if (sourcePictogramElement instanceof Shape) {
            shapeBehindTextOrPicture = ConnectionCreateFeature.getShapeBehindTextOrPicture((Shape)sourcePictogramElement, context.getSourceAnchor());
        }
        if (shapeBehindTextOrPicture == null && context.getSourceAnchor() != null) {
            shapeBehindTextOrPicture = (Shape)context.getSourceAnchor().getReferencedGraphicsAlgorithm().getPictogramElement();
        }
        return !(sourcePictogramElement instanceof Diagram) && shapeBehindTextOrPicture != null && this.checker.isAgent((PictogramElement)shapeBehindTextOrPicture) || this.checker.isStorage((PictogramElement)shapeBehindTextOrPicture) && !this.checker.isChannelType(this.type);
    }

    public String getCreateImageId() {
        return this.icon;
    }
}

