/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.custom;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fmc.blockdiagram.editor.features.add.BlockDiagramAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.FMCCustomFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ImportBlockDiagramCustomFeature
extends FMCCustomFeature {
    public ImportBlockDiagramCustomFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
    }

    public void execute(ICustomContext context) {
        String path = this.showImportDialog();
        if (path != null) {
            PictogramElement pictogramElement = context.getPictogramElements()[0];
            Resource resource = context.getPictogramElements()[0].eResource();
            Resource diagResource = resource.getResourceSet().createResource(URI.createPlatformResourceURI((String)path, (boolean)true));
            try {
                diagResource.load(Collections.EMPTY_MAP);
                Diagram diagram = (Diagram)diagResource.getContents().get(0);
                AddContext ctx = new AddContext();
                ctx.putProperty((Object)"RES", (Object)diagram);
                ctx.setTargetContainer((ContainerShape)pictogramElement);
                new BlockDiagramAddFeature(this.getFeatureProvider()).execute((IContext)ctx);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String showImportDialog() {
        ElementTreeSelectionDialog fDialog = new ElementTreeSelectionDialog(GraphitiUiInternal.getWorkbenchService().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        fDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        fDialog.setAllowMultiple(false);
        fDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && selection[0] instanceof File && ((File)selection[0]).getFullPath().toOSString().endsWith("blockdiag")) {
                    return new Status(0, "Blockdiagram Editor", "");
                }
                return new Status(4, "Blockdiagram", "");
            }
        });
        if (fDialog.open() == 0) {
            return ((File)fDialog.getResult()[0]).getFullPath().toOSString();
        }
        return null;
    }

    public String getName() {
        return "Import FMC Blockdiagram";
    }

    public boolean canExecute(ICustomContext context) {
        return context.getPictogramElements().length > 0 && context.getPictogramElements()[0] instanceof ContainerShape;
    }
}

