/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.resize;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class AreaBorderResizeFeature
extends DefaultResizeShapeFeature {
    public AreaBorderResizeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void resizeShape(IResizeShapeContext context) {
        Point endPoint;
        super.resizeShape(context);
        IGaService ga = Graphiti.getGaService();
        int w = context.getWidth();
        int h = context.getHeight();
        int min = 100;
        if (context.getWidth() > context.getHeight()) {
            w = context.getWidth() < min ? min : w;
        } else {
            h = context.getHeight() < min ? min : h;
        }
        int margin = 2;
        int lineWidth = 2;
        int textHeight = 20;
        int textWidth = 100;
        Rectangle invRec = (Rectangle)context.getShape().getGraphicsAlgorithm();
        Polyline line = null;
        MultiText txt = null;
        for (GraphicsAlgorithm gaChild : invRec.getGraphicsAlgorithmChildren()) {
            if (gaChild instanceof Polyline) {
                line = (Polyline)gaChild;
                continue;
            }
            if (!(gaChild instanceof MultiText)) continue;
            txt = (MultiText)gaChild;
        }
        if (context.getWidth() > context.getHeight()) {
            ga.setLocationAndSize((GraphicsAlgorithm)invRec, context.getX(), context.getY(), w, 3 * margin + lineWidth + textHeight);
            txt.setHorizontalAlignment(Orientation.ALIGNMENT_RIGHT);
            ga.setLocationAndSize((GraphicsAlgorithm)txt, margin, margin, w - 2 * margin, textHeight);
            ga.setLocationAndSize((GraphicsAlgorithm)line, 0, 2 * margin + textHeight, w, 2);
            endPoint = (Point)line.getPoints().get(1);
            endPoint.setX(w);
            endPoint.setY(0);
        } else {
            ga.setLocationAndSize((GraphicsAlgorithm)invRec, context.getX(), context.getY(), 3 * margin + lineWidth + textWidth, h);
            txt.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
            txt.setVerticalAlignment(Orientation.ALIGNMENT_BOTTOM);
            ga.setLocationAndSize((GraphicsAlgorithm)txt, 2 * margin + lineWidth, margin, textWidth, h - 2 * margin);
            ga.setLocationAndSize((GraphicsAlgorithm)line, margin, 0, 2, h);
            endPoint = (Point)line.getPoints().get(1);
            endPoint.setX(0);
            endPoint.setY(h);
        }
    }
}

