/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public abstract class GraphitiPropertySection
extends AbstractPropertySection {
    protected TransactionalEditingDomain editingDomain;
    protected boolean disposed;
    private Diagram diagram;

    public boolean isDisposed() {
        return this.disposed;
    }

    public Diagram getDiagram() {
        if (this.diagram == null) {
            this.diagram = this.getDiagramSavely();
        }
        return this.diagram;
    }

    protected Diagram getDiagramSavely() {
        if (this.diagram == null && FMCUtil.getActiveEditorSavely() != null && FMCUtil.getActiveEditorSavely().getDiagramTypeProvider() != null && FMCUtil.getActiveEditorSavely().getDiagramTypeProvider().getDiagram() != null) {
            this.diagram = FMCUtil.getActiveEditorSavely().getDiagramTypeProvider().getDiagram();
        }
        return this.diagram;
    }

    protected PictogramElement getSingleInput() {
        Object fe;
        ISelection sel = this.getSelection();
        if (sel instanceof IStructuredSelection && (fe = ((IStructuredSelection)sel).getFirstElement()) != null && fe instanceof PictogramElement) {
            return (PictogramElement)fe;
        }
        return null;
    }

    protected List<PictogramElement> getInput() {
        ISelection sel = this.getSelection();
        if (sel instanceof IStructuredSelection) {
            Object[] fe;
            Object[] objectArray = fe = ((IStructuredSelection)sel).toArray();
            int n = fe.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (!(object instanceof PictogramElement)) {
                    return Collections.EMPTY_LIST;
                }
                ++n2;
            }
            return new ArrayList<Object>(Arrays.asList(fe));
        }
        return Collections.EMPTY_LIST;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        IEditingDomainProvider provider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class);
        assert (provider.getEditingDomain() instanceof TransactionalEditingDomain);
        this.editingDomain = (TransactionalEditingDomain)provider.getEditingDomain();
        ArrayList<PictogramElement> objects = new ArrayList<PictogramElement>();
        if (selection instanceof IStructuredSelection) {
            for (GraphicalEditPart editPart : (IStructuredSelection)selection) {
                objects.add((PictogramElement)editPart.getModel());
            }
        }
        StructuredSelection newSelection = new StructuredSelection(objects);
        super.setInput(part, (ISelection)newSelection);
        this.refresh();
    }
}

