/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.clipboard.img;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.graphiti.ui.internal.fixed.FixedScaledGraphics;
import org.eclipse.graphiti.ui.internal.parts.CompositeConnectionEditPart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class GraphitiImageConverter {
    private static final int SCALE_FACTOR = 1;

    private GraphitiImageConverter() {
    }

    public static Image convertEditParts(int[] minMaxCoords, Collection<EditPart> selectedEditParts) {
        HashSet<EditPart> selectedEditPartsWithNested = new HashSet<EditPart>(selectedEditParts);
        int width = minMaxCoords[2] - minMaxCoords[0];
        int height = minMaxCoords[3] - minMaxCoords[1];
        Image scaledImage = GraphitiImageConverter.createTransparentImage(width, height);
        FixedScaledGraphics graphics = GraphitiImageConverter.createGraphics(minMaxCoords, scaledImage);
        HashSet connectionEditParts = new HashSet();
        for (EditPart part : selectedEditParts) {
            GraphicalEditPart selectionEditpart = (GraphicalEditPart)part;
            IFigure selectionFigure = selectionEditpart.getFigure();
            selectionFigure.paint((Graphics)graphics);
            connectionEditParts.addAll(selectionEditpart.getSourceConnections());
            Collection<EditPart> nested = GraphitiImageConverter.findAllNested((EditPart)selectionEditpart, new ArrayList<EditPart>());
            selectedEditPartsWithNested.addAll(nested);
            for (EditPart editpart : nested) {
                if (!(editpart instanceof GraphicalEditPart)) continue;
                connectionEditParts.addAll(((GraphicalEditPart)editpart).getSourceConnections());
            }
        }
        for (ConnectionEditPart editPart : connectionEditParts) {
            if (!selectedEditPartsWithNested.contains(editPart.getSource()) || !selectedEditPartsWithNested.contains(editPart.getTarget())) continue;
            IFigure connectionFigure = editPart.getFigure();
            connectionFigure.paint((Graphics)graphics);
            if (!(editPart instanceof CompositeConnectionEditPart)) continue;
            CompositeConnectionEditPart compositePart = (CompositeConnectionEditPart)editPart;
            for (ConnectionEditPart childEdit : compositePart.getEditParts()) {
                IFigure connectionFigureChild = childEdit.getFigure();
                connectionFigureChild.paint((Graphics)graphics);
            }
        }
        return scaledImage;
    }

    private static Collection<EditPart> findAllNested(EditPart container, Collection<EditPart> nested) {
        for (Object child : container.getChildren()) {
            if (!(child instanceof EditPart)) continue;
            nested.add((EditPart)child);
            GraphitiImageConverter.findAllNested((EditPart)child, nested);
        }
        return nested;
    }

    private static FixedScaledGraphics createGraphics(int[] minMaxCoords, Image scaledImage) {
        GC gc = new GC((Drawable)scaledImage);
        FixedScaledGraphics graphics = new FixedScaledGraphics((Graphics)new SWTGraphics(gc));
        graphics.scale(1.0);
        graphics.translate(-minMaxCoords[0], -minMaxCoords[1]);
        return graphics;
    }

    private static Image createTransparentImage(int width, int height) {
        RGB almostWhite = new RGB(254, 254, 254);
        Image scaledImage = new Image((Device)Display.getDefault(), width, height);
        ImageData imageData = scaledImage.getImageData();
        int whitePixel = imageData.palette.getPixel(almostWhite);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                imageData.setPixel(x, y, whitePixel);
                ++y;
            }
            ++x;
        }
        imageData.transparentPixel = whitePixel;
        scaledImage = new Image((Device)Display.getDefault(), imageData);
        return scaledImage;
    }
}

