/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.StorageAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.features.add.FMCNodeAddFeature;
import org.eclipse.fmc.blockdiagram.editor.model.ShapeStyle;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;

public class StorageAddFeature
extends FMCNodeAddFeature {
    private static int MIN_WIDTH = 70;
    private static int MIN_HEIGHT = 30;

    public StorageAddFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
        this.minimumWidth = MIN_WIDTH;
        this.minimumHeight = MIN_HEIGHT;
    }

    public StorageAddFeature(IFeatureProvider featureProvider, ShapeStyle style) {
        super(featureProvider, style);
        this.setDefaultSize(style);
    }

    private void setDefaultSize(ShapeStyle style) {
        block7: {
            block6: {
                if (style == null) break block6;
                switch (style) {
                    case RECT: {
                        this.minimumWidth = 60;
                        this.minimumHeight = 40;
                        break block7;
                    }
                    case L: {
                        this.minimumWidth = 70;
                        this.minimumHeight = 70;
                        break block7;
                    }
                    case U: {
                        this.minimumWidth = 90;
                        this.minimumHeight = 70;
                        break block7;
                    }
                    default: {
                        assert (false) : "No style literal matched in switch";
                        break block7;
                    }
                }
            }
            this.minimumWidth = MIN_WIDTH;
            this.minimumHeight = MIN_HEIGHT;
        }
    }

    @Override
    protected GraphicsAlgorithm createGraphics(GraphicsAlgorithmContainer gaContainer, IAddContext context) {
        StorageAlgorithm algorithm = FMCNodeAlgorithmFactory.getInstance().getStorageByShapestyle(this.shapeType);
        return algorithm.createGraphics(this.getDiagram(), gaContainer, 0, 0, this.getWidth(context), this.getHeight(context));
    }
}

