/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.property;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.blockdiagram.editor.util.FontUtils;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.mm.pictograms.util.PictogramsAdapterFactory;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ColorsAndFontsPropertySection
extends AbstractPropertySection
implements IPropertySourceProvider {
    private static final String TOOLTIP_BG_COLOR = "Sets the background color of the selcted shape";
    private static final String TOOLTIP_FG_COLOR = "Sets the color of the frame for the selected shape";
    private static final String TOOLTIP_FONT_COLOR = "Sets the color for the font of the selected shape";
    private static final String TOOLTIP_TRANSPARENCY = "Sets the transparency of the selected shape.";
    private static final String TOOLTIP_TEXT_ANGLE = "Rotates the text of the selected shape by the chosen angle.";
    private static final String TOOLTIP_STYLE = "A predefined style for the shape can be selected. By changing the predefined style of a shape it will loose its own style information and inherits the style of predefined one. Predefined styles can be maintained in the Predefined Styles Property Tab.";
    private static final String TOOLTIP_ITALIC = "Sets the font type to italic for the text of the selected shape(s).";
    private static final String TOOLTIP_BOLD = "Sets the font type to bold for the text of the selected shape(s).";
    private static final String TOOLTIP_FONT_SIZE = "Changes the font size for the text of the selected shape(s).";
    private static final String TOOLTIP_RECURSIVE_FONT = "Propagates all changes to fonts also to fonts of children shapes.";
    private static final String TOOLTIP_FONT_TYPE = "Sets the font type for the text of the selected shape(s).";
    private static final String NONE = "NONE";
    protected boolean disposed;
    protected CCombo fontsCombo;
    protected CCombo sizesCombo;
    protected CCombo stylesCombo;
    protected Label foreLabel;
    protected Label backLabel;
    protected Label fontLabel;
    protected Spinner transparency;
    protected Spinner textAngle;
    protected TransactionalEditingDomain editingDomain;
    protected Button isRecursiveFont;
    protected Button isBold;
    protected Button isItalic;
    protected Diagram diagram;
    protected Composite comp;
    protected GridData gridData;

    public IPropertySource getPropertySource(Object object) {
        IItemPropertySource itemPropertySource;
        if (object instanceof IPropertySource) {
            return (IPropertySource)object;
        }
        AdapterFactory adapterFactory = this.getAdapterFactory(object);
        if (adapterFactory != null && (itemPropertySource = (IItemPropertySource)adapterFactory.adapt(object, IItemPropertySource.class)) != null) {
            return new PropertySource(object, itemPropertySource);
        }
        if (object instanceof IAdaptable) {
            return (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
        }
        return null;
    }

    protected AdapterFactory getAdapterFactory(Object object) {
        return new PictogramsAdapterFactory();
    }

    private boolean fontSupported(String fontName) {
        String[] stringArray = FontUtils.getFontNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedFontName = stringArray[n2];
            if (fontName.equals(supportedFontName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected PictogramElement getColorElement() {
        if (this.getInput().isEmpty()) {
            return null;
        }
        return this.getInput().get(0);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory fac = this.getWidgetFactory();
        this.comp = fac.createComposite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        this.comp.setLayout((Layout)layout);
        this.comp.setLayoutData((Object)this.gridData);
        this.createFontColorControl(fac, this.comp);
        this.createFontTypeControl(fac, this.comp);
        this.createFontSizeControl(fac, this.comp);
        this.createTextAngleControl(fac, this.comp);
        this.createBackgroundColorControl(fac, this.comp);
        this.createTransparencyControl(fac, this.comp);
        this.createBoldControl(fac, this.comp);
        this.createItalicControl(fac, this.comp);
        this.createForegroundColorControl(fac, this.comp);
        this.createStyleControl(fac, this.comp);
        this.createRecursiveFontControl(fac, this.comp);
        this.refresh();
    }

    protected void createFontTypeControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        Label label = fac.createLabel(comp, "Font Type:");
        label.setToolTipText(TOOLTIP_FONT_TYPE);
        this.fontsCombo = fac.createCCombo(comp);
        this.fontsCombo.setToolTipText(TOOLTIP_FONT_TYPE);
        this.fontsCombo.setItems(FontUtils.getFontNames());
        this.fontsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorsAndFontsPropertySection.this.updateFonts();
            }
        });
    }

    protected void createFontSizeControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        Label label = fac.createLabel(comp, "Font Size:");
        label.setToolTipText(TOOLTIP_FONT_SIZE);
        this.sizesCombo = fac.createCCombo(comp);
        this.sizesCombo.setToolTipText(TOOLTIP_FONT_SIZE);
        this.sizesCombo.setItems(FontUtils.FONT_SIZES);
        this.sizesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorsAndFontsPropertySection.this.updateFonts();
            }
        });
    }

    protected void createBoldControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        Label label = fac.createLabel(comp, "Bold:");
        label.setToolTipText(TOOLTIP_BOLD);
        this.isBold = new Button(comp, 32);
        this.isBold.setToolTipText(TOOLTIP_FONT_SIZE);
        this.isBold.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColorsAndFontsPropertySection.this.updateFonts();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createItalicControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        Label label = fac.createLabel(comp, "Italic:");
        label.setToolTipText(TOOLTIP_ITALIC);
        this.isItalic = new Button(comp, 32);
        this.isItalic.setToolTipText(TOOLTIP_ITALIC);
        this.isItalic.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColorsAndFontsPropertySection.this.updateFonts();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createFontColorControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        this.fontLabel = fac.createLabel(comp, "Font Color:");
        this.fontLabel.setToolTipText(TOOLTIP_FONT_COLOR);
        Button bt3 = fac.createButton(comp, "Change Font Color...", 8);
        bt3.setToolTipText(TOOLTIP_FONT_COLOR);
        bt3.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FMCUtil.getActiveEditor().getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(FMCUtil.getActiveEditor().getEditingDomain()){

                    protected void doExecute() {
                        ColorsAndFontsPropertySection.this.updateFontColors(FMCUtil.editColor(null, (this).ColorsAndFontsPropertySection.this.diagram));
                    }
                });
            }
        });
    }

    protected void createRecursiveFontControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        Label label = fac.createLabel(comp, "Change Fonts for Children:");
        label.setToolTipText(TOOLTIP_RECURSIVE_FONT);
        this.isRecursiveFont = new Button(comp, 32);
        this.isRecursiveFont.setToolTipText(TOOLTIP_RECURSIVE_FONT);
    }

    protected void createForegroundColorControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        this.foreLabel = fac.createLabel(comp, "Foreground:");
        this.foreLabel.setToolTipText(TOOLTIP_FG_COLOR);
        Button bt = fac.createButton(comp, "Change Foreground Color...", 8);
        bt.setToolTipText(TOOLTIP_FG_COLOR);
        bt.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FMCUtil.getActiveEditor().getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(FMCUtil.getActiveEditor().getEditingDomain()){

                    protected void doExecute() {
                        if (!ColorsAndFontsPropertySection.this.getInput().isEmpty()) {
                            ColorsAndFontsPropertySection.this.updateColors(ColorsAndFontsPropertySection.this.getInput().get(0), FMCUtil.editColor(ColorsAndFontsPropertySection.this.getColorElement().getGraphicsAlgorithm().getForeground(), (this).ColorsAndFontsPropertySection.this.diagram), true);
                        }
                    }
                });
            }
        });
    }

    protected void createBackgroundColorControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        this.backLabel = fac.createLabel(comp, "Background:");
        this.backLabel.setToolTipText(TOOLTIP_BG_COLOR);
        Button bt2 = fac.createButton(comp, "Change Background Color...", 8);
        bt2.setToolTipText(TOOLTIP_BG_COLOR);
        bt2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FMCUtil.getActiveEditor().getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(FMCUtil.getActiveEditor().getEditingDomain()){

                    protected void doExecute() {
                        if (!ColorsAndFontsPropertySection.this.getInput().isEmpty()) {
                            ColorsAndFontsPropertySection.this.updateColors(ColorsAndFontsPropertySection.this.getInput().get(0), FMCUtil.editColor(ColorsAndFontsPropertySection.this.getColorElement().getGraphicsAlgorithm().getBackground(), (this).ColorsAndFontsPropertySection.this.diagram), false);
                        }
                    }
                });
            }
        });
    }

    protected void createTransparencyControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        Label label = fac.createLabel(comp, "Transparency:");
        label.setToolTipText(TOOLTIP_TRANSPARENCY);
        this.transparency = new Spinner(comp, 2048);
        this.transparency.setToolTipText(TOOLTIP_TRANSPARENCY);
        this.transparency.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                double transparencyValue = ((Spinner)e.getSource()).getSelection();
                for (PictogramElement el : ColorsAndFontsPropertySection.this.getInput()) {
                    ColorsAndFontsPropertySection.this.updateTransparency(el, transparencyValue);
                }
            }
        });
    }

    protected void createTextAngleControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        Label label = fac.createLabel(comp, "Text Angle:");
        label.setToolTipText(TOOLTIP_TEXT_ANGLE);
        this.textAngle = new Spinner(comp, 2048);
        this.textAngle.setToolTipText(TOOLTIP_TEXT_ANGLE);
        this.textAngle.setMaximum(360);
        this.textAngle.setIncrement(90);
        this.textAngle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int angle = ((Spinner)e.getSource()).getSelection();
                for (PictogramElement el : ColorsAndFontsPropertySection.this.getInput()) {
                    ColorsAndFontsPropertySection.this.rotateText(el, angle);
                }
            }
        });
    }

    protected void createStyleControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        Label label = fac.createLabel(comp, "Style:");
        label.setToolTipText(TOOLTIP_STYLE);
        this.stylesCombo = fac.createCCombo(comp);
        this.stylesCombo.setToolTipText(TOOLTIP_STYLE);
        this.stylesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (PictogramElement el : ColorsAndFontsPropertySection.this.getInput()) {
                    ColorsAndFontsPropertySection.this.updateStyle(el, ColorsAndFontsPropertySection.this.stylesCombo.getItem(ColorsAndFontsPropertySection.this.stylesCombo.getSelectionIndex()));
                }
            }
        });
    }

    protected void updateStyle(final PictogramElement el, final String styleId) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                Style style = ColorsAndFontsPropertySection.this.getStyle(styleId);
                GraphicsAlgorithm ga = el.getGraphicsAlgorithm();
                if (ColorsAndFontsPropertySection.NONE.equals(styleId)) {
                    ColorsAndFontsPropertySection.this.updateStyle(ga, null);
                } else {
                    AbstractText text;
                    ColorsAndFontsPropertySection.this.updateStyle(ga, style);
                    if (el instanceof ContainerShape && (text = ColorsAndFontsPropertySection.this.getTextFromShape((ContainerShape)el)) != null) {
                        text.setForeground(null);
                        text.setFont(null);
                        text.setStyle(style);
                    }
                }
            }
        });
    }

    private void updateStyle(GraphicsAlgorithm ga, Style style) {
        ga.setStyle(style);
        ga.setTransparency(null);
        ga.setBackground(null);
        ga.setForeground(null);
        for (GraphicsAlgorithm gaChild : ga.getGraphicsAlgorithmChildren()) {
            this.updateStyle(gaChild, style);
        }
    }

    private Style getStyle(String styleId) {
        for (Style style : this.diagram.getStyles()) {
            if (!styleId.equals(style.getId())) continue;
            return style;
        }
        return null;
    }

    private String[] getStyleIds() {
        String[] styles = new String[this.diagram.getStyles().size()];
        int i = 0;
        for (Style style : this.diagram.getStyles()) {
            styles[i] = style.getId();
            ++i;
        }
        return styles;
    }

    protected void updateTransparency(final PictogramElement el, final double transparencyValue) {
        FMCUtil.getActiveEditor().getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(FMCUtil.getActiveEditor().getEditingDomain()){

            protected void doExecute() {
                GraphicsAlgorithm graphicsAlgorithm = el.getGraphicsAlgorithm();
                double trans = graphicsAlgorithm.getTransparency() == null ? 0.0 : graphicsAlgorithm.getTransparency();
                BigDecimal decimal = new BigDecimal(trans, new MathContext(2));
                if (Double.compare(transparencyValue / 100.0, decimal.doubleValue()) != 0) {
                    graphicsAlgorithm.setTransparency(Double.valueOf(transparencyValue / 100.0));
                    for (GraphicsAlgorithm childGa : graphicsAlgorithm.getGraphicsAlgorithmChildren()) {
                        childGa.setTransparency(Double.valueOf(transparencyValue / 100.0));
                    }
                }
            }
        });
    }

    protected void rotateText(final PictogramElement el, final int angle) {
        FMCUtil.getActiveEditor().getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(FMCUtil.getActiveEditor().getEditingDomain()){

            protected void doExecute() {
                if (el instanceof ContainerShape) {
                    ContainerShape container = (ContainerShape)el;
                    AbstractText textFromShape = ColorsAndFontsPropertySection.this.getTextFromShape(container);
                    if (textFromShape != null && textFromShape.getAngle() != angle) {
                        textFromShape.setAngle(Integer.valueOf(angle));
                        ColorsAndFontsPropertySection.this.refresh();
                    }
                    if (ColorsAndFontsPropertySection.this.isRecursiveFont.getSelection()) {
                        for (Shape shape : container.getChildren()) {
                            ColorsAndFontsPropertySection.this.rotateText((PictogramElement)shape, angle);
                        }
                    }
                } else if (el.getGraphicsAlgorithm() instanceof AbstractText && ((AbstractText)el.getGraphicsAlgorithm()).getAngle() != angle) {
                    ((AbstractText)el.getGraphicsAlgorithm()).setAngle(Integer.valueOf(angle));
                    ColorsAndFontsPropertySection.this.refresh();
                }
            }
        });
    }

    protected void updateFonts() {
        for (PictogramElement el : this.getInput()) {
            this.updateFont(el);
        }
    }

    protected void updateFont(PictogramElement el) {
        block5: {
            block6: {
                block4: {
                    if (!(el.getGraphicsAlgorithm() instanceof AbstractText)) break block4;
                    AbstractText text = (AbstractText)el.getGraphicsAlgorithm();
                    this.updateFont(text);
                    break block5;
                }
                if (!(el instanceof ContainerShape)) break block6;
                ContainerShape container = (ContainerShape)el;
                AbstractText text = this.getTextFromShape(container);
                if (text != null) {
                    this.updateFont(text);
                }
                if (!this.isRecursiveFont.getSelection()) break block5;
                for (Shape shape : container.getChildren()) {
                    this.updateFont((PictogramElement)shape);
                }
                break block5;
            }
            if (el instanceof Connection) {
                Connection con = (Connection)el;
                for (ConnectionDecorator decorator : con.getConnectionDecorators()) {
                    if (!(decorator.getGraphicsAlgorithm() instanceof AbstractText)) continue;
                    this.updateFont((AbstractText)decorator.getGraphicsAlgorithm());
                }
            }
        }
    }

    protected void updateFont(final AbstractText text) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                text.setFont(Graphiti.getGaService().manageFont(ColorsAndFontsPropertySection.this.diagram, ColorsAndFontsPropertySection.this.fontsCombo.getItem(ColorsAndFontsPropertySection.this.fontsCombo.getSelectionIndex()), Integer.parseInt(ColorsAndFontsPropertySection.this.sizesCombo.getItem(ColorsAndFontsPropertySection.this.sizesCombo.getSelectionIndex())), ColorsAndFontsPropertySection.this.isItalic.getSelection(), ColorsAndFontsPropertySection.this.isBold.getSelection()));
            }
        });
    }

    protected void updateColors(final PictogramElement el, final org.eclipse.graphiti.mm.algorithms.styles.Color c, final boolean isForeground) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                ColorsAndFontsPropertySection.this.updateColors(el.getGraphicsAlgorithm(), c, isForeground);
            }
        });
        this.refresh();
    }

    private void updateColors(GraphicsAlgorithm ga, org.eclipse.graphiti.mm.algorithms.styles.Color c, boolean isForeground) {
        if (isForeground) {
            ga.setForeground(c);
        } else {
            if (ga.getStyle() != null) {
                ga.getStyle().setRenderingStyle(null);
            }
            ga.setBackground(c);
        }
        for (GraphicsAlgorithm gaChild : ga.getGraphicsAlgorithmChildren()) {
            this.updateColors(gaChild, c, isForeground);
        }
    }

    protected void updateFontColors(org.eclipse.graphiti.mm.algorithms.styles.Color c) {
        for (PictogramElement el : this.getInput()) {
            this.updateFontColor(c, el);
        }
    }

    protected void updateFontColor(org.eclipse.graphiti.mm.algorithms.styles.Color c, PictogramElement el) {
        if (el instanceof ContainerShape) {
            ContainerShape container = (ContainerShape)el;
            AbstractText textFromShape = this.getTextFromShape(container);
            if (textFromShape != null) {
                this.updateFontColor(c, textFromShape);
            }
            if (this.isRecursiveFont.getSelection()) {
                for (Shape shape : container.getChildren()) {
                    this.updateFontColor(c, (PictogramElement)shape);
                }
            }
            this.refresh();
        } else if (el.getGraphicsAlgorithm() instanceof AbstractText) {
            this.updateFontColor(c, (AbstractText)el.getGraphicsAlgorithm());
        }
    }

    protected void updateFontColor(final org.eclipse.graphiti.mm.algorithms.styles.Color c, final AbstractText ga) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                ga.setForeground(c);
            }
        });
        this.refresh();
    }

    protected void updateLines() {
    }

    public void dispose() {
        super.dispose();
        this.disposed = true;
    }

    public void refresh() {
        if (!this.isDisposed()) {
            PictogramElement el = this.getColorElement();
            if (el != null && el instanceof Shape) {
                GraphicsAlgorithm ga = el.getGraphicsAlgorithm();
                if (ga == null) {
                    return;
                }
                this.stylesCombo.setItems(this.getStyleIds());
                if (ga.getStyle() != null) {
                    this.stylesCombo.setText(ga.getStyle().getId());
                } else {
                    this.stylesCombo.setText(NONE);
                }
                if (ga instanceof AbstractText) {
                    this.fontsCombo.setEnabled(true);
                    if (((AbstractText)ga).getFont() == null) {
                        this.defaultCombos();
                    } else {
                        Font font = ((AbstractText)ga).getFont();
                        this.fontsCombo.setText(font.getName());
                        this.sizesCombo.setEnabled(true);
                        this.sizesCombo.setText(String.valueOf(font.getSize()));
                        this.isBold.setSelection(font.isBold());
                        this.isItalic.setSelection(font.isItalic());
                        this.textAngle.setSelection(((AbstractText)ga).getAngle().intValue());
                    }
                } else {
                    if (el instanceof ContainerShape) {
                        ContainerShape container = (ContainerShape)el;
                        if (ga.getTransparency() != null) {
                            this.transparency.setSelection((int)(ga.getTransparency() * 100.0));
                        } else {
                            this.transparency.setSelection(0);
                        }
                        AbstractText text = this.getTextFromShape(container);
                        if (text != null) {
                            this.textAngle.setSelection(text.getAngle().intValue());
                            this.extractFontFromText(text);
                            this.setColorOfFCLabel(text.getForeground());
                        }
                    } else {
                        this.disableCombos();
                    }
                    org.eclipse.graphiti.mm.algorithms.styles.Color back = ga.getBackground();
                    this.setColorOfBGLabel(back);
                    org.eclipse.graphiti.mm.algorithms.styles.Color fore = ga.getForeground();
                    this.setColorOfFGLabel(fore);
                }
            } else if (el instanceof Connection) {
                Connection con = (Connection)el;
                for (ConnectionDecorator decorator : con.getConnectionDecorators()) {
                    if (!(decorator.getGraphicsAlgorithm() instanceof AbstractText)) continue;
                    this.extractFontFromText((AbstractText)decorator.getGraphicsAlgorithm());
                }
            }
            this.refreshGridLayout();
        }
    }

    protected void refreshGridLayout() {
        ScrolledComposite tabbedPropertyComposite = this.findTabbedPropertyComposite(this.comp);
        if (tabbedPropertyComposite != null) {
            int cols = tabbedPropertyComposite.getSize().x / 200 * 2;
            cols = cols < 2 ? 2 : cols;
            this.comp.setLayout((Layout)new GridLayout(cols > 8 ? 8 : cols, false));
            this.comp.layout();
        }
    }

    protected void setColorOfFCLabel(org.eclipse.graphiti.mm.algorithms.styles.Color fore) {
        if (fore != null) {
            this.fontLabel.setBackground(new Color((Device)Display.getDefault(), fore.getRed(), fore.getGreen(), fore.getBlue()));
            this.fontLabel.setForeground(new Color((Device)Display.getDefault(), 255 - fore.getRed(), 255 - fore.getGreen(), 255 - fore.getBlue()));
        } else {
            this.fontLabel.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
            this.fontLabel.setForeground(new Color((Device)Display.getDefault(), 0, 0, 0));
        }
    }

    protected void setColorOfFGLabel(org.eclipse.graphiti.mm.algorithms.styles.Color fore) {
        if (fore != null) {
            this.foreLabel.setBackground(new Color((Device)Display.getDefault(), fore.getRed(), fore.getGreen(), fore.getBlue()));
            this.foreLabel.setForeground(new Color((Device)Display.getDefault(), 255 - fore.getRed(), 255 - fore.getGreen(), 255 - fore.getBlue()));
        } else {
            this.foreLabel.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
            this.foreLabel.setForeground(new Color((Device)Display.getDefault(), 0, 0, 0));
        }
    }

    protected void setColorOfBGLabel(org.eclipse.graphiti.mm.algorithms.styles.Color back) {
        if (back != null) {
            this.backLabel.setBackground(new Color((Device)Display.getDefault(), back.getRed(), back.getGreen(), back.getBlue()));
            this.backLabel.setForeground(new Color((Device)Display.getDefault(), 255 - back.getRed(), 255 - back.getGreen(), 255 - back.getBlue()));
        } else {
            this.backLabel.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
            this.backLabel.setForeground(new Color((Device)Display.getDefault(), 0, 0, 0));
        }
    }

    protected void extractFontFromText(AbstractText text) {
        if (text != null && text.getFont() != null) {
            this.fontsCombo.setEnabled(true);
            this.fontsCombo.setText(text.getFont().getName());
            this.sizesCombo.setEnabled(true);
            this.sizesCombo.setText(String.valueOf(text.getFont().getSize()));
            this.isBold.setSelection(text.getFont().isBold());
            this.isItalic.setSelection(text.getFont().isItalic());
        } else if (text != null && text.getStyle() != null && text.getStyle().getFont() != null) {
            this.fontsCombo.setEnabled(true);
            this.fontsCombo.setText(text.getStyle().getFont().getName());
            this.sizesCombo.setEnabled(true);
            this.sizesCombo.setText(String.valueOf(text.getStyle().getFont().getSize()));
            this.isBold.setSelection(text.getStyle().getFont().isBold());
            this.isItalic.setSelection(text.getStyle().getFont().isItalic());
        } else {
            this.defaultCombos();
        }
    }

    protected AbstractText getTextFromShape(ContainerShape container) {
        AbstractText text = null;
        for (Shape shape : container.getChildren()) {
            if (!(shape.getGraphicsAlgorithm() instanceof AbstractText)) continue;
            text = (AbstractText)shape.getGraphicsAlgorithm();
            return text;
        }
        for (Shape shape : container.getChildren()) {
            AbstractText textFromShape;
            if (!(shape instanceof ContainerShape) || (textFromShape = this.getTextFromShape((ContainerShape)shape)) == null) continue;
            return textFromShape;
        }
        for (GraphicsAlgorithm ga : container.getGraphicsAlgorithm().getGraphicsAlgorithmChildren()) {
            if (!(ga instanceof AbstractText)) continue;
            return (AbstractText)ga;
        }
        return text;
    }

    protected void disableCombos() {
        this.fontsCombo.clearSelection();
        this.fontsCombo.setText("");
        this.fontsCombo.setEnabled(false);
        this.sizesCombo.clearSelection();
        this.sizesCombo.setText("");
        this.sizesCombo.setEnabled(false);
    }

    protected void defaultCombos() {
        if (this.fontSupported("Arial")) {
            this.fontsCombo.setText("Arial");
        } else if (FontUtils.getFontNames().length > 0) {
            this.fontsCombo.setText(FontUtils.getFontNames()[0]);
        }
        this.fontsCombo.setEnabled(true);
        this.sizesCombo.setText("8");
        this.sizesCombo.setEnabled(true);
        this.isBold.setSelection(false);
        this.isItalic.setSelection(false);
    }

    protected List<PictogramElement> getInput() {
        ISelection sel = this.getSelection();
        if (sel instanceof IStructuredSelection) {
            Object[] fe;
            Object[] objectArray = fe = ((IStructuredSelection)sel).toArray();
            int n = fe.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (!(object instanceof PictogramElement)) {
                    return Collections.EMPTY_LIST;
                }
                ++n2;
            }
            return new ArrayList<Object>(Arrays.asList(fe));
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)2)).and(NotificationFilter.createNotifierTypeFilter(EObject.class));
    }

    public void update(Notification notification) {
        final EObject eObject = (EObject)notification.getNotifier();
        if (!this.isDisposed() && this.isSelection(eObject) && !this.isDeleted(eObject)) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ColorsAndFontsPropertySection.this.isDisposed() && ColorsAndFontsPropertySection.this.isSelection(eObject) && !ColorsAndFontsPropertySection.this.isDeleted(eObject)) {
                        ColorsAndFontsPropertySection.this.refresh();
                    }
                }
            });
        }
    }

    protected boolean isSelection(EObject eObject) {
        ISelection selection = this.getSelection();
        if (selection == null) {
            return false;
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        if (s.size() > 1) {
            return false;
        }
        Iterator it = s.iterator();
        while (it.hasNext()) {
            if (eObject != it.next()) continue;
            return true;
        }
        return false;
    }

    protected boolean isDeleted(EObject eObject) {
        return eObject.eResource() == null;
    }

    protected Display getDisplay() {
        return this.getPart().getSite().getShell().getDisplay();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        IEditingDomainProvider provider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class);
        assert (provider.getEditingDomain() instanceof TransactionalEditingDomain);
        this.editingDomain = (TransactionalEditingDomain)provider.getEditingDomain();
        this.diagram = FMCUtil.getActiveEditor().getDiagramTypeProvider().getDiagram();
        ArrayList<PictogramElement> objects = new ArrayList<PictogramElement>();
        if (selection instanceof IStructuredSelection) {
            for (GraphicalEditPart editPart : (IStructuredSelection)selection) {
                objects.add((PictogramElement)editPart.getModel());
            }
        }
        StructuredSelection newSelection = new StructuredSelection(objects);
        super.setInput(part, (ISelection)newSelection);
        this.refresh();
    }

    protected ScrolledComposite findTabbedPropertyComposite(Composite comp) {
        if (comp.getParent() == null) {
            return null;
        }
        if (comp.getParent() instanceof ScrolledComposite) {
            return (ScrolledComposite)comp.getParent();
        }
        return this.findTabbedPropertyComposite(comp.getParent());
    }
}

