/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.property;

import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.fmc.blockdiagram.editor.property.FMCColorsAndFontsPropertySection;
import org.eclipse.fmc.blockdiagram.editor.property.FMCPropertySection;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.blockdiagram.editor.util.StyleUtil;
import org.eclipse.graphiti.mm.StyleContainer;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.AdaptedGradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredArea;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredLocation;
import org.eclipse.graphiti.mm.algorithms.styles.LocationType;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.algorithms.styles.StylesFactory;
import org.eclipse.graphiti.mm.algorithms.styles.StylesPackage;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.util.IGradientType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class PredefinedStylesPropertySection
extends FMCPropertySection {
    private static final String TOOLTIP_CREATE_STYLE = "Creates a new style with the name given in the text field. The newly created style will automatically be selected.";
    private static final String TOOLTIP_STYLE_NAME = "Sets the name of the new style to be created.";
    private static final String TOOLTIP_GRADIENT_STYLE = "Set the type of the gradient which can be either vertical, horizontal or none for no gradient color.";
    private static final String TOOLTIP_STYLE_CONTROL = "The currently selected predefined style. All style properties shown in this property tab correspond to the selected style.";
    private static final String TOOLTIP_GRADIENT_COLOR = "Sets the gradient target color if the selected gradient style is either vertical or horizontal. The source color is the selected background color.";
    private Label gradientColorLabel;
    private CCombo stylesCombo;
    private CCombo gradientType;
    protected Button gradientColor;
    protected Button createStyle;
    protected Text styleName;
    private static final BigDecimal HUNDRET = new BigDecimal(100);
    private StyleColorsAndFontsPropertySection propSection = new StyleColorsAndFontsPropertySection();

    protected void createGradientTypeControl(TabbedPropertySheetWidgetFactory fac, Composite parent) {
        Composite comp = fac.createComposite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label label = fac.createLabel(comp, "Gradient Type:");
        label.setToolTipText(TOOLTIP_GRADIENT_STYLE);
        this.gradientType = fac.createCCombo(comp);
        this.gradientType.setToolTipText(TOOLTIP_GRADIENT_STYLE);
        this.gradientType.setItems(new String[]{"NONE", "VERTICAL", "HORIZONTAL"});
        this.gradientType.setData("VERTICAL", (Object)IGradientType.VERTICAL);
        this.gradientType.setData("HORIZONTAL", (Object)IGradientType.HORIZONTAL);
        this.gradientType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PredefinedStylesPropertySection.this.stylesCombo.getSelectionIndex() >= 0) {
                    PredefinedStylesPropertySection.this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(PredefinedStylesPropertySection.this.editingDomain){

                        protected void doExecute() {
                            Style style = StyleUtil.findStyle(PredefinedStylesPropertySection.this.getDiagram(), PredefinedStylesPropertySection.this.getSelectedStyleId());
                            if (PredefinedStylesPropertySection.this.gradientType.getSelectionIndex() == 0) {
                                style.setRenderingStyle(null);
                            } else {
                                if (style.getRenderingStyle() == null) {
                                    PredefinedStylesPropertySection.this.createRenderingStyle(style);
                                }
                                AdaptedGradientColoredAreas adaptedGradientColoredAreas = style.getRenderingStyle().getAdaptedGradientColoredAreas();
                                adaptedGradientColoredAreas.setGradientType((Integer)PredefinedStylesPropertySection.this.gradientType.getData(PredefinedStylesPropertySection.this.getSelectedGradientType()));
                            }
                        }
                    });
                }
            }
        });
    }

    protected void createStyleControl(TabbedPropertySheetWidgetFactory fac, Composite parent) {
        Composite comp = fac.createComposite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label label = fac.createLabel(comp, "Selected Style:");
        label.setToolTipText(TOOLTIP_STYLE_CONTROL);
        this.stylesCombo = fac.createCCombo(comp);
        this.stylesCombo.setToolTipText(TOOLTIP_STYLE_CONTROL);
        this.stylesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PredefinedStylesPropertySection.this.stylesCombo.getSelectionIndex() >= 0) {
                    String item = PredefinedStylesPropertySection.this.getSelectedStyleId();
                    PredefinedStylesPropertySection.this.createOrSelectStyle(item);
                }
            }
        });
    }

    protected void createGradientColorControl(TabbedPropertySheetWidgetFactory fac, Composite parent) {
        Composite comp = fac.createComposite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.gradientColorLabel = fac.createLabel(comp, "Gradient Color");
        this.gradientColorLabel.setToolTipText(TOOLTIP_GRADIENT_COLOR);
        this.gradientColor = fac.createButton(comp, "Change Gradient Color...", 8);
        this.gradientColor.setToolTipText(TOOLTIP_GRADIENT_COLOR);
        this.gradientColor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PredefinedStylesPropertySection.this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(PredefinedStylesPropertySection.this.editingDomain){

                    protected void doExecute() {
                        if (PredefinedStylesPropertySection.this.gradientType.getSelectionIndex() > 0) {
                            PredefinedStylesPropertySection.this.updateGradientColor(true);
                        }
                    }
                });
            }
        });
    }

    private org.eclipse.graphiti.mm.algorithms.styles.Color getGradientColor(Style style) {
        if (style.getRenderingStyle() != null) {
            AdaptedGradientColoredAreas adaptedGradientColoredAreas = style.getRenderingStyle().getAdaptedGradientColoredAreas();
            if (!adaptedGradientColoredAreas.getAdaptedGradientColoredAreas().isEmpty()) {
                GradientColoredAreas oldGradientColoredAreas = (GradientColoredAreas)adaptedGradientColoredAreas.getAdaptedGradientColoredAreas().get(0);
                GradientColoredLocation oldGradientColor = ((GradientColoredArea)oldGradientColoredAreas.getGradientColor().get(0)).getEnd();
                return oldGradientColor.getColor();
            }
            return this.createNewColor(style.getForeground());
        }
        return this.createNewColor(style.getForeground());
    }

    private void createNewStyleControl(TabbedPropertySheetWidgetFactory fac, Composite parent) {
        Composite comp = fac.createComposite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.styleName = fac.createText(comp, "");
        this.styleName.setToolTipText(TOOLTIP_STYLE_NAME);
        this.createStyle = fac.createButton(comp, "Create New Style", 8);
        this.createStyle.setToolTipText(TOOLTIP_CREATE_STYLE);
        this.createStyle.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PredefinedStylesPropertySection.this.createOrSelectStyle(PredefinedStylesPropertySection.this.styleName.getText());
            }
        });
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory fac = this.getWidgetFactory();
        this.comp = fac.createComposite(parent, 0);
        this.comp.setLayout((Layout)new GridLayout(1, false));
        this.createStyleControl(fac, this.comp);
        this.createNewStyleControl(fac, this.comp);
        this.createGradientTypeControl(fac, this.comp);
        this.createGradientColorControl(fac, this.comp);
        this.propSection.createControls(this.comp, aTabbedPropertySheetPage);
        this.propSection.refresh();
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.propSection.setInput(part, selection);
    }

    private void createOrSelectStyle(final String styleId) {
        final IGaService gaService = Graphiti.getGaService();
        if (styleId != null) {
            this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

                protected void doExecute() {
                    Style style = StyleUtil.findStyle(PredefinedStylesPropertySection.this.getDiagram(), styleId);
                    if (style == null) {
                        style = gaService.createStyle((StyleContainer)PredefinedStylesPropertySection.this.getDiagram(), styleId);
                        Style shapeStyle = StyleUtil.getStyle(PredefinedStylesPropertySection.this.getDiagram(), "Shape");
                        style.setLineWidth(shapeStyle.getLineWidth());
                        style.setForeground(shapeStyle.getForeground());
                        style.setBackground(shapeStyle.getBackground());
                        style.setFont(shapeStyle.getFont());
                        style.setFilled(Boolean.valueOf(true));
                        style.setLineVisible(Boolean.valueOf(true));
                        PredefinedStylesPropertySection.this.gradientType.select(0);
                    }
                    PredefinedStylesPropertySection.this.propSection.setStyle(style);
                    PredefinedStylesPropertySection.this.setColorOfGradientColorLabel(PredefinedStylesPropertySection.this.getGradientColor(style));
                }
            });
            this.refresh();
            int i = this.getSelectionIndex(styleId);
            this.stylesCombo.select(i);
        }
    }

    private static GradientColoredAreas getAreas(org.eclipse.graphiti.mm.algorithms.styles.Color start, org.eclipse.graphiti.mm.algorithms.styles.Color end) {
        GradientColoredAreas gradientColoredAreas = StylesFactory.eINSTANCE.createGradientColoredAreas();
        gradientColoredAreas.setStyleAdaption(Integer.valueOf(0));
        EList gcas = gradientColoredAreas.getGradientColor();
        PredefinedStylesPropertySection.addGradientColoredArea((EList<GradientColoredArea>)gcas, start, 0, LocationType.LOCATION_TYPE_ABSOLUTE_START, end, 0, LocationType.LOCATION_TYPE_ABSOLUTE_END);
        return gradientColoredAreas;
    }

    protected static void addGradientColoredArea(EList<GradientColoredArea> gcas, org.eclipse.graphiti.mm.algorithms.styles.Color colorStart, int locationValueStart, LocationType locationTypeStart, org.eclipse.graphiti.mm.algorithms.styles.Color colorEnd, int locationValueEnd, LocationType locationTypeEnd) {
        GradientColoredArea gca = StylesFactory.eINSTANCE.createGradientColoredArea();
        gcas.add((Object)gca);
        gca.setStart(StylesFactory.eINSTANCE.createGradientColoredLocation());
        gca.getStart().setColor(colorStart);
        gca.getStart().setLocationType(locationTypeStart);
        gca.getStart().setLocationValue(Integer.valueOf(locationValueStart));
        gca.setEnd(StylesFactory.eINSTANCE.createGradientColoredLocation());
        gca.getEnd().setColor(colorEnd);
        gca.getEnd().setLocationType(locationTypeEnd);
        gca.getEnd().setLocationValue(Integer.valueOf(locationValueEnd));
    }

    private org.eclipse.graphiti.mm.algorithms.styles.Color createNewColor(org.eclipse.graphiti.mm.algorithms.styles.Color color) {
        org.eclipse.graphiti.mm.algorithms.styles.Color newColor = StylesFactory.eINSTANCE.createColor();
        newColor.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Red(), (Object)color.getRed());
        newColor.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Green(), (Object)color.getGreen());
        newColor.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Blue(), (Object)color.getBlue());
        return newColor;
    }

    public void refresh() {
        if (!this.isDisposed()) {
            super.refresh();
            this.propSection.refresh();
            String selectedItem = this.stylesCombo.getSelectionIndex() >= 0 ? this.stylesCombo.getItem(this.stylesCombo.getSelectionIndex()) : "";
            this.stylesCombo.setItems(this.getStyleIds());
            int i = this.getSelectionIndex(selectedItem);
            if (this.stylesCombo.getItems().length > 0 && i > this.stylesCombo.getItems().length - 1) {
                this.stylesCombo.select(0);
                this.createOrSelectStyle(this.stylesCombo.getItems()[0]);
            } else {
                this.stylesCombo.select(i);
            }
            Style style = StyleUtil.findStyle(this.getDiagram(), selectedItem);
            if (style != null && style.getRenderingStyle() != null) {
                Integer currentGradientType = style.getRenderingStyle().getAdaptedGradientColoredAreas().getGradientType();
                this.gradientType.select(IGradientType.VERTICAL.equals(currentGradientType) ? 1 : 2);
            } else {
                this.gradientType.select(0);
            }
            ScrolledComposite tabbedPropertyComposite = this.findTabbedPropertyComposite(this.comp);
            if (tabbedPropertyComposite != null) {
                int cols = tabbedPropertyComposite.getSize().x / 200 * 2;
                cols = cols < 2 ? 2 : cols;
                this.comp.setLayout((Layout)new GridLayout(cols > 4 ? 4 : cols, false));
                this.comp.layout();
            }
        }
    }

    private int getSelectionIndex(String selectedItem) {
        int i = 0;
        String[] stringArray = this.stylesCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(selectedItem)) break;
            ++i;
            ++n2;
        }
        return i;
    }

    private String[] getStyleIds() {
        String[] styles = new String[this.getDiagram().getStyles().size()];
        int i = 0;
        for (Style style : this.getDiagram().getStyles()) {
            styles[i] = style.getId();
            ++i;
        }
        return styles;
    }

    private String getSelectedStyleId() {
        String item = this.stylesCombo.getItem(this.stylesCombo.getSelectionIndex());
        return item;
    }

    private String getSelectedGradientType() {
        String item = this.gradientType.getItem(this.gradientType.getSelectionIndex());
        return item;
    }

    private void createRenderingStyle(Style style) {
        IGaService gaService = Graphiti.getGaService();
        AdaptedGradientColoredAreas agca = StylesFactory.eINSTANCE.createAdaptedGradientColoredAreas();
        agca.setDefinedStyleId(String.valueOf(style.getId()) + "_Gradient");
        agca.setGradientType(IGradientType.VERTICAL);
        org.eclipse.graphiti.mm.algorithms.styles.Color gradientColor = this.getGradientColor(style);
        agca.getAdaptedGradientColoredAreas().add(0, (Object)PredefinedStylesPropertySection.getAreas(this.createNewColor(style.getBackground()), gradientColor));
        gaService.setRenderingStyle((AbstractStyle)style, agca);
        this.setColorOfGradientColorLabel(gradientColor);
    }

    protected void setColorOfGradientColorLabel(org.eclipse.graphiti.mm.algorithms.styles.Color back) {
        if (back != null) {
            this.gradientColorLabel.setBackground(new Color((Device)Display.getDefault(), back.getRed(), back.getGreen(), back.getBlue()));
            this.gradientColorLabel.setForeground(new Color((Device)Display.getDefault(), 255 - back.getRed(), 255 - back.getGreen(), 255 - back.getBlue()));
        } else {
            this.gradientColorLabel.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
            this.gradientColorLabel.setForeground(new Color((Device)Display.getDefault(), 0, 0, 0));
        }
    }

    private void updateGradientColor(boolean gradientColor) {
        AdaptedGradientColoredAreas adaptedGradientColoredAreas;
        Style style = StyleUtil.findStyle(this.getDiagram(), this.getSelectedStyleId());
        if (style.getRenderingStyle() != null && !(adaptedGradientColoredAreas = style.getRenderingStyle().getAdaptedGradientColoredAreas()).getAdaptedGradientColoredAreas().isEmpty()) {
            GradientColoredAreas oldGradientColoredAreas = (GradientColoredAreas)adaptedGradientColoredAreas.getAdaptedGradientColoredAreas().get(0);
            GradientColoredLocation oldGradientColorEnd = ((GradientColoredArea)oldGradientColoredAreas.getGradientColor().get(0)).getEnd();
            GradientColoredLocation oldGradientColorStart = ((GradientColoredArea)oldGradientColoredAreas.getGradientColor().get(0)).getStart();
            oldGradientColorStart.setColor(this.createNewColor(style.getBackground()));
            org.eclipse.graphiti.mm.algorithms.styles.Color newColor = null;
            if (gradientColor) {
                newColor = this.createNewColor(FMCUtil.editColor(oldGradientColorEnd.getColor(), this.getDiagram()));
            }
            oldGradientColorEnd.setColor(gradientColor ? newColor : oldGradientColorEnd.getColor());
            this.setColorOfGradientColorLabel(newColor);
        }
    }

    private class StyleColorsAndFontsPropertySection
    extends FMCColorsAndFontsPropertySection {
        private Style style;

        public StyleColorsAndFontsPropertySection() {
            this.gridData = new GridData(8);
            this.gridData.horizontalSpan = 4;
        }

        public void setStyle(Style style) {
            this.style = style;
        }

        @Override
        protected void createRecursiveFontControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        }

        @Override
        protected void createStyleControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        }

        @Override
        protected void createFontColorControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        }

        @Override
        protected void createTextAngleControl(TabbedPropertySheetWidgetFactory fac, Composite comp) {
        }

        @Override
        protected void updateTransparency(PictogramElement el, final double transparencyValue) {
            if (this.style != null) {
                Double trans = this.style.getTransparency() == null ? 0.0 : this.style.getTransparency();
                BigDecimal decimal = new BigDecimal(trans, new MathContext(2));
                BigDecimal transparencyValueDecimal = new BigDecimal(transparencyValue, new MathContext(2));
                if (!transparencyValueDecimal.divide(HUNDRET).equals(decimal)) {
                    this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

                        protected void doExecute() {
                            StyleColorsAndFontsPropertySection.this.style.setTransparency(Double.valueOf(transparencyValue / 100.0));
                        }
                    });
                }
            }
        }

        @Override
        protected void rotateText(PictogramElement el, final int angle) {
            if (this.style != null) {
                this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

                    protected void doExecute() {
                        StyleColorsAndFontsPropertySection.this.style.setAngle(Integer.valueOf(angle));
                    }
                });
            }
        }

        @Override
        protected void updateColors(PictogramElement el, final org.eclipse.graphiti.mm.algorithms.styles.Color c, final boolean isForeground) {
            if (this.style != null) {
                this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

                    protected void doExecute() {
                        if (!isForeground) {
                            StyleColorsAndFontsPropertySection.this.style.setBackground(c);
                            StyleColorsAndFontsPropertySection.this.setColorOfBGLabel(c);
                            PredefinedStylesPropertySection.this.updateGradientColor(false);
                        } else {
                            StyleColorsAndFontsPropertySection.this.style.setForeground(c);
                            StyleColorsAndFontsPropertySection.this.setColorOfFGLabel(c);
                        }
                    }
                });
            }
        }

        @Override
        protected void updateFonts() {
            if (this.style != null) {
                this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

                    protected void doExecute() {
                        StyleColorsAndFontsPropertySection.this.style.setFont(Graphiti.getGaService().manageFont(PredefinedStylesPropertySection.this.getDiagram(), StyleColorsAndFontsPropertySection.this.fontsCombo.getItem(StyleColorsAndFontsPropertySection.this.fontsCombo.getSelectionIndex()), Integer.parseInt(StyleColorsAndFontsPropertySection.this.sizesCombo.getItem(StyleColorsAndFontsPropertySection.this.sizesCombo.getSelectionIndex())), StyleColorsAndFontsPropertySection.this.isItalic.getSelection(), StyleColorsAndFontsPropertySection.this.isBold.getSelection()));
                    }
                });
            }
        }

        @Override
        public void refresh() {
            if (!this.isDisposed() && this.style != null) {
                this.fontsCombo.setText(this.style.getFont().getName());
                this.sizesCombo.setText(String.valueOf(this.style.getFont().getSize()));
                this.isBold.setSelection(this.style.getFont().isBold());
                this.isItalic.setSelection(this.style.getFont().isItalic());
                if (this.style.getTransparency() == null) {
                    this.transparency.setSelection(0);
                } else {
                    this.transparency.setSelection((int)(this.style.getTransparency() * 100.0));
                }
                this.setColorOfBGLabel(this.style.getBackground());
                this.setColorOfFGLabel(this.style.getForeground());
                this.refreshGridLayout();
            }
        }
    }
}

