/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.internal.datatypes.impl.LocationImpl;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaCreateService;
import org.eclipse.graphiti.services.ILinkService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class FMCUtil {
    public static final int ANCHOR_LEFT = 1;
    public static final int ANCHOR_RIGHT = 2;
    public static final int ANCHOR_TOP = 3;
    public static final int ANCHOR_BOTTOM = 4;
    public static Map<String, String> extensionToTypeMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 3995819479426775731L;
        {
            this.put("actionsdiag", "actions");
            this.put("activitydiag", "activity");
            this.put("concernsdiag", "concerns");
            this.put("mappingdiag", "mapping");
            this.put("bpmndiag", "bpmn2");
        }
    };
    public static Map<String, String> extensionToModelExtensionMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 7135824024665889657L;
        {
            this.put("actionsdiag", "actions");
            this.put("activitydiag", "actions");
            this.put("concernsdiag", "concerns");
            this.put("mappingdiag", "service");
            this.put("bpmndiag", "bpmn2");
        }
    };

    public static int getMinimum(int x, int y) {
        return x < y ? x : y;
    }

    public static boolean isMultiShape(PictogramElement shape) {
        if (shape instanceof ContainerShape) {
            return !((ContainerShape)shape).getChildren().isEmpty();
        }
        return false;
    }

    public static Set<BoxRelativeAnchor> removeObsoleteAnchors(Shape shape) {
        HashSet<BoxRelativeAnchor> stillUsedAnchors = new HashSet<BoxRelativeAnchor>();
        for (Anchor anchor : new HashSet(shape.getAnchors())) {
            if (!(anchor instanceof BoxRelativeAnchor)) continue;
            if (anchor.getIncomingConnections().isEmpty() && anchor.getOutgoingConnections().isEmpty()) {
                shape.getAnchors().remove((Object)anchor);
                continue;
            }
            stillUsedAnchors.add((BoxRelativeAnchor)anchor);
        }
        return stillUsedAnchors;
    }

    public static List<Connection> getAllConnections(Shape shape) {
        ArrayList<Connection> returnValue = new ArrayList<Connection>();
        for (Anchor anchor : new HashSet(shape.getAnchors())) {
            if (!anchor.getIncomingConnections().isEmpty()) {
                returnValue.addAll((Collection<Connection>)anchor.getIncomingConnections());
            }
            if (anchor.getOutgoingConnections().isEmpty()) continue;
            returnValue.addAll((Collection<Connection>)anchor.getOutgoingConnections());
        }
        return returnValue;
    }

    public static Color editColor(Color color) {
        if (color != null && color.eContainer() instanceof Diagram) {
            Shell shell = FMCUtil.getShell();
            ColorDialog colorDia = new ColorDialog(shell);
            colorDia.setText("Choose Color");
            colorDia.setRGB(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
            RGB retRgb = colorDia.open();
            if (retRgb == null) {
                return null;
            }
            Diagram diagram = (Diagram)color.eContainer();
            Color newCol = Graphiti.getGaService().manageColor(diagram, retRgb.red, retRgb.green, retRgb.blue);
            return newCol;
        }
        return null;
    }

    public static Diagram getDiagram(PictogramElement picto) {
        EObject container = picto.eContainer();
        if (container instanceof Diagram) {
            return (Diagram)container;
        }
        if (container instanceof PictogramElement) {
            return FMCUtil.getDiagram((PictogramElement)container);
        }
        return null;
    }

    private static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static FMCType getIndependentObject(PictogramElement el) {
        if (el != null) {
            for (Property prop : el.getProperties()) {
                if (!prop.getKey().equals("independentObject")) continue;
                return FMCType.valueOf(prop.getValue());
            }
        }
        return null;
    }

    public static EObject getBO(PictogramElement pe) {
        if (pe == null) {
            return null;
        }
        PictogramLink link = pe.getLink();
        if (link == null) {
            return null;
        }
        if (!pe.getLink().getBusinessObjects().isEmpty()) {
            return (EObject)pe.getLink().getBusinessObjects().get(0);
        }
        return null;
    }

    public static Object getModelObject(PictogramElement pe) {
        FMCType independentObject = FMCUtil.getIndependentObject(pe);
        if (independentObject == null) {
            return FMCUtil.getBO(pe);
        }
        return FMCUtil.getIndependentObject(pe);
    }

    public static ILocation getRelativePosition(PictogramElement element, int x, int y) {
        return FMCUtil.getRelativePosition(element, (ILocation)new LocationImpl(x, y));
    }

    public static Collection<PictogramElement> getPictogramElements(Diagram diagram, EObject bo) {
        ArrayList<PictogramElement> elements = new ArrayList<PictogramElement>();
        EList pictogramLinks = diagram.getPictogramLinks();
        block0: for (PictogramLink pictogramLink : pictogramLinks) {
            EList businessObjects = pictogramLink.getBusinessObjects();
            for (EObject obj : businessObjects) {
                PictogramElement pe;
                if (!EcoreUtil.equals((EObject)bo, (EObject)obj) || (pe = pictogramLink.getPictogramElement()) == null) continue;
                elements.add(pe);
                continue block0;
            }
        }
        return elements;
    }

    public static ILocation getRelativePosition(PictogramElement element, ILocation location) {
        location.setX(location.getX() - element.getGraphicsAlgorithm().getX());
        location.setY(location.getY() - element.getGraphicsAlgorithm().getY());
        if (element.eContainer() instanceof ContainerShape && !(element.eContainer() instanceof Diagram)) {
            return FMCUtil.getRelativePosition((PictogramElement)((ContainerShape)element.eContainer()), location);
        }
        return location;
    }

    public static ILocation getAbsolutePosition(PictogramElement element, ILocation location) {
        location.setX(location.getX() + element.getGraphicsAlgorithm().getX());
        location.setY(location.getY() + element.getGraphicsAlgorithm().getY());
        if (element.eContainer() instanceof ContainerShape && !(element.eContainer() instanceof Diagram)) {
            return FMCUtil.getAbsolutePosition((PictogramElement)((ContainerShape)element.eContainer()), location);
        }
        return location;
    }

    public static int[] getMinMaxCoords(PictogramElement[] els) {
        int[] ret = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        GraphicsAlgorithm ga = null;
        PictogramElement[] pictogramElementArray = els;
        int n = els.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement el = pictogramElementArray[n2];
            ga = el.getGraphicsAlgorithm();
            if (ga.getX() < ret[0]) {
                ret[0] = ga.getX();
            }
            if (ga.getY() < ret[1]) {
                ret[1] = ga.getY();
            }
            if (ga.getX() + ga.getWidth() > ret[2]) {
                ret[2] = ga.getX() + ga.getWidth();
            }
            if (ga.getY() + ga.getHeight() > ret[3]) {
                ret[3] = ga.getY() + ga.getHeight();
            }
            ++n2;
        }
        return ret;
    }

    public static ResourceSet getResourceSet() {
        DiagramEditor editor = FMCUtil.getActiveEditor();
        if (editor != null) {
            return editor.getDiagramBehavior().getResourceSet();
        }
        return null;
    }

    public static Color editColor(Color color, Diagram diagram) {
        RGB retRgb;
        Shell shell = FMCUtil.getShell();
        ColorDialog colorDia = new ColorDialog(shell);
        colorDia.setText("Choose Color");
        if (color != null) {
            colorDia.setRGB(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        }
        if ((retRgb = colorDia.open()) == null) {
            return color;
        }
        Color newCol = Graphiti.getGaService().manageColor(diagram, retRgb.red, retRgb.green, retRgb.blue);
        return newCol;
    }

    public static int extractId(String str) {
        int hashId = str.lastIndexOf("(");
        int bracketId = str.lastIndexOf(")");
        return Integer.parseInt(str.substring(hashId + 1, bracketId));
    }

    public static DiagramEditor getActiveEditor() {
        return FMCUtil.getActiveEditorSavely();
    }

    public static DiagramEditor getActiveEditorSavely() {
        if (PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() == null) {
            return null;
        }
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return editor instanceof DiagramEditor ? (DiagramEditor)editor : null;
    }

    public static IResource getActiveResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(FMCUtil.getActiveEditor().getDiagramTypeProvider().getDiagram().eResource().getURI().toPlatformString(true));
    }

    public static String convertHungarian(String in) {
        StringBuffer buffer = new StringBuffer(in);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int i = 0;
        while (i < buffer.length()) {
            if (i == 0) {
                buffer.replace(0, 1, Character.toString(Character.toUpperCase(buffer.charAt(0))));
            } else if (Character.isUpperCase(buffer.charAt(i))) {
                indexes.add(i);
            }
            ++i;
        }
        i = 0;
        while (i < indexes.size()) {
            buffer.insert((Integer)indexes.get(i) + i, ' ');
            ++i;
        }
        return buffer.toString().trim();
    }

    public static Map<EStructuralFeature, GraphicsAlgorithm> getLinkedFeaturesMap(PictogramElement el, EObject obj) {
        ILinkService ls = Graphiti.getLinkService();
        HashMap<EStructuralFeature, GraphicsAlgorithm> out = new HashMap<EStructuralFeature, GraphicsAlgorithm>();
        if (el instanceof ContainerShape) {
            EList children = ((ContainerShape)el).getChildren();
            for (Shape shape : children) {
                Property prop = ls.getLinkProperty((PictogramElement)shape);
                if (prop == null) continue;
                out.put(obj.eClass().getEStructuralFeature(prop.getValue()), shape.getGraphicsAlgorithm());
            }
            return out;
        }
        return null;
    }

    public static PictogramElement getPictogramElement(Diagram diagram, EObject bo) {
        EList pictogramLinks = diagram.getPictogramLinks();
        for (PictogramLink pictogramLink : pictogramLinks) {
            EList businessObjects = pictogramLink.getBusinessObjects();
            for (EObject obj : businessObjects) {
                PictogramElement pe;
                if (!EcoreUtil.equals((EObject)bo, (EObject)obj) || (pe = pictogramLink.getPictogramElement()) == null) continue;
                return pe;
            }
        }
        return null;
    }

    public static ArrayList<Point> getActionPolygonPoints(int w, int h) {
        IGaCreateService gaCreate = Graphiti.getGaCreateService();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(gaCreate.createPoint(0, 0));
        points.add(gaCreate.createPoint((int)Math.round(0.75 * (double)w), 0));
        points.add(gaCreate.createPoint(w, (int)Math.round(0.5 * (double)h)));
        points.add(gaCreate.createPoint((int)Math.round(0.75 * (double)w), h));
        points.add(gaCreate.createPoint(0, h));
        points.add(gaCreate.createPoint((int)Math.round(0.25 * (double)w), (int)Math.round(0.5 * (double)h)));
        return points;
    }

    public static String getElementType(PictogramElement pe) {
        EObject bo = FMCUtil.getBO(pe);
        return bo.eClass().getName();
    }

    public static boolean isDrillUpShape(PictogramElement pe) {
        EList properties = pe.getProperties();
        for (Property p : properties) {
            if (!p.getKey().equals("type") || !p.getValue().equals("DrillUpShape")) continue;
            return true;
        }
        return false;
    }

    public static int getAppropriateAnchor(int x1, int y1, int x2, int y2) {
        int xdiff = x2 - x1;
        int ydiff = y2 - y1;
        if (Math.abs(ydiff) > Math.abs(xdiff)) {
            if (ydiff < 0) {
                return 4;
            }
            return 3;
        }
        if (xdiff < 0) {
            return 2;
        }
        return 1;
    }

    public static Anchor getClosestAnchor(List<Anchor> anchors, ILocation mouseLocation) {
        IPeService pe = Graphiti.getPeService();
        int minDiff = Integer.MAX_VALUE;
        Anchor minAnchor = null;
        if (anchors != null && !anchors.isEmpty()) {
            int currDiff = 0;
            for (Anchor anchor : anchors) {
                ILocation anchorLocation = pe.getLocationRelativeToDiagram(anchor);
                currDiff = Math.abs(anchorLocation.getX() - mouseLocation.getX()) + Math.abs(anchorLocation.getY() - mouseLocation.getY());
                if (currDiff >= minDiff) continue;
                minDiff = currDiff;
                minAnchor = anchor;
            }
        }
        return minAnchor;
    }

    public static Anchor getAnchorForPictogramElement(PictogramElement element) {
        if (element instanceof Anchor) {
            return (Anchor)element;
        }
        if (element instanceof AnchorContainer) {
            EList existingAnchors = ((AnchorContainer)element).getAnchors();
            for (Anchor anchor : existingAnchors) {
                if (!(anchor instanceof ChopboxAnchor)) continue;
                return anchor;
            }
        }
        return null;
    }

    public static boolean isOfType(EClass clazz, EClass clazz2) {
        return clazz.equals(clazz2) || clazz.getEAllSuperTypes().contains((Object)clazz2);
    }

    public static List<Shape> getAllChildren(ContainerShape container) {
        ArrayList<Shape> ret = new ArrayList<Shape>();
        for (Shape sh : container.getChildren()) {
            if (ret.contains(sh)) continue;
            ret.add(sh);
            if (!(sh instanceof ContainerShape)) continue;
            ret.addAll(FMCUtil.getAllChildren((ContainerShape)sh));
        }
        return ret;
    }

    public static URI createRelativeURI(String fileName) {
        return URI.createFileURI((String)fileName.replaceAll("\\\\", "/").replace(Platform.getLocation().toString(), ""));
    }

    public static <A, B> Map<B, A> conjugateMap(Map<A, B> map) throws IllegalArgumentException {
        HashMap<B, A> newMap = new HashMap<B, A>();
        for (Map.Entry<A, B> entry : map.entrySet()) {
            if (newMap.put(entry.getValue(), entry.getKey()) == null) continue;
            throw new IllegalArgumentException(String.format("The value \"%s\" is assigned to multiple keys.", entry.getValue()));
        }
        return newMap;
    }

    public static String substringStereotype(String value) {
        int index = value.indexOf(">>\n");
        if (index > 0) {
            return value.substring(index + 3);
        }
        return value;
    }
}

