/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.meta.util;

import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.fmc.mm.Comment;
import org.eclipse.fmc.mm.FMCConnection;
import org.eclipse.fmc.mm.FMCModel;
import org.eclipse.fmc.mm.FMCNode;
import org.eclipse.fmc.mm.FmcFactory;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.osgi.framework.Bundle;

public class FMCMetaUtil {
    private FMCMetaUtil() {
    }

    public static void addModelObject(EObject obj, Diagram d, IFeatureProvider fp) {
        URI uri = d.eResource().getURI();
        uri = uri.trimFragment();
        uri = uri.trimFileExtension();
        uri = uri.appendFileExtension("block");
        ResourceSet rSet = d.eResource().getResourceSet();
        FMCModel root = null;
        Resource file = rSet.getResource(uri, false);
        if (file == null) {
            file = rSet.createResource(uri);
            root = FmcFactory.eINSTANCE.createFMCModel();
            file.getContents().add((Object)root);
            try {
                file.save(Collections.EMPTY_MAP);
            }
            catch (Exception e) {
                Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.fmc.blockdiagram.editor.meta")).log((IStatus)new Status(4, "org.eclipse.fmc.blockdiagram.editor.meta", "Could not save the model file", (Throwable)e));
            }
            fp.link((PictogramElement)d, (Object[])new EObject[]{root});
        } else {
            file = rSet.getResource(uri, true);
            root = (FMCModel)file.getContents().get(0);
        }
        if (obj instanceof FMCNode) {
            FMCNode node = (FMCNode)obj;
            root.getNodes().add((Object)node);
        } else if (obj instanceof FMCConnection) {
            root.getConnections().add((Object)((FMCConnection)obj));
        } else if (obj instanceof Comment) {
            root.getComments().add((Object)((Comment)obj));
        }
    }

    public static FMCModel getFMCModel(Diagram d) {
        URI uri = d.eResource().getURI();
        uri = uri.trimFragment();
        uri = uri.trimFileExtension();
        uri = uri.appendFileExtension("block");
        ResourceSet rSet = d.eResource().getResourceSet();
        FMCModel root = null;
        Resource file = rSet.getResource(uri, false);
        file = rSet.getResource(uri, true);
        root = (FMCModel)file.getContents().get(0);
        return root;
    }
}

