/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.bundleresources;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.JarResourceSet;
import org.eclipse.gemini.web.tomcat.internal.bundleresources.BundleJarResource;

final class BundleJarResourceSet
extends JarResourceSet {
    BundleJarResourceSet(WebResourceRoot root, String webAppMount, String base, String internalPath) throws IllegalArgumentException {
        super(root, webAppMount, base, internalPath);
    }

    protected WebResource createArchiveResource(JarEntry jarEntry, String webAppPath, Manifest manifest) {
        return new BundleJarResource(this.getRoot(), webAppPath, this.getBase(), this.getBaseUrlString(), jarEntry, this.getInternalPath(), manifest);
    }

    protected void initInternal() throws LifecycleException {
        URLConnection conn = null;
        URL baseUrl = null;
        try {
            baseUrl = new URL(this.getBase());
            conn = baseUrl.openConnection();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            Throwable e = null;
            Object var4_7 = null;
            try (JarInputStream jarIs = new JarInputStream(conn.getInputStream());){
                JarEntry entry = jarIs.getNextJarEntry();
                while (entry != null) {
                    this.getJarFileEntries().put(entry.getName(), entry);
                    entry = jarIs.getNextJarEntry();
                }
                this.setManifest(jarIs.getManifest());
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        this.setBaseUrl(baseUrl);
    }
}

