/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.gemini.web.core.WebContainerProperties;
import org.eclipse.gemini.web.core.spi.ServletContainer;
import org.eclipse.gemini.web.tomcat.internal.TomcatConfigLocator;
import org.eclipse.gemini.web.tomcat.internal.TomcatServletContainer;
import org.eclipse.gemini.web.tomcat.internal.TomcatServletContainerFactory;
import org.eclipse.gemini.web.tomcat.internal.TomcatWebContainerProperties;
import org.eclipse.gemini.web.tomcat.internal.bundleresources.BundleURLStreamHandlerService;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;

public class Activator
implements BundleActivator {
    private static final String WAR_PROTOCOL = "war";
    private static final String EXPRESSION_FACTORY = "javax.el.ExpressionFactory";
    private static final String EXPRESSION_FACTORY_IMPL = "org.apache.el.ExpressionFactoryImpl";
    private final Object monitor = new Object();
    private final ServiceRegistrationTracker tracker = new ServiceRegistrationTracker();
    private TomcatServletContainer container;
    private String oldExpressionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        this.oldExpressionFactory = System.setProperty(EXPRESSION_FACTORY, EXPRESSION_FACTORY_IMPL);
        this.registerURLStreamHandler(context);
        this.registerConnectorDescriptors(context);
        TomcatServletContainer container = this.createContainer(context);
        container.start();
        ServiceRegistration sr = context.registerService(ServletContainer.class, (Object)container, null);
        this.tracker.track(sr);
        Object object = this.monitor;
        synchronized (object) {
            this.container = container;
        }
    }

    private void registerConnectorDescriptors(BundleContext context) {
        TomcatWebContainerProperties tomcatWebContainerProperties = new TomcatWebContainerProperties();
        ServiceRegistration registration = context.registerService(WebContainerProperties.class, (Object)tomcatWebContainerProperties, null);
        this.tracker.track(registration);
    }

    private void registerURLStreamHandler(BundleContext context) {
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        ((Dictionary)properties).put("url.handler.protocol", new String[]{WAR_PROTOCOL});
        BundleURLStreamHandlerService handler = new BundleURLStreamHandlerService();
        ServiceRegistration reg = context.registerService(URLStreamHandlerService.class, (Object)handler, properties);
        this.tracker.track(reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        TomcatServletContainer container;
        this.tracker.unregisterAll();
        Object object = this.monitor;
        synchronized (object) {
            container = this.container;
            this.container = null;
        }
        if (container != null) {
            container.stop();
        }
        if (this.oldExpressionFactory != null) {
            System.setProperty(EXPRESSION_FACTORY, this.oldExpressionFactory);
        }
    }

    private TomcatServletContainer createContainer(BundleContext context) throws BundleException {
        TomcatServletContainer tomcatServletContainer;
        block7: {
            TomcatServletContainerFactory factory = new TomcatServletContainerFactory();
            InputStream configFile = null;
            try {
                configFile = this.resolveConfigFile(context);
                tomcatServletContainer = factory.createContainer(configFile, context);
                if (configFile == null) break block7;
            }
            catch (Throwable throwable) {
                if (configFile != null) {
                    try {
                        configFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                configFile.close();
            }
            catch (IOException iOException) {}
        }
        return tomcatServletContainer;
    }

    private InputStream resolveConfigFile(BundleContext context) throws BundleException {
        return TomcatConfigLocator.resolveConfigFile(context);
    }
}

