/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.res.StringManager;

final class StandardWrapperValve
extends ValveBase {
    private volatile long processingTime;
    private volatile long maxTime;
    private volatile long minTime = Long.MAX_VALUE;
    private final AtomicInteger requestCount = new AtomicInteger(0);
    private final AtomicInteger errorCount = new AtomicInteger(0);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");

    public StandardWrapperValve() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        long t1;
        block44: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block43: {
                ApplicationFilterChain filterChain;
                block42: {
                    boolean unavailable = false;
                    throwable = null;
                    t1 = System.currentTimeMillis();
                    this.requestCount.incrementAndGet();
                    wrapper = (StandardWrapper)this.getContainer();
                    servlet = null;
                    Context context = (Context)wrapper.getParent();
                    if (!context.getState().isAvailable()) {
                        response.sendError(503, sm.getString("standardContext.isUnavailable"));
                        unavailable = true;
                    }
                    if (!unavailable && wrapper.isUnavailable()) {
                        this.container.getLogger().info((Object)sm.getString("standardWrapper.isUnavailable", new Object[]{wrapper.getName()}));
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            response.setDateHeader("Retry-After", available);
                            response.sendError(503, sm.getString("standardWrapper.isUnavailable", new Object[]{wrapper.getName()}));
                        } else if (available == Long.MAX_VALUE) {
                            response.sendError(404, sm.getString("standardWrapper.notFound", new Object[]{wrapper.getName()}));
                        }
                        unavailable = true;
                    }
                    try {
                        if (!unavailable) {
                            servlet = wrapper.allocate();
                        }
                    }
                    catch (UnavailableException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", new Object[]{wrapper.getName()}), (Throwable)e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            response.setDateHeader("Retry-After", available);
                            response.sendError(503, sm.getString("standardWrapper.isUnavailable", new Object[]{wrapper.getName()}));
                        } else if (available == Long.MAX_VALUE) {
                            response.sendError(404, sm.getString("standardWrapper.notFound", new Object[]{wrapper.getName()}));
                        }
                    }
                    catch (ServletException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", new Object[]{wrapper.getName()}), StandardWrapper.getRootCause(e));
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        ExceptionUtils.handleThrowable((Throwable)e);
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", new Object[]{wrapper.getName()}), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    MessageBytes requestPathMB = request.getRequestPathMB();
                    DispatcherType dispatcherType = DispatcherType.REQUEST;
                    if (request.getDispatcherType() == DispatcherType.ASYNC) {
                        dispatcherType = DispatcherType.ASYNC;
                    }
                    request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", dispatcherType);
                    request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", requestPathMB);
                    filterChain = ApplicationFilterFactory.createFilterChain((ServletRequest)request, wrapper, servlet);
                    try {
                        if (servlet == null || filterChain == null) break block42;
                        if (context.getSwallowOutput()) {
                            try {
                                SystemLogHandler.startCapture();
                                if (request.isAsyncDispatching()) {
                                    request.getAsyncContextInternal().doInternalDispatch();
                                } else {
                                    filterChain.doFilter((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
                                }
                                break block42;
                            }
                            finally {
                                String log = SystemLogHandler.stopCapture();
                                if (log != null && log.length() > 0) {
                                    context.getLogger().info((Object)log);
                                }
                            }
                        }
                        if (request.isAsyncDispatching()) {
                            request.getAsyncContextInternal().doInternalDispatch();
                        } else {
                            filterChain.doFilter((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
                        }
                    }
                    catch (ClientAbortException e) {
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (IOException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", new Object[]{wrapper.getName(), context.getName()}), (Throwable)e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (UnavailableException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", new Object[]{wrapper.getName(), context.getName()}), (Throwable)e);
                        wrapper.unavailable(e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            response.setDateHeader("Retry-After", available);
                            response.sendError(503, sm.getString("standardWrapper.isUnavailable", new Object[]{wrapper.getName()}));
                        } else if (available == Long.MAX_VALUE) {
                            response.sendError(404, sm.getString("standardWrapper.notFound", new Object[]{wrapper.getName()}));
                        }
                    }
                    catch (ServletException e) {
                        Throwable rootCause = StandardWrapper.getRootCause(e);
                        if (!(rootCause instanceof ClientAbortException)) {
                            this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceExceptionRoot", new Object[]{wrapper.getName(), context.getName(), e.getMessage()}), rootCause);
                        }
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        ExceptionUtils.handleThrowable((Throwable)e);
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", new Object[]{wrapper.getName(), context.getName()}), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                }
                if (filterChain != null) {
                    filterChain.release();
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    ExceptionUtils.handleThrowable((Throwable)e);
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.deallocateException", new Object[]{wrapper.getName()}), e);
                    if (throwable != null) break block43;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable((Throwable)e);
                this.container.getLogger().error((Object)sm.getString("standardWrapper.unloadException", new Object[]{wrapper.getName()}), e);
                if (throwable != null) break block44;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        long t2 = System.currentTimeMillis();
        long time = t2 - t1;
        this.processingTime += time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime) {
            this.minTime = time;
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        request.setAttribute("javax.servlet.error.exception", exception);
        response.setStatus(500);
        response.setError();
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public int getRequestCount() {
        return this.requestCount.get();
    }

    public int getErrorCount() {
        return this.errorCount.get();
    }

    public void incrementErrorCount() {
        this.errorCount.incrementAndGet();
    }

    @Override
    protected void initInternal() throws LifecycleException {
    }
}

