/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.adapter.value;

import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.gemoc.dsl.debug.ide.DSLEclipseDebugIntegration;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.AbstractDSLValue;

public class DSLArrayValue
extends AbstractDSLValue
implements IIndexedValue {
    private static final int BUFFER_SIZE = 512;
    private final IVariable[] variables;

    public DSLArrayValue(DSLEclipseDebugIntegration factory, String referenceTypeName, Object[] array) {
        super(factory, referenceTypeName, array);
        this.variables = new IVariable[array.length];
        int i = 0;
        while (i < array.length) {
            this.variables[i] = factory.getVariable(this.getActualTypeName(array), "[" + i + "]", array[i]);
            ++i;
        }
    }

    protected String getActualTypeName(Object[] array) {
        return array.getClass().getCanonicalName();
    }

    public String getValueString() throws DebugException {
        StringBuilder builder = new StringBuilder(512);
        builder.append('[');
        if (this.variables.length > 0) {
            IVariable[] iVariableArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable variable = iVariableArray[n2];
                builder = builder.append(variable.getValue().getValueString());
                builder = builder.append(", ");
                ++n2;
            }
            builder = builder.delete(builder.length() - ", ".length(), builder.length());
        }
        builder.append(']');
        return builder.toString();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        return this.variables.length > 0;
    }

    public IVariable getVariable(int offset) throws DebugException {
        return this.variables[offset];
    }

    public IVariable[] getVariables(int offset, int length) throws DebugException {
        return Arrays.copyOfRange(this.variables, offset, offset + length);
    }

    public int getSize() throws DebugException {
        return this.variables.length;
    }

    public int getInitialOffset() {
        return 0;
    }
}

