/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.deciders.actions;

import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.SharedIcons;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.deciders.AbstractUserDecider;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.deciders.actions.DeciderAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.deciders.actions.DeciderManager;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.ILogicalStepDecider;
import org.eclipse.gemoc.executionframework.ui.views.engine.actions.AbstractEngineAction;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;

public class PauseResumeEngineDeciderAction
extends AbstractEngineAction {
    private DeciderAction _currentAction;
    private DeciderAction _stepByStepDeciderAction;

    protected void init() {
        this._currentAction = this._stepByStepDeciderAction = DeciderManager.getStepByStepDeciderAction();
        this.updateButton();
    }

    protected void updateButton() {
        if (this._currentAction != null) {
            this.setText(this._currentAction.getText());
            this.setToolTipText(this._currentAction.getToolTipText());
            if (this.getCurrentSelectedEngine() == null || this.getCurrentSelectedEngine().getRunningStatus().equals((Object)EngineStatus.RunStatus.Stopped)) {
                this.setEnabled(false);
                this.setImageDescriptor(SharedIcons.SUSPEND_ENGINE_DECIDER_ICON);
            } else {
                this.setEnabled(true);
                if (this.getCurrentSelectedEngine() instanceof IConcurrentExecutionEngine) {
                    IConcurrentExecutionEngine engine_cast = (IConcurrentExecutionEngine)this.getCurrentSelectedEngine();
                    this._currentAction = DeciderManager.getSwitchDeciderAction(engine_cast.getLogicalStepDecider());
                    if (((Object)((Object)this._currentAction)).equals((Object)this._stepByStepDeciderAction)) {
                        this.setToolTipText("Suspend associated engine using " + this._currentAction.getText());
                        this.setImageDescriptor(SharedIcons.SUSPEND_ENGINE_DECIDER_ICON);
                    } else {
                        this.setToolTipText("Resume associated engine using " + this._currentAction.getText());
                        this.setImageDescriptor(SharedIcons.RESUME_ENGINE_DECIDER_ICON);
                    }
                }
            }
        }
    }

    public void run() {
        if (this.getCurrentSelectedEngine() != null && this._currentAction != null && this.getCurrentSelectedEngine() instanceof IConcurrentExecutionEngine) {
            IConcurrentExecutionEngine engine_cast = (IConcurrentExecutionEngine)this.getCurrentSelectedEngine();
            ILogicalStepDecider savedDecider = engine_cast.getLogicalStepDecider();
            this._currentAction.run();
            this.updateButton();
            if (savedDecider instanceof AbstractUserDecider) {
                try {
                    Step selectedlogicalStep = engine_cast.getLogicalStepDecider().decide(engine_cast, engine_cast.getPossibleLogicalSteps());
                    ((AbstractUserDecider)savedDecider).decideFromTimeLine(selectedlogicalStep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void engineSelectionChanged(IExecutionEngine engine) {
        super.engineSelectionChanged(engine);
        if (engine != null) {
            if (engine instanceof IConcurrentExecutionEngine) {
                this._currentAction.setEngine((IConcurrentExecutionEngine)engine);
            }
            this.updateButton();
        }
    }
}

