/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.commons;

import fr.inria.diverse.k3.al.annotationprocessor.Aspect;
import fr.inria.diverse.k3.al.annotationprocessor.Main;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.executionframework.engine.commons.DslHelper;

public class K3DslHelper {
    public static Method findMethod(Class<?> aspect, EObject caller, String calledMethodName) throws NoSuchMethodException {
        String callerClassName = caller.eClass().getName();
        Method[] methodArray = aspect.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (methodName.equals(calledMethodName) && paramTypes.length == 1 && paramTypes[0].getSimpleName().equals(callerClassName)) {
                return method;
            }
            ++n2;
        }
        throw new NoSuchMethodException();
    }

    public static List<Method> getEntryPoints(String language) {
        ArrayList<Method> res = new ArrayList<Method>();
        Set<Class<?>> aspects = K3DslHelper.getAspects(language);
        for (Class<?> asp : aspects) {
            Method[] methodArray = asp.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (K3DslHelper.isAnnotedMain(m)) {
                    res.add(m);
                }
                ++n2;
            }
        }
        return res;
    }

    public static Set<Class<?>> getAspects(String languageName) {
        Optional<Entry> semantics;
        HashSet res = new HashSet();
        Dsl dsl = DslHelper.load(languageName);
        if (dsl != null && (semantics = dsl.getEntries().stream().filter(entry -> entry.getKey().equals("k3")).findFirst()).isPresent()) {
            String[] classNames;
            String[] stringArray = classNames = semantics.get().getValue().split(",");
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String asp = stringArray[n2];
                Class<?> cls = K3DslHelper.loadAspect(languageName, asp.trim());
                if (cls != null) {
                    res.add(cls);
                }
                ++n2;
            }
        }
        return res;
    }

    public static Class<?> getTarget(Class<?> aspect) {
        Aspect annotation = aspect.getAnnotation(Aspect.class);
        if (annotation != null) {
            Aspect k3tag = annotation;
            return k3tag.className();
        }
        return null;
    }

    public static List<Class<?>> getAspectsOn(String languageName, Class<?> target) {
        ArrayList res = new ArrayList();
        for (Class<?> aspect : K3DslHelper.getAspects(languageName)) {
            Class<?> aspectTarget = K3DslHelper.getTarget(aspect);
            if (!aspectTarget.isAssignableFrom(target)) continue;
            res.add(aspect);
        }
        return res;
    }

    public static Class<?> loadAspect(String languageName, String aspectName) {
        try {
            return DslHelper.getDslBundle(languageName).loadClass(aspectName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAnnotedMain(Method m) {
        return m.isAnnotationPresent(Main.class);
    }

    public static String getClassNameFromMethodSignature(String signature) {
        String method = signature.substring(0, signature.indexOf("("));
        String className = method.substring(0, method.lastIndexOf("."));
        return className;
    }

    public static String getMethodNameFromMethodSignature(String signature) {
        String method = signature.substring(0, signature.indexOf("("));
        String methodName = method.substring(method.lastIndexOf("."));
        return methodName;
    }

    public static String[] getParametersTypeFromMethodSignature(String signature) {
        String args = signature.substring(signature.indexOf("(") + 1, signature.indexOf(")"));
        return args.split(",");
    }
}

