/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.util;

import com.sun.enterprise.naming.spi.NamingObjectFactory;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jvnet.hk2.annotations.Service;

@Service
public class JndiNamingObjectFactory
implements NamingObjectFactory {
    private String name;
    private String jndiName;
    private AtomicReference value;
    private boolean cacheResult;

    public JndiNamingObjectFactory(String name, String jndiName, boolean cacheResult) {
        this.name = name;
        this.jndiName = jndiName;
        this.cacheResult = cacheResult;
        this.value = new AtomicReference();
    }

    @Override
    public boolean isCreateResultCacheable() {
        return this.cacheResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(Context ic) throws NamingException {
        Object result = null;
        try {
            ic.addToEnvironment("com.sun.enterprise.naming.logicalName", this.name);
            if (this.cacheResult) {
                result = this.value.get();
                if (result == null) {
                    Object tempResult = ic.lookup(this.jndiName);
                    result = this.value.compareAndSet(null, tempResult) ? tempResult : this.value.get();
                }
            } else {
                result = ic.lookup(this.jndiName);
            }
        }
        finally {
            ic.removeFromEnvironment("com.sun.enterprise.naming.logicalName");
        }
        return result;
    }
}

