/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijpa;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.BundleResource;
import org.glassfish.osgijavaeebase.OSGiBundleArchive;
import org.glassfish.osgijpa.EclipseLinkEnhancer;
import org.glassfish.osgijpa.dd.Persistence;
import org.glassfish.osgijpa.dd.PersistenceXMLReaderWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;

class JPABundleProcessor
implements Serializable {
    private static final Logger logger = Logger.getLogger(JPABundleProcessor.class.getPackage().getName());
    public static final String PXML_PATH = "META-INF/persistence.xml";
    private static final String ECLIPSELINK_JPA_PROVIDER = "org.eclipselink.jpa.PersistenceProvider";
    public static final String STATICALLY_WEAVED = "GlassFish-StaticallyWeaved";
    private long bundleId;
    private List<Persistence> persistenceXMLs;
    private static final long serialVersionUID = -1293408086392301220L;

    JPABundleProcessor(Bundle b) {
        this.bundleId = b.getBundleId();
    }

    boolean isJPABundle() {
        if (this.persistenceXMLs == null) {
            this.discoverPxmls();
        }
        return !this.persistenceXMLs.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discoverPxmls() {
        assert (this.persistenceXMLs == null);
        this.persistenceXMLs = new ArrayList<Persistence>();
        if (this.isFragment()) {
            return;
        }
        for (BundleResource r : new OSGiBundleArchive(this.getBundle())) {
            URL pxmlURL;
            if (!PXML_PATH.equals(r.getPath())) continue;
            try {
                pxmlURL = r.getUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            InputStream is = null;
            try {
                is = pxmlURL.openStream();
                Persistence persistence = new PersistenceXMLReaderWriter().read(is);
                persistence.setUrl(pxmlURL);
                persistence.setPURoot(r.getArchivePath());
                this.persistenceXMLs.add(persistence);
            }
            catch (IOException ioe) {
                logger.logp(Level.WARNING, "JPABundleProcessor", "discoverPxmls", "Exception occurred while processing " + pxmlURL, ioe);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    boolean validate(List<Persistence> persistenceList) {
        for (Persistence persistence : persistenceList) {
            for (Persistence.PersistenceUnit pu : persistence.getPersistenceUnit()) {
                if (pu.getProvider() == null) continue;
                if (ECLIPSELINK_JPA_PROVIDER.equals(pu.getProvider())) {
                    return false;
                }
                logger.logp(Level.INFO, "JPABundleProcessor", "validate", "{0} has a persistence-unit which does not use {1} as provider", new Object[]{persistence, ECLIPSELINK_JPA_PROVIDER});
            }
        }
        return true;
    }

    InputStream enhance() throws BundleException, IOException {
        EclipseLinkEnhancer enhancer = new EclipseLinkEnhancer();
        InputStream enhancedStream = enhancer.enhance(this.getBundle(), this.persistenceXMLs);
        return enhancedStream;
    }

    public boolean isEnhanced() {
        return this.getBundle().getHeaders().get(STATICALLY_WEAVED) != null;
    }

    private boolean isFragment() {
        return this.getBundle().getHeaders().get("Fragment-Host") != null;
    }

    public Bundle getBundle() {
        Bundle b = this.getBundleContext().getBundle(this.bundleId);
        if (b == null) {
            throw new RuntimeException("Bundle with id " + this.bundleId + " has already been uninstalled");
        }
        return b;
    }

    private BundleContext getBundleContext() {
        return ((BundleReference)BundleReference.class.cast(this.getClass().getClassLoader())).getBundle().getBundleContext();
    }

    long getBundleId() {
        return this.bundleId;
    }
}

