/*
 * Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

//dojo.provide("webui.suntheme.props");
define( function() {

/**
 * This closure is used to provide theme properties.
 */
    return {
    // Common properties.
    hiddenClassName: "hidden_sun4", // Use webui.suntheme.common.setVisibleElement

    // Button properties.
    button: {
        imageClassName: "Btn3_sun4",
        imageDisabledClassName: "Btn3Dis_sun4",
        imageHovClassName: "Btn3Hov_sun4",
        primaryClassName: "Btn1_sun4",
        primaryDisabledClassName: "Btn1Dis_sun4",
        primaryHovClassName: "Btn1Hov_sun4",
        primaryMiniClassName: "Btn1Mni_sun4",
        primaryMiniHovClassName: "Btn1MniHov_sun4",
        primaryMiniDisabledClassName: "Btn1MniDis_sun4",
        secondaryClassName: "Btn2_sun4",
        secondaryDisabledClassName: "Btn2Dis_sun4",
        secondaryHovClassName: "Btn2Hov_sun4",
        secondaryMiniClassName: "Btn2Mni_sun4",
        secondaryMiniDisabledClassName: "Btn2MniDis_sun4",
        secondaryMiniHovClassName: "Btn2MniHov_sun4"
    },

    // Drop Down properties.
    dropDown: {
        className: "MnuStd_sun4",
        disabledClassName: "MnuStdDis_sun4",
        optionClassName: "MnuStdOpt_sun4",
        optionDisabledClassName: "MnuStdOptDis_sun4",
        optionGroupClassName: "MnuStdOptGrp_sun4",
        optionSelectedClassName: "MnuStdOptSel_sun4",
        optionSeparatorClassName: "MnuStdOptSep_sun4"
    },

    // Field properties.
    field: {
        areaClassName: "TxtAra_sun4",
        areaDisabledClassName: "TxtAraDis_sun4",
        fieldClassName: "TxtFld_sun4",
        fieldDisabledClassName: "TxtFldDis_sun4"
    },

    // Jump drop down properties.
    jumpDropDown: {
        className: "MnuJmp_sun4",
        disabledClassName: "",
        optionClassName: "MnuJmpOpt_sun4",
        optionDisabledClassName: "MnuJmpOptDis_sun4",
        optionGroupClassName: "MnuJmpOptGrp_sun4",
        optionSelectedClassName: "MnuJmpOptSel_sun4",
        optionSeparatorClassName: "MnuJmpOptSep_sun4"
    },

    // Listbox properties.
    listbox: {
        className: "Lst_sun4",
        disabledClassName: "LstDis_sun4",
        monospaceClassName: "LstMno_sun4",
        monospaceDisabledClassName: "LstMnoDis_sun4",
        optionClassName: "LstOpt_sun4",
        optionDisabledClassName: "LstOptDis_sun4",
        optionGroupClassName: "LstOptGrp_sun4",
        optionSelectedClassName: "LstOptSel_sun4",
        optionSeparatorClassName: "LstOptSep_sun4"
    },

    // Tree properties.
    tree: {
        selectedTreeRowClass: "TreeSelRow_sun4",
        treeRowClass: "TreeRow_sun4"
    }
}
});

//-->
