/*
 * Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

//
// This Javascript file should be included in any page that uses the associated
// component, where JSF Extensions is used as the underlying transfer protocol.
//

dojo.provide("webui.suntheme.widget.jsfx.progressBar");

dojo.require("webui.suntheme.widget.progressBar");

/**
 * This name space is used to update data asynchronously.
 */
webui.suntheme.widget.jsfx.progressBar =  {
    /**
     * This function is used to process refresh events.
     *
     * @param evt Event generated by scroll bar.
     */
    processRefreshEvent: function(id) {
        var dom = document.getElementById(id); 

        // Generate AJAX request using the JSF Extensions library.
        new DynaFaces.fireAjaxTransaction(dom, {
            execute: (dom) ? id : "none",
            render: id,
            replaceElement: webui.suntheme.widget.jsfx.progressBar.update });

        return true;
    },

    /**
     * This function is used to update progress.
     *
     * @param elementId The HTML element Id.
     * @param content The content returned by the AJAX response.
     * @param closure The closure argument provided to DynaFaces.fireAjaxTransaction.
     * @param xjson The zjson argument provided to DynaFaces.fireAjaxTransaction.
     */
    update: function(elementId, content, closure, xjson) {
        if (elementId == null || content == null) {
            return false;
        }

        // Parse JSON text.
        var json = JSON.parse(content);

        // Set progress.
        var domNode = document.getElementById(elementId);
        domNode._setProgress({
            failedStateText : json.failedStateText,
            logMessage : json.logMessage,
            progress : json.progress,
            status: json.status,
            taskState : json.taskState,
            topText : json.topText
        });

        // Publish an event for custom AJAX implementations to listen for.
        webui.suntheme.widget.progressBar.refresh.publishEndEvent(json);
        return true;
    }
}

// Listen for Dojo Widget events.
dojo.event.topic.subscribe(webui.suntheme.widget.progressBar.refresh.beginEventTopic,
    webui.suntheme.widget.jsfx.progressBar, "processRefreshEvent");

//-->
