/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.protocol;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionMessage;
import org.eclipse.glsp.server.actions.ActionRegistry;
import org.eclipse.glsp.server.protocol.DisposeClientSessionParameters;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.GLSPServer;
import org.eclipse.glsp.server.protocol.GLSPServerListener;
import org.eclipse.glsp.server.protocol.InitializeClientSessionParameters;
import org.eclipse.glsp.server.protocol.InitializeParameters;
import org.eclipse.glsp.server.protocol.InitializeResult;
import org.eclipse.glsp.server.session.ClientSession;
import org.eclipse.glsp.server.session.ClientSessionManager;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.MessageActionUtil;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;

public class DefaultGLSPServer
implements GLSPServer {
    private static Logger LOGGER = LogManager.getLogger(DefaultGLSPServer.class);
    public static final String PROTOCOL_VERSION = "1.0.0";
    @Inject
    protected ClientSessionManager sessionManager;
    @Inject
    protected ActionRegistry actionRegistry;
    protected GLSPClient clientProxy;
    protected CompletableFuture<InitializeResult> initialized = new CompletableFuture();
    protected String applicationId;
    protected Map<String, ClientSession> clientSessions;
    protected Set<GLSPServerListener> serverConnectionListeners = new LinkedHashSet<GLSPServerListener>();

    public DefaultGLSPServer() {
        this.clientSessions = new HashMap<String, ClientSession>();
    }

    @Override
    public CompletableFuture<InitializeResult> initialize(InitializeParameters params) {
        LOGGER.debug("Initializing server with the following params:\n" + params);
        this.validateProtocolVersion(params);
        if (this.isInitialized()) {
            if (!params.getApplicationId().equals(this.applicationId)) {
                String errorMsg = String.format("Could not initialize GLSP server for application '%s'. Server has already been initializedfor a different appliction with id '%s'", params.getApplicationId(), this.applicationId);
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InvalidParams, errorMsg, (Object)params));
            }
            return this.initialized;
        }
        this.applicationId = params.getApplicationId();
        InitializeResult result = new InitializeResult(PROTOCOL_VERSION);
        this.actionRegistry.getHandledActionKinds().forEach((diagramType, serverHandledActions) -> result.addServerActions((String)diagramType, (Collection<String>)serverHandledActions));
        this.initialized = this.handleIntializeArgs(result, params.getArgs());
        this.serverConnectionListeners.forEach(listener -> listener.serverInitialized(this));
        return this.initialized;
    }

    protected void validateProtocolVersion(InitializeParameters params) {
        if (!params.getProtocolVersion().equals(PROTOCOL_VERSION)) {
            String errorMsg = String.format("Protocol version mismatch! The client protocol version '%s' is not compatible with the server protocol version '%s'!", params.getProtocolVersion(), PROTOCOL_VERSION);
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InvalidParams, errorMsg, (Object)params));
        }
    }

    protected CompletableFuture<InitializeResult> handleIntializeArgs(InitializeResult result, Map<String, String> args) {
        return CompletableFuture.completedFuture(result);
    }

    protected void validateServerInitialized() {
        if (!this.isInitialized()) {
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.serverNotInitialized, "The GLSP server has not been initialized.", null));
        }
    }

    @Override
    public CompletableFuture<Void> initializeClientSession(InitializeClientSessionParameters params) {
        LOGGER.debug("Initializing client session with the following params:\n" + params);
        this.validateServerInitialized();
        try {
            ClientSession session = this.sessionManager.getOrCreateClientSession(params);
            this.clientSessions.put(params.getClientSessionId(), session);
            return this.handleInitializeClientSessionArgs(params.getArgs());
        }
        catch (GLSPServerException exception) {
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InternalError, exception.getMessage(), (Object)exception));
        }
    }

    protected CompletableFuture<Void> handleInitializeClientSessionArgs(Map<String, String> args) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> disposeClientSession(DisposeClientSessionParameters params) {
        LOGGER.debug("Dispose client session with the following params:\n" + params);
        this.validateServerInitialized();
        if (this.sessionManager.disposeClientSession(params.getClientSessionId())) {
            this.clientSessions.remove(params.getClientSessionId());
            return this.handleDisposeClientSessionArgs(params.getArgs());
        }
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> handleDisposeClientSessionArgs(Map<String, String> args) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void connect(GLSPClient clientProxy) {
        this.clientProxy = clientProxy;
        if (clientProxy != null) {
            this.serverConnectionListeners.forEach(listener -> listener.clientConnected(clientProxy));
        }
    }

    @Override
    public void process(ActionMessage message) {
        this.validateServerInitialized();
        LOGGER.debug("process " + message);
        String clientSessionId = message.getClientId();
        if (!this.clientSessions.containsKey(clientSessionId)) {
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InvalidParams, "No client session has beend initialized for client id: " + clientSessionId, (Object)message));
        }
        Function<Throwable, Void> errorHandler = ex -> {
            String errorMsg = "Could not process message:" + message;
            LOGGER.error("[ERROR] " + errorMsg, ex);
            this.getClient().process(new ActionMessage(clientSessionId, MessageActionUtil.error("[GLSP-Server] " + errorMsg, ex)));
            return null;
        };
        try {
            Action action = message.getAction();
            action.setReceivedFromClient(true);
            this.clientSessions.get(clientSessionId).getActionDispatcher().dispatch(action).exceptionally((Function)errorHandler);
        }
        catch (RuntimeException e) {
            errorHandler.apply(e);
        }
    }

    public boolean isInitialized() {
        return this.initialized.isDone();
    }

    @Override
    public void shutdown() {
        LOGGER.info("Shutdown GLSP Server " + this);
        this.serverConnectionListeners.forEach(listener -> listener.serverShutDown(this));
        this.clientSessions.clear();
        this.initialized = new CompletableFuture();
        this.clientProxy = null;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public GLSPClient getClient() {
        return this.clientProxy;
    }

    @Override
    public boolean addListener(GLSPServerListener listener) {
        return this.serverConnectionListeners.add(listener);
    }

    @Override
    public boolean remove(GLSPServerListener listener) {
        return this.serverConnectionListeners.remove(listener);
    }
}

