/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.emf.notation;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.glsp.server.emf.EMFSourceModelStorage;
import org.eclipse.glsp.server.emf.model.notation.Diagram;
import org.eclipse.glsp.server.emf.model.notation.NotationPackage;
import org.eclipse.glsp.server.emf.notation.EMFNotationModelState;
import org.eclipse.glsp.server.features.core.model.RequestModelAction;

public class EMFNotationSourceModelStorage
extends EMFSourceModelStorage {
    @Inject
    protected EMFNotationModelState modelState;

    @Override
    protected ResourceSet setupResourceSet(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)NotationPackage.eINSTANCE.getNsURI(), (Object)NotationPackage.eINSTANCE);
        return super.setupResourceSet(resourceSet);
    }

    @Override
    protected void doLoadSourceModel(ResourceSet resourceSet, URI sourceURI, RequestModelAction action) {
        this.loadSemanticModel(resourceSet, sourceURI, action);
        this.loadNotationModel(resourceSet, sourceURI, action);
    }

    protected void loadNotationModel(ResourceSet resourceSet, URI sourceURI, RequestModelAction action) {
        super.loadResource(resourceSet, this.deriveNotationModelURI(sourceURI), Diagram.class).ifPresent(this.modelState::setNotationModel);
    }

    protected URI deriveNotationModelURI(URI sourceURI) {
        return sourceURI.trimFileExtension().appendFileExtension("notation");
    }

    protected void loadSemanticModel(ResourceSet resourceSet, URI sourceURI, RequestModelAction action) {
        this.loadResource(resourceSet, this.deriveSemanticModelURI(sourceURI)).ifPresent(this.modelState::setSemanticModel);
    }

    protected URI deriveSemanticModelURI(URI sourceURI) {
        return sourceURI;
    }
}

