/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Optional;
import org.eclipse.golo.runtime.DecoratorsHelper;
import org.eclipse.golo.runtime.FunctionCallSupport;
import org.eclipse.golo.runtime.MethodInvocation;

abstract class MethodFinder {
    protected final MethodInvocation invocation;
    protected final MethodHandles.Lookup lookup;
    protected final Class<?> callerClass;

    MethodFinder(MethodInvocation invocation, MethodHandles.Lookup lookup) {
        this.invocation = invocation;
        this.lookup = lookup;
        this.callerClass = lookup.lookupClass();
    }

    public abstract MethodHandle find();

    protected Optional<MethodHandle> toMethodHandle(Method method) {
        MethodHandle target = null;
        if (DecoratorsHelper.isMethodDecorated(method)) {
            target = DecoratorsHelper.getDecoratedMethodHandle(this.lookup, method, this.invocation.arity());
        } else {
            try {
                target = this.lookup.unreflect(method);
            }
            catch (IllegalAccessException e) {
                return Optional.empty();
            }
        }
        if (this.invocation.argumentNames().length > 1) {
            target = FunctionCallSupport.reorderArguments(method, target, this.invocation.argumentNames());
        }
        return Optional.of(this.invocation.coerce(target));
    }
}

