/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.ConditionalBranching;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.ReferenceTable;
import org.eclipse.golo.compiler.ir.ReturnStatement;
import org.eclipse.golo.compiler.ir.Scope;
import org.eclipse.golo.compiler.ir.ThrowStatement;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class Block
extends ExpressionStatement
implements Scope {
    private final List<GoloStatement> statements = new LinkedList<GoloStatement>();
    private ReferenceTable referenceTable;
    private boolean hasReturn = false;

    Block(ReferenceTable referenceTable) {
        this.referenceTable = referenceTable;
    }

    public static Block emptyBlock() {
        return new Block(new ReferenceTable());
    }

    public static Block of(Object block) {
        if (block == null) {
            return Block.emptyBlock();
        }
        if (block instanceof Block) {
            return (Block)block;
        }
        throw Block.cantConvert("Block", block);
    }

    @Override
    public Block ofAST(GoloASTNode n) {
        super.ofAST(n);
        return this;
    }

    public void merge(Block other) {
        for (GoloStatement innerStatement : other.getStatements()) {
            this.addStatement(innerStatement);
        }
    }

    public ReferenceTable getReferenceTable() {
        return this.referenceTable;
    }

    @Override
    public Optional<ReferenceTable> getLocalReferenceTable() {
        return Optional.of(this.referenceTable);
    }

    public Block ref(Object referenceTable) {
        if (referenceTable instanceof ReferenceTable) {
            this.setReferenceTable((ReferenceTable)referenceTable);
            return this;
        }
        throw new IllegalArgumentException("not a reference table");
    }

    public void setReferenceTable(ReferenceTable referenceTable) {
        this.referenceTable = Objects.requireNonNull(referenceTable);
    }

    public void internReferenceTable() {
        this.referenceTable = this.referenceTable.flatDeepCopy(true);
    }

    public List<GoloStatement> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public Block add(Object statement) {
        this.addStatement(Builders.toGoloStatement(statement));
        return this;
    }

    private void updateStateWith(GoloStatement statement) {
        this.referenceTable.updateFrom(statement);
        this.makeParentOf(statement);
        this.checkForReturns(statement);
    }

    public void addStatement(GoloStatement statement) {
        this.statements.add(statement);
        this.updateStateWith(statement);
    }

    public void prependStatement(GoloStatement statement) {
        this.statements.add(0, statement);
        this.updateStateWith(statement);
    }

    private void setStatement(int idx, GoloStatement statement) {
        this.statements.set(idx, statement);
        this.updateStateWith(statement);
    }

    private void checkForReturns(GoloStatement statement) {
        if (statement instanceof ReturnStatement || statement instanceof ThrowStatement) {
            this.hasReturn = true;
        } else if (statement instanceof ConditionalBranching) {
            this.hasReturn = this.hasReturn || ((ConditionalBranching)statement).returnsFromBothBranches();
        }
    }

    public boolean hasReturn() {
        return this.hasReturn;
    }

    public int size() {
        return this.statements.size();
    }

    public boolean hasOnlyReturn() {
        return this.statements.size() == 1 && this.statements.get(0) instanceof ReturnStatement && !((ReturnStatement)this.statements.get(0)).isReturningVoid();
    }

    public String toString() {
        return "{" + this.statements.toString() + "}";
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    @Override
    public void relink(ReferenceTable table) {
        this.referenceTable.relink(table);
    }

    @Override
    public void relinkTopLevel(ReferenceTable table) {
        this.referenceTable.relinkTopLevel(table);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitBlock(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (LocalReference ref : this.referenceTable.ownedReferences()) {
            ref.accept(visitor);
        }
        for (GoloStatement statement : this.statements) {
            statement.accept(visitor);
        }
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!this.statements.contains(original) || !(newElement instanceof GoloStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.setStatement(this.statements.indexOf(original), (GoloStatement)newElement);
    }
}

