/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.ReferenceTable;

public class ReferenceLookup
extends ExpressionStatement {
    private final String name;

    ReferenceLookup(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LocalReference resolveIn(ReferenceTable referenceTable) {
        return referenceTable.get(this.name);
    }

    public LocalReference varRef() {
        return Builders.localRef(this.name).variable();
    }

    public LocalReference letRef() {
        return Builders.localRef(this.name);
    }

    public String toString() {
        return String.format("Ref{name=%s}", this.getName());
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitReferenceLookup(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        throw this.cantReplace();
    }
}

