/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.AbstractRange;
import gololang.Range;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

final class IntRange
extends AbstractRange<Integer> {
    IntRange(int from, int to) {
        super(from, to);
    }

    IntRange(int to) {
        super(to);
    }

    @Override
    Integer defaultValue() {
        return 0;
    }

    @Override
    public Range<Integer> reversed() {
        return new IntRange((Integer)this.to(), (Integer)this.from()).decrementBy(this.increment());
    }

    @Override
    public int size() {
        if (Objects.equals(this.to(), this.from())) {
            return 0;
        }
        int theSize = ((Integer)this.to() - (Integer)this.from()) / this.increment();
        if (theSize < 0) {
            return 0;
        }
        if (theSize == 0) {
            return 1;
        }
        return theSize;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        Integer obj = (Integer)o;
        return this.encloses(obj) && (obj - (Integer)this.from()) % this.increment() == 0;
    }

    @Override
    public Range<Integer> tail() {
        if (this.isEmpty()) {
            return this;
        }
        return new IntRange((Integer)this.from() + this.increment(), (Integer)this.to()).incrementBy(this.increment());
    }

    @Override
    public Iterator<Integer> iterator() {
        return new AbstractRange.RangeIterator<Integer>(){
            private boolean started = false;
            private int current = (Integer)IntRange.this.from();
            private final int to = (Integer)IntRange.this.to();

            @Override
            public boolean hasNext() {
                return Integer.compare(this.to, this.current) * IntRange.this.cmp() > 0;
            }

            @Override
            public Integer next() {
                int value = this.current;
                if (this.started) {
                    if (this.hasNext()) {
                        this.current += IntRange.this.increment();
                        return value;
                    }
                    throw new NoSuchElementException("iteration has finished");
                }
                this.started = true;
                this.current += IntRange.this.increment();
                return value;
            }
        };
    }
}

