/*
 * Decompiled with CFR 0.152.
 */
package gololang.error;

import gololang.FunctionReference;
import gololang.Tuple;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Result<T, E extends Throwable>
implements Iterable<T> {
    private static final Result<?, ?> EMPTY = new Result();
    private final T value;
    private final E error;

    private Result() {
        this.value = null;
        this.error = null;
    }

    private Result(T value, E throwable) {
        this.value = value;
        this.error = throwable;
    }

    public static Result<Object, Throwable> of(Object value) {
        if (value == null) {
            return Result.empty();
        }
        if (value instanceof Throwable) {
            return Result.error((Throwable)value);
        }
        if (value instanceof Optional) {
            Optional opt = (Optional)value;
            return Result.option(opt);
        }
        return Result.ok(value);
    }

    public static <T, E extends Throwable> Result<T, E> empty() {
        Result<?, ?> r = EMPTY;
        return r;
    }

    public static <T, E extends Throwable> Result<T, E> ok(T value) {
        return value == null ? Result.empty() : new Result<T, Object>(value, null);
    }

    public static <T, E extends Throwable> Result<T, E> error(E throwable) {
        return throwable == null ? Result.empty() : new Result<Object, E>(null, throwable);
    }

    public static <T, E extends Throwable> Result<T, E> option(Optional<T> opt) {
        return opt == null || !opt.isPresent() ? Result.empty() : new Result<T, Object>(opt.get(), null);
    }

    public static <T> Result<T, NoSuchElementException> option(Optional<T> opt, String message) {
        return opt == null || !opt.isPresent() ? new Result<Object, NoSuchElementException>(null, new NoSuchElementException(message)) : new Result<T, Object>(opt.get(), null);
    }

    public static <T> Result<T, RuntimeException> fail(String message) {
        return Result.error(new RuntimeException(message));
    }

    public T get() throws E, NoSuchElementException {
        if (this.value != null) {
            return this.value;
        }
        if (this.error != null) {
            throw this.error;
        }
        throw new NoSuchElementException("Empty result");
    }

    public Optional<T> toOptional() {
        if (this.value != null) {
            return Optional.of(this.value);
        }
        return Optional.empty();
    }

    public List<T> toList() {
        if (this.value != null) {
            return Collections.singletonList(this.value);
        }
        return Collections.emptyList();
    }

    public List<E> toErrorList() {
        if (this.error != null) {
            return Collections.singletonList(this.error);
        }
        return Collections.emptyList();
    }

    @Override
    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    public Optional<E> toOptionalError() {
        if (this.error != null) {
            return Optional.of(this.error);
        }
        return Optional.empty();
    }

    public T orElse(T other) {
        if (this.value != null) {
            return this.value;
        }
        return other;
    }

    public Object orElseGet(FunctionReference fun) throws Throwable {
        if (this.value != null) {
            return this.value;
        }
        return fun.invoke(new Object[0]);
    }

    public boolean isEmpty() {
        return this.value == null && this.error == null;
    }

    public boolean isError() {
        return this.value == null && this.error != null;
    }

    public boolean isError(Class<?> type) {
        return this.error != null && type.isInstance(this.error);
    }

    public boolean isValue() {
        return this.value != null && this.error == null;
    }

    public boolean isValue(Object val) {
        return Objects.equals(this.value, val);
    }

    public <U, X extends Throwable> Result<U, X> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.value == null) {
            Result r = this;
            return r;
        }
        try {
            return Result.ok(mapper.apply(this.value));
        }
        catch (Throwable e) {
            Result<T, Throwable> r = Result.error(e);
            return r;
        }
    }

    public <X extends Throwable> Result<T, X> mapError(Function<? super E, ? extends X> mapper) {
        Objects.requireNonNull(mapper);
        if (this.error == null) {
            Result r = this;
            return r;
        }
        try {
            return Result.error((Throwable)mapper.apply(this.error));
        }
        catch (Throwable e) {
            Result<T, Throwable> r = Result.error(e);
            return r;
        }
    }

    public <U, X extends Throwable> Result<U, X> flatMap(Function<? super T, Result<U, X>> mapper) {
        Result<U, X> result;
        Objects.requireNonNull(mapper);
        if (this.isEmpty() || this.isError()) {
            Result r = this;
            return r;
        }
        try {
            result = mapper.apply(this.value);
        }
        catch (Throwable e) {
            Result<T, Throwable> err = Result.error(e);
            return err;
        }
        return Objects.requireNonNull(result);
    }

    public Result<Object, Throwable> flatMap(FunctionReference mapper) {
        Result<Object, Throwable> result = this.flatMap((Function)mapper.to(Function.class));
        return result;
    }

    public Result<?, ?> flattened() {
        if (this.value == null) {
            return this;
        }
        return (Result)this.value;
    }

    public Result<?, ? extends Throwable> andThen(FunctionReference mapper) {
        Object result;
        Objects.requireNonNull(mapper);
        if (this.isEmpty() || this.isError()) {
            return this;
        }
        try {
            result = mapper.invoke(this.value);
        }
        catch (Throwable e) {
            return Result.error(e);
        }
        if (result instanceof Result) {
            return (Result)result;
        }
        return Result.ok(result);
    }

    public Object either(FunctionReference mapping, FunctionReference recover) throws Throwable {
        if (this.isError()) {
            return recover.invoke(this.error);
        }
        return mapping.invoke(this.value);
    }

    public Object either(FunctionReference mapping, FunctionReference recover, FunctionReference def) throws Throwable {
        if (this.isEmpty()) {
            return def.invoke(new Object[0]);
        }
        return this.either(mapping, recover);
    }

    public Result<Object, Throwable> map(FunctionReference mapper) {
        Result<Object, Throwable> result = this.map((Function)mapper.to(Function.class));
        return result;
    }

    public Result<T, E> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isEmpty() || this.isError()) {
            return this;
        }
        return predicate.test(this.value) ? this : Result.empty();
    }

    public Object reduce(Object init, FunctionReference func) throws Throwable {
        if (this.value == null) {
            return init;
        }
        return func.invoke(init, this.value);
    }

    public Result<?, ?> apply(Result<?, ?> other) throws Throwable {
        if (!this.isValue()) {
            return this;
        }
        if (!(this.value instanceof FunctionReference)) {
            throw new RuntimeException("The result must contain a function to be applied");
        }
        FunctionReference f = (FunctionReference)this.value;
        if (f.arity() > 1) {
            return Result.ok(f.bindTo(other.get()));
        }
        return other.map((FunctionReference)this.value);
    }

    public Result<?, ?> and(Result<?, ?> other) {
        if (!this.isError()) {
            return other;
        }
        return this;
    }

    public Result<?, ?> or(Result<?, ?> other) {
        if (this.isError()) {
            return other;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Result that = (Result)o;
        return Objects.equals(this.value, that.value) && (Objects.equals(this.error, that.error) || this.error.getClass() == that.error.getClass() && ((Throwable)this.error).getMessage().equals(((Throwable)that.error).getMessage()));
    }

    public int hashCode() {
        if (this.error == null) {
            return Objects.hash(this.value);
        }
        return Objects.hash(this.error.getClass(), ((Throwable)this.error).getMessage());
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Result.empty";
        }
        if (this.isError()) {
            return String.format("Result.error[%s]", this.error);
        }
        return String.format("Result.value[%s]", this.value);
    }

    public Tuple destruct() {
        return new Tuple(this.error, this.value);
    }
}

