/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.Messages;
import gololang.ir.FunctionContainer;
import gololang.ir.GoloElement;
import gololang.ir.GoloFunction;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloModule;
import gololang.ir.ToplevelGoloElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.golo.compiler.PackageAndClass;

public final class Augmentation
extends GoloElement<Augmentation>
implements FunctionContainer,
ToplevelGoloElement {
    private final PackageAndClass target;
    private final Set<GoloFunction> functions = new LinkedHashSet<GoloFunction>();
    private final Set<String> names = new LinkedHashSet<String>();

    private Augmentation(PackageAndClass target) {
        this.target = target;
    }

    @Override
    protected Augmentation self() {
        return this;
    }

    public static Augmentation of(Object target) {
        return new Augmentation(PackageAndClass.of(target));
    }

    public PackageAndClass getTarget() {
        GoloModule mod;
        if (this.target.packageName().isEmpty() && (mod = this.enclosingModule()) != null) {
            return mod.getTypesPackage().createSubPackage(this.target.className());
        }
        return this.target;
    }

    @Override
    public PackageAndClass getPackageAndClass() {
        return this.getTarget();
    }

    @Override
    public List<GoloFunction> getFunctions() {
        return new ArrayList<GoloFunction>(this.functions);
    }

    @Override
    public void addFunction(GoloFunction func) {
        if (func.getArity() == 0) {
            throw new IllegalArgumentException(Messages.message("augment_function_no_args", func.getName(), this.getPackageAndClass()));
        }
        this.functions.add(this.makeParentOf(func));
    }

    @Override
    public boolean hasFunctions() {
        return !this.functions.isEmpty();
    }

    public Set<String> getNames() {
        return Collections.unmodifiableSet(this.names);
    }

    public boolean hasNames() {
        return !this.names.isEmpty();
    }

    public Augmentation with(Object ... objects) {
        return this.with(Arrays.asList(objects));
    }

    public Augmentation with(Collection<?> objects) {
        if (objects != null) {
            for (Object o : objects) {
                if (o instanceof String) {
                    this.names.add((String)o);
                    continue;
                }
                this.addElement(o);
            }
        }
        return this;
    }

    public void merge(Augmentation other) {
        if (!other.getTarget().equals(this.getTarget())) {
            throw new IllegalArgumentException("Can't merge augmentations to different targets");
        }
        if (other != this) {
            this.names.addAll(other.getNames());
            this.addFunctions(other.getFunctions());
        }
    }

    public String toString() {
        return String.format("Augmentation<target=%s, names=%s, functions=%s>", this.getTarget(), this.getNames(), this.getFunctions());
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!this.functions.contains(original)) {
            throw this.cantReplace(original, newElement);
        }
        this.functions.remove(original);
        this.addElement(newElement);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitAugmentation(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList(this.functions);
        return children;
    }
}

