/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.FunctionReference;
import gololang.ir.ConditionalBranching;
import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloStatement;
import gololang.ir.LocalReference;
import gololang.ir.ReferenceTable;
import gololang.ir.ReturnStatement;
import gololang.ir.ThrowStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Block
extends ExpressionStatement<Block>
implements Iterable<GoloStatement<?>> {
    private final List<GoloStatement<?>> statements = new LinkedList();
    private ReferenceTable referenceTable;
    private boolean hasReturn = false;

    Block(ReferenceTable referenceTable) {
        this.referenceTable = Objects.requireNonNull(referenceTable);
    }

    @Override
    protected Block self() {
        return this;
    }

    public static Block empty() {
        return new Block(new ReferenceTable());
    }

    public static Block of(Object block) {
        if (block == null) {
            return Block.empty();
        }
        if (block instanceof Block) {
            return (Block)block;
        }
        if (block instanceof GoloStatement) {
            return Block.empty().add(block);
        }
        throw Block.cantConvert("Block", block);
    }

    public static Block block(Object ... statements) {
        if (statements.length == 1) {
            return Block.of(statements[0]);
        }
        Block block = Block.empty();
        for (Object st : statements) {
            block.add(st);
        }
        return block;
    }

    public void merge(Block other) {
        for (GoloStatement<?> innerStatement : other.getStatements()) {
            this.add(innerStatement);
        }
    }

    public ReferenceTable getReferenceTable() {
        return this.referenceTable;
    }

    @Override
    public Optional<ReferenceTable> getLocalReferenceTable() {
        return Optional.ofNullable(this.referenceTable);
    }

    public Block ref(Object referenceTable) {
        if (referenceTable instanceof ReferenceTable) {
            this.referenceTable = (ReferenceTable)referenceTable;
            return this;
        }
        throw new IllegalArgumentException("not a reference table");
    }

    public void internReferenceTable() {
        this.referenceTable = this.referenceTable.flatDeepCopy(true);
    }

    public List<GoloStatement<?>> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    @Override
    public Iterator<GoloStatement<?>> iterator() {
        return this.statements.iterator();
    }

    public Block map(FunctionReference fun) throws Throwable {
        Block res = Block.empty();
        for (GoloElement elt : this) {
            res.add(fun.invoke(elt));
        }
        return res;
    }

    public Block add(Object statement) {
        if (statement != null) {
            this.addStatement(this.statements.size(), GoloStatement.of(statement));
        }
        return this;
    }

    private void updateStateWith(GoloStatement<?> statement) {
        this.referenceTable.updateFrom(statement);
        this.makeParentOf(statement);
        this.checkForReturns(statement);
    }

    private void addStatement(int idx, GoloStatement<?> statement) {
        this.statements.add(idx, statement);
        this.updateStateWith(statement);
    }

    public Block prepend(Object statement) {
        if (statement != null) {
            this.addStatement(0, GoloStatement.of(statement));
        }
        return this;
    }

    private void setStatement(int idx, GoloStatement<?> statement) {
        this.statements.set(idx, statement);
        this.updateStateWith(statement);
    }

    public void flatten() {
        ArrayList toFlatten = new ArrayList(this.statements);
        this.statements.clear();
        for (GoloStatement goloStatement : toFlatten) {
            if (goloStatement instanceof Block) {
                Block block = (Block)goloStatement;
                if (block.referenceTable.isEmpty()) {
                    block.flatten();
                    for (GoloStatement<?> s : block.statements) {
                        this.add(s);
                    }
                    continue;
                }
            }
            this.add(goloStatement);
        }
    }

    private void checkForReturns(GoloStatement<?> statement) {
        if (statement instanceof ReturnStatement || statement instanceof ThrowStatement) {
            this.hasReturn = true;
        } else if (statement instanceof ConditionalBranching) {
            this.hasReturn = this.hasReturn || ((ConditionalBranching)statement).returnsFromBothBranches();
        }
    }

    public boolean hasReturn() {
        return this.hasReturn;
    }

    public int size() {
        return this.statements.size();
    }

    public boolean hasOnlyReturn() {
        return this.statements.size() == 1 && this.statements.get(0) instanceof ReturnStatement && !((ReturnStatement)this.statements.get(0)).isReturningVoid();
    }

    public boolean hasOnlyExpression() {
        return this.statements.size() == 1 && this.statements.get(0) instanceof ExpressionStatement;
    }

    public String toString() {
        return "{" + this.statements.toString() + "}";
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitBlock(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (LocalReference localReference : this.referenceTable.ownedReferences()) {
            localReference.accept(visitor);
        }
        for (GoloStatement goloStatement : this.statements) {
            goloStatement.accept(visitor);
        }
    }

    @Override
    public List<GoloElement<?>> children() {
        return Collections.unmodifiableList(this.statements);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!this.statements.contains(original) || !(newElement instanceof GoloStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.setStatement(this.statements.indexOf(original), (GoloStatement)newElement);
    }
}

