/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import gololang.Messages;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.cli.command.ClasspathOption;
import org.eclipse.golo.cli.command.spi.CliCommand;
import org.eclipse.golo.compiler.GoloCompilationException;
import org.eclipse.golo.compiler.GoloCompiler;

@Parameters(commandNames={"check"}, resourceBundle="commands", commandDescriptionKey="check")
public class CheckCommand
implements CliCommand {
    @Parameter(names={"--exit"}, descriptionKey="check.exit")
    boolean exit = false;
    @Parameter(names={"--verbose"}, descriptionKey="check.verbose")
    boolean verbose = false;
    @Parameter(descriptionKey="source_files")
    List<String> files = new LinkedList<String>();
    @ParametersDelegate
    ClasspathOption classpath = new ClasspathOption();

    @Override
    public void execute() throws Throwable {
        GoloCompiler compiler = this.classpath.initGoloClassLoader().getCompiler();
        for (String file : this.files) {
            this.check(new File(file), compiler);
        }
    }

    private void check(File file, GoloCompiler compiler) {
        block6: {
            block5: {
                if (!file.isDirectory()) break block5;
                File[] directoryFiles = file.listFiles();
                if (directoryFiles == null) break block6;
                for (File directoryFile : directoryFiles) {
                    this.check(directoryFile, compiler);
                }
                break block6;
            }
            if (!file.getName().endsWith(".golo")) break block6;
            try {
                if (this.verbose) {
                    System.err.println(">>> " + Messages.message("check_info", file.getAbsolutePath()));
                }
                compiler.resetExceptionBuilder();
                compiler.check(compiler.parse(file.getAbsolutePath()));
            }
            catch (IOException e) {
                Messages.error(Messages.message("file_not_found", file));
            }
            catch (GoloCompilationException e) {
                this.handleCompilationException(e, this.exit);
            }
        }
    }
}

