/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.IParameterSplitter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.compiler.GoloClassLoader;

@Parameters(resourceBundle="commands")
public class ClasspathOption {
    public static final String PROPERTY = "golo.class.path";
    public static final String ENV = "GOLOPATH";
    private static final List<String> DEFAULT = Collections.singletonList(".");
    private static final String SEP = System.getProperty("path.separator", ":");
    @Parameter(names={"--classpath"}, variableArity=true, descriptionKey="classpath", splitter=ClasspathSplitter.class)
    List<String> classpath = new LinkedList<String>();

    private static URLClassLoader primaryClassLoader(List<String> classpath) throws MalformedURLException {
        URL[] urls = new URL[classpath.size()];
        for (int i = 0; i < classpath.size(); ++i) {
            urls[i] = new File(classpath.get(i)).toURI().toURL();
        }
        return new URLClassLoader(urls);
    }

    public static GoloClassLoader initGoloClassLoader(List<String> classpath) throws MalformedURLException {
        URLClassLoader primaryClassLoader = ClasspathOption.primaryClassLoader(ClasspathOption.initClassPath(classpath));
        GoloClassLoader loader = new GoloClassLoader(primaryClassLoader);
        Thread.currentThread().setContextClassLoader(loader);
        return loader;
    }

    private static List<String> initClassPath(List<String> init) {
        List<String> classpath = init;
        if (classpath.isEmpty()) {
            classpath = ClasspathOption.getFromEnv(System.getProperty(PROPERTY));
        }
        if (classpath.isEmpty()) {
            classpath = ClasspathOption.getFromEnv(System.getenv(ENV));
        }
        if (classpath.isEmpty()) {
            classpath = DEFAULT;
        }
        System.setProperty(PROPERTY, String.join((CharSequence)SEP, classpath));
        return classpath;
    }

    private static List<String> getFromEnv(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.split(SEP));
    }

    public GoloClassLoader initGoloClassLoader() throws MalformedURLException {
        return ClasspathOption.initGoloClassLoader(this.classpath);
    }

    static /* synthetic */ String access$000() {
        return SEP;
    }

    private static class ClasspathSplitter
    implements IParameterSplitter {
        private static final String RE = String.format("[,%s]", ClasspathOption.access$000());

        private ClasspathSplitter() {
        }

        public List<String> split(String value) {
            return Arrays.asList(value.split(RE));
        }
    }
}

