/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.Messages;
import gololang.Runtime;
import gololang.Tuple;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.golo.cli.command.Metadata;

public final class Warnings {
    private static final boolean NO_PARAMETER_NAMES = Warnings.load("golo.warnings.no-parameter-names", "true");
    private static final boolean UNAVAILABLE_CLASS = Warnings.load("golo.warnings.unavailable-class", "false");
    private static final boolean DEPRECATED = Warnings.load("golo.warnings.deprecated", "true");
    private static final boolean MULTIPLE_PACKAGE_DESCRIPTION = Warnings.load("golo.warnings.doc.multiple-package-desc", "true");
    private static final HashSet<Tuple> SEEN_DEPRECATIONS = new HashSet();

    private Warnings() {
    }

    private static boolean load(String property, String def) {
        return Boolean.valueOf(System.getProperty(property, def));
    }

    public static void multiplePackageDescription(String packageName) {
        if (MULTIPLE_PACKAGE_DESCRIPTION) {
            Messages.warning(Messages.message("multiple_package_desc", packageName, Metadata.GUIDE_BASE));
        }
    }

    public static void noParameterNames(String methodName, String[] argumentNames) {
        if (NO_PARAMETER_NAMES || Runtime.debugMode()) {
            Messages.warning(Messages.message("no_parameter_names", methodName, Arrays.toString(argumentNames), Metadata.GUIDE_BASE));
        }
    }

    public static void unavailableClass(String className, String callerModule) {
        if ((UNAVAILABLE_CLASS || Runtime.debugMode()) && !className.startsWith("java.lang") && !className.startsWith("gololang")) {
            Messages.warning(Messages.message("unavailable_class", className, callerModule, Metadata.GUIDE_BASE));
        }
    }

    public static void deprecatedElement(String object, String caller) {
        Tuple seen;
        if (DEPRECATED && !SEEN_DEPRECATIONS.contains(seen = new Tuple(object, caller))) {
            SEEN_DEPRECATIONS.add(seen);
            Messages.warning(Messages.message("deprecated_element", object, caller, Metadata.GUIDE_BASE));
        }
    }
}

