/*
 * Decompiled with CFR 0.152.
 */
package com.github.peterwippermann.junit4.parameterizedsuite.util;

import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class ParentRunnerUtil {
    public static Statement withBeforeClasses(Statement statement, TestClass testClass) {
        List befores = testClass.getAnnotatedMethods(BeforeClass.class);
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, null);
    }

    public static Statement withAfterClasses(Statement statement, TestClass testClass) {
        List afters = testClass.getAnnotatedMethods(AfterClass.class);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, null);
    }

    public static Statement withClassRules(Statement statement, TestClass testClass, Description description) {
        List<TestRule> classRules = ParentRunnerUtil.getClassRules(testClass);
        return classRules.isEmpty() ? statement : new RunRules(statement, classRules, description);
    }

    public static List<TestRule> getClassRules(TestClass testClass) {
        List result = testClass.getAnnotatedMethodValues(null, ClassRule.class, TestRule.class);
        result.addAll(testClass.getAnnotatedFieldValues(null, ClassRule.class, TestRule.class));
        return result;
    }
}

