/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.greycat.lucene;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.WildcardQuery;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;
import org.eclipse.hawk.greycat.AbstractGreycatDatabase;
import org.eclipse.hawk.greycat.GreycatNode;
import org.eclipse.hawk.greycat.lucene.IntervalCollector;
import org.eclipse.hawk.greycat.lucene.ListCollector;
import org.eclipse.hawk.greycat.lucene.SoftTxLucene;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreycatLuceneIndexer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GreycatLuceneNodeIndex.class);
    private static final String ATTRIBUTE_PREFIX = "a_";
    private static final String UUID_FIELD = "h_id";
    private static final String INDEX_FIELD = "h_index";
    private static final String DOCTYPE_FIELD = "h_doctype";
    private static final String FIELDS_FIELD = "h_fields";
    private static final String INDEX_DOCTYPE = "indexdecl";
    private static final String NODEID_FIELD = "h_nodeid";
    private static final String VALIDFROM_FIELD = "h_from";
    private static final String VALIDTO_FIELD = "h_to";
    private final AbstractGreycatDatabase database;
    private final Cache<String, GreycatLuceneNodeIndex> nodeIndexCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final SoftTxLucene lucene;

    public GreycatLuceneIndexer(AbstractGreycatDatabase db, File dir) throws IOException {
        this.database = db;
        this.lucene = new SoftTxLucene(dir);
    }

    public GreycatLuceneNodeIndex getIndex(String name) throws Exception {
        return (GreycatLuceneNodeIndex)this.nodeIndexCache.get((Object)name, () -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try (SoftTxLucene.SearcherCloseable sc = this.lucene.getSearcher();){
                IndexSearcher searcher = sc.get();
                BooleanQuery query = new BooleanQuery.Builder().add((Query)new TermQuery(new Term(INDEX_FIELD, name)), BooleanClause.Occur.FILTER).add((Query)new TermQuery(new Term(DOCTYPE_FIELD, INDEX_DOCTYPE)), BooleanClause.Occur.FILTER).build();
                TotalHitCountCollector thc = new TotalHitCountCollector();
                searcher.search((Query)query, (Collector)thc);
                if (thc.getTotalHits() == 0) {
                    Document doc = new Document();
                    doc.add((IndexableField)new StringField(INDEX_FIELD, name, Field.Store.YES));
                    doc.add((IndexableField)new StringField(DOCTYPE_FIELD, INDEX_DOCTYPE, Field.Store.YES));
                    this.lucene.update(new Term(INDEX_FIELD, name), null, doc);
                }
                return new GreycatLuceneNodeIndex(name);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    public Set<String> getIndexNames() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (SoftTxLucene.SearcherCloseable sc = this.lucene.getSearcher();){
                IndexSearcher searcher = sc.get();
                ListCollector lc = new ListCollector(searcher);
                searcher.search((Query)new TermQuery(new Term(DOCTYPE_FIELD, INDEX_DOCTYPE)), (Collector)lc);
                HashSet<String> names = new HashSet<String>();
                for (Document doc : lc.getDocuments()) {
                    names.add(doc.getField(INDEX_FIELD).stringValue());
                }
                return names;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not list index name", (Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    public boolean indexExists(String name) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (SoftTxLucene.SearcherCloseable sc = this.lucene.getSearcher();){
                IndexSearcher searcher = sc.get();
                BooleanQuery query = new BooleanQuery.Builder().add((Query)new TermQuery(new Term(DOCTYPE_FIELD, INDEX_DOCTYPE)), BooleanClause.Occur.FILTER).add((Query)new TermQuery(new Term(INDEX_FIELD, name)), BooleanClause.Occur.FILTER).build();
                TotalHitCountCollector collector = new TotalHitCountCollector();
                searcher.search((Query)query, (Collector)collector);
                boolean bl = collector.getTotalHits() > 0;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not check if %s exists", name), (Throwable)e);
            return false;
        }
    }

    public void remove(GreycatNode gn) {
        try {
            BooleanQuery queryToDelete = new BooleanQuery.Builder().add(LongPoint.newExactQuery((String)NODEID_FIELD, (long)gn.getId()), BooleanClause.Occur.FILTER).add(LongPoint.newRangeQuery((String)VALIDFROM_FIELD, (long)(gn.getTime() + 1L), (long)Long.MAX_VALUE), BooleanClause.Occur.FILTER).build();
            this.lucene.delete((Query)queryToDelete);
            Query queryToRevise = this.findValidNodeDocuments(gn);
            this.invalidateAtTimepoint(gn, queryToRevise);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not remove node %s in world %d from time %d onwards", gn.getId(), gn.getWorld(), gn.getTime()), (Throwable)e);
        }
    }

    public void commit() throws IOException {
        this.lucene.commit();
    }

    public void rollback() throws IOException {
        this.lucene.rollback();
    }

    public void shutdown() {
        this.lucene.shutdown();
    }

    protected static void replaceRawField(Document document, String fieldName, Object value) {
        document.removeFields(fieldName);
        GreycatLuceneIndexer.addRawField(document, fieldName, value);
    }

    protected static void addAttributes(Document updated, Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String attributeFieldName = ATTRIBUTE_PREFIX + entry.getKey();
            GreycatLuceneIndexer.addRawField(updated, attributeFieldName, entry.getValue());
        }
    }

    protected static void addRawField(Document document, String fieldName, Object value) {
        IndexableField[] existing;
        IndexableField[] indexableFieldArray = existing = document.getFields(fieldName);
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            IndexableField f = indexableFieldArray[n2];
            if (f.numericValue() == null ? f.stringValue().equals(value) : f.numericValue().equals(value)) {
                return;
            }
            ++n2;
        }
        if (value instanceof Float || value instanceof Double) {
            double doubleValue = ((Number)value).doubleValue();
            document.add((IndexableField)new DoublePoint(fieldName, new double[]{doubleValue}));
            document.add((IndexableField)new StoredField(fieldName, doubleValue));
        } else if (value instanceof Number) {
            long longValue = ((Number)value).longValue();
            if (document.getFields(fieldName).length == 0) {
                document.add((IndexableField)new NumericDocValuesField(fieldName, longValue));
            }
            document.add((IndexableField)new LongPoint(fieldName, new long[]{longValue}));
            document.add((IndexableField)new StoredField(fieldName, longValue));
        } else {
            document.add((IndexableField)new StringField(fieldName, value.toString(), Field.Store.YES));
        }
        if (fieldName.startsWith(ATTRIBUTE_PREFIX)) {
            document.add((IndexableField)new StringField(FIELDS_FIELD, fieldName.substring(ATTRIBUTE_PREFIX.length()), Field.Store.YES));
        }
    }

    protected static Document copy(Document doc) {
        if (doc == null) {
            return null;
        }
        Document newDoc = new Document();
        for (IndexableField f : doc.getFields()) {
            GreycatLuceneIndexer.copyField(f, newDoc);
        }
        return newDoc;
    }

    protected static void copyField(IndexableField field, Document copy) {
        if (!FIELDS_FIELD.equals(field.name())) {
            if (field.numericValue() instanceof Number) {
                GreycatLuceneIndexer.addRawField(copy, field.name(), field.numericValue());
            } else {
                GreycatLuceneIndexer.addRawField(copy, field.name(), field.stringValue());
            }
        }
    }

    protected GreycatNode getNodeByDocumentAt(Document document, Long timepoint) {
        long id = document.getField(NODEID_FIELD).numericValue().longValue();
        return this.database.getNodeByIdAt(id, timepoint);
    }

    protected Query findValidNodeDocuments(GreycatNode gn) {
        return new BooleanQuery.Builder().add(LongPoint.newExactQuery((String)NODEID_FIELD, (long)gn.getId()), BooleanClause.Occur.FILTER).add(this.findValidDocumentsAtTimepoint(gn.getTime()), BooleanClause.Occur.FILTER).build();
    }

    protected Query findValidDocumentsAtTimepoint(long time) {
        return new BooleanQuery.Builder().add(LongPoint.newRangeQuery((String)VALIDFROM_FIELD, (long)Long.MIN_VALUE, (long)time), BooleanClause.Occur.FILTER).add(LongPoint.newRangeQuery((String)VALIDTO_FIELD, (long)time, (long)Long.MAX_VALUE), BooleanClause.Occur.FILTER).build();
    }

    protected void invalidateAtTimepoint(GreycatNode gn, Query queryToRevise) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (SoftTxLucene.SearcherCloseable sc = this.lucene.getSearcher();){
            IndexSearcher searcher = sc.get();
            ListCollector lc = new ListCollector(searcher);
            searcher.search(queryToRevise, (Collector)lc);
            for (Document doc : lc.getDocuments()) {
                this.invalidateAtTimepoint(gn, doc);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void invalidateAtTimepoint(GreycatNode gn, Document doc) throws IOException {
        long lFrom = doc.getField(VALIDFROM_FIELD).numericValue().longValue();
        if (lFrom == gn.getTime()) {
            this.lucene.delete(new Term(UUID_FIELD, doc.get(UUID_FIELD)));
        } else {
            Document revisedDoc = GreycatLuceneIndexer.copy(doc);
            GreycatLuceneIndexer.replaceRawField(revisedDoc, VALIDTO_FIELD, gn.getTime() - 1L);
            this.lucene.update(new Term(UUID_FIELD, doc.get(UUID_FIELD)), doc, revisedDoc);
        }
    }

    public final class GreycatLuceneNodeIndex
    implements ITimeAwareGraphNodeIndex {
        private final String name;
        private final Long timepoint;
        private static final String NODE_DOCTYPE = "node";

        public GreycatLuceneNodeIndex(String name) {
            this(name, null);
        }

        public GreycatLuceneNodeIndex(String name, Long timepoint) {
            this.name = name;
            this.timepoint = timepoint;
        }

        public void remove(IGraphNode n, String key, Object value) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (SoftTxLucene.SearcherCloseable sc = GreycatLuceneIndexer.this.lucene.getSearcher();){
                    IndexSearcher searcher = sc.get();
                    GreycatNode gn = (GreycatNode)n;
                    BooleanQuery.Builder queryBuilder = this.getIndexQueryBuilder().add(LongPoint.newExactQuery((String)GreycatLuceneIndexer.NODEID_FIELD, (long)gn.getId()), BooleanClause.Occur.FILTER).add(LongPoint.newRangeQuery((String)GreycatLuceneIndexer.VALIDTO_FIELD, (long)gn.getTime(), (long)Long.MAX_VALUE), BooleanClause.Occur.FILTER);
                    if (key != null && value != null) {
                        queryBuilder.add(this.getValueQuery(key, value), BooleanClause.Occur.FILTER);
                    }
                    BooleanQuery query = queryBuilder.build();
                    ListCollector collector = new ListCollector(searcher);
                    searcher.search((Query)query, (Collector)collector);
                    if (key == null) {
                        for (Document doc : collector.getDocuments()) {
                            this.removeValue(doc, gn, value);
                        }
                    } else {
                        for (Document doc : collector.getDocuments()) {
                            this.removeKeyValue(doc, gn, key, value);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Could not remove node from index", (Throwable)e);
            }
        }

        protected void removeKeyValue(Document oldDocument, GreycatNode gn, String key, Object value) throws IOException {
            Document updated = new Document();
            boolean anyMatched = false;
            for (IndexableField field : oldDocument.getFields()) {
                boolean matched = false;
                if (field.name().equals(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + key)) {
                    if (value == null) {
                        matched = true;
                    } else if (value instanceof Float) {
                        float fValue = field.numericValue() == null ? Float.valueOf(field.stringValue()).floatValue() : field.numericValue().floatValue();
                        matched = fValue == ((Float)value).floatValue();
                    } else if (value instanceof Double) {
                        double fValue = field.numericValue() == null ? Double.valueOf(field.stringValue()).doubleValue() : field.numericValue().doubleValue();
                        matched = fValue == (Double)value;
                    } else if (value instanceof Number) {
                        Long fValue = field.numericValue() == null ? Long.valueOf(field.stringValue()).longValue() : field.numericValue().longValue();
                        matched = ((Number)value).longValue() == fValue.longValue();
                    } else if (value.equals(field.stringValue())) {
                        matched = true;
                    }
                }
                if (!matched) {
                    GreycatLuceneIndexer.copyField(field, updated);
                }
                boolean bl = anyMatched = anyMatched || matched;
            }
            if (anyMatched) {
                this.replaceDocumentAtTimepoint(gn, oldDocument, updated);
            }
        }

        private void replaceDocumentAtTimepoint(GreycatNode gn, Document oldDocument, Document newDocument) throws IOException {
            assert (oldDocument != null) : "Old document should not be null";
            assert (newDocument != null) : "New document should not be null";
            assert (newDocument.getField(GreycatLuceneIndexer.VALIDFROM_FIELD) != null) : "New document should have a starting point";
            assert (newDocument.getField(GreycatLuceneIndexer.VALIDTO_FIELD) != null) : "New document should have an ending point";
            assert (oldDocument.getField(GreycatLuceneIndexer.UUID_FIELD).stringValue().equals(newDocument.getField(GreycatLuceneIndexer.UUID_FIELD).stringValue())) : "Both documents should have same UUID";
            long lOldFrom = oldDocument.getField(GreycatLuceneIndexer.VALIDFROM_FIELD).numericValue().longValue();
            long lOldTo = oldDocument.getField(GreycatLuceneIndexer.VALIDTO_FIELD).numericValue().longValue();
            if (gn.getTime() >= lOldFrom && gn.getTime() <= lOldTo) {
                long lOldNewTo = gn.getTime() - 1L;
                if (lOldNewTo < lOldFrom) {
                    this.updateOrDelete(oldDocument, newDocument);
                } else {
                    Document shortenedDoc = GreycatLuceneIndexer.copy(oldDocument);
                    GreycatLuceneIndexer.replaceRawField(shortenedDoc, GreycatLuceneIndexer.VALIDTO_FIELD, lOldNewTo);
                    GreycatLuceneIndexer.this.lucene.update(new Term(GreycatLuceneIndexer.UUID_FIELD, oldDocument.get(GreycatLuceneIndexer.UUID_FIELD)), oldDocument, shortenedDoc);
                    if (newDocument.getField(GreycatLuceneIndexer.FIELDS_FIELD) != null) {
                        String newUUID = UUID.randomUUID().toString();
                        GreycatLuceneIndexer.replaceRawField(newDocument, GreycatLuceneIndexer.UUID_FIELD, newUUID);
                        GreycatLuceneIndexer.replaceRawField(newDocument, GreycatLuceneIndexer.VALIDFROM_FIELD, gn.getTime());
                        GreycatLuceneIndexer.this.lucene.update(new Term(GreycatLuceneIndexer.UUID_FIELD, newUUID), null, newDocument);
                    }
                }
            } else {
                this.updateOrDelete(oldDocument, newDocument);
            }
        }

        private void updateOrDelete(Document oldDocument, Document newDocument) throws IOException {
            if (newDocument.getField(GreycatLuceneIndexer.FIELDS_FIELD) == null) {
                GreycatLuceneIndexer.this.lucene.delete(new Term(GreycatLuceneIndexer.UUID_FIELD, oldDocument.get(GreycatLuceneIndexer.UUID_FIELD)));
            } else {
                GreycatLuceneIndexer.this.lucene.update(new Term(GreycatLuceneIndexer.UUID_FIELD, oldDocument.get(GreycatLuceneIndexer.UUID_FIELD)), oldDocument, newDocument);
            }
        }

        protected void removeValue(Document oldDocument, GreycatNode gn, Object value) throws IOException {
            Document updated = new Document();
            boolean matched = false;
            for (IndexableField field : oldDocument.getFields()) {
                if (field.name().startsWith(GreycatLuceneIndexer.ATTRIBUTE_PREFIX)) {
                    String existingValue = field.stringValue();
                    if (value == null || existingValue.equals(value)) {
                        matched = true;
                        continue;
                    }
                    GreycatLuceneIndexer.copyField(field, updated);
                    continue;
                }
                GreycatLuceneIndexer.copyField(field, updated);
            }
            if (matched) {
                this.replaceDocumentAtTimepoint(gn, oldDocument, updated);
            }
        }

        public void remove(IGraphNode n) {
            try {
                GreycatNode gn = (GreycatNode)n;
                BooleanQuery queryToDelete = this.getIndexQueryBuilder().add(this.findNodeQuery(gn), BooleanClause.Occur.FILTER).add(LongPoint.newRangeQuery((String)GreycatLuceneIndexer.VALIDFROM_FIELD, (long)(gn.getTime() + 1L), (long)Long.MAX_VALUE), BooleanClause.Occur.FILTER).build();
                GreycatLuceneIndexer.this.lucene.delete((Query)queryToDelete);
                BooleanQuery queryToInvalidate = this.getIndexQueryBuilder().add(GreycatLuceneIndexer.this.findValidNodeDocuments(gn), BooleanClause.Occur.FILTER).build();
                GreycatLuceneIndexer.this.invalidateAtTimepoint(gn, (Query)queryToInvalidate);
            }
            catch (IOException e) {
                LOGGER.error(String.format("Could not remove node with id %d from index %s", n.getId(), this.name), (Throwable)e);
            }
        }

        public IGraphIterable<GreycatNode> query(String key, Number from, Number to, boolean fromInclusive, boolean toInclusive) {
            Query query;
            if (from instanceof Float || to instanceof Double) {
                double dFrom = from.doubleValue();
                double dTo = to.doubleValue();
                query = DoublePoint.newRangeQuery((String)(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + key), (double)(fromInclusive ? dFrom : DoublePoint.nextUp((double)dFrom)), (double)(toInclusive ? dTo : DoublePoint.nextDown((double)dTo)));
            } else {
                long lFrom = from.longValue();
                long lTo = to.longValue();
                query = LongPoint.newRangeQuery((String)(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + key), (long)(fromInclusive ? lFrom : Math.addExact(lFrom, 1L)), (long)(toInclusive ? lTo : Math.addExact(lTo, -1L)));
            }
            query = this.getIndexQueryBuilder().add(query, BooleanClause.Occur.FILTER).add(GreycatLuceneIndexer.this.findValidDocumentsAtTimepoint(this.getTimepoint()), BooleanClause.Occur.FILTER).build();
            return new LuceneGraphIterable(query, this.timepoint);
        }

        public int countAll() {
            return this.countAll((Query)this.getIndexQueryBuilder().build());
        }

        private int countAll(Query query) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (SoftTxLucene.SearcherCloseable sc = GreycatLuceneIndexer.this.lucene.getSearcher();){
                    IndexSearcher searcher = sc.get();
                    TotalHitCountCollector collector = new TotalHitCountCollector();
                    searcher.search(query, (Collector)collector);
                    return collector.getTotalHits();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to obtain size", (Throwable)e);
                return 0;
            }
        }

        public IGraphIterable<GreycatNode> query(String key, Object valueExpr) {
            String sValueExpr = valueExpr.toString();
            TermQuery valueQuery = null;
            if ("*".equals(key)) {
                if (!"*".equals(valueExpr)) {
                    throw new UnsupportedOperationException("*:non-null not implemented yet for query");
                }
            } else if ("*".equals(valueExpr)) {
                valueQuery = new TermQuery(new Term(GreycatLuceneIndexer.FIELDS_FIELD, key));
            } else if (valueExpr instanceof Float || valueExpr instanceof Double) {
                valueQuery = DoublePoint.newExactQuery((String)(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + key), (double)((Number)valueExpr).doubleValue());
            } else if (valueExpr instanceof Number) {
                valueQuery = LongPoint.newExactQuery((String)(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + key), (long)((Number)valueExpr).longValue());
            } else {
                int starIdx = sValueExpr.indexOf(42);
                if (starIdx == -1) {
                    valueQuery = new TermQuery(new Term(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + key, sValueExpr));
                } else if (starIdx > 0 && starIdx == sValueExpr.length() - 1) {
                    String prefix = sValueExpr.substring(0, sValueExpr.length() - 1);
                    valueQuery = new PrefixQuery(new Term(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + key, prefix));
                } else {
                    valueQuery = new WildcardQuery(new Term(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + key, sValueExpr));
                }
            }
            BooleanQuery.Builder builder = this.getIndexQueryBuilder().add(GreycatLuceneIndexer.this.findValidDocumentsAtTimepoint(this.getTimepoint()), BooleanClause.Occur.FILTER);
            if (valueQuery != null) {
                builder.add((Query)valueQuery, BooleanClause.Occur.FILTER);
            }
            BooleanQuery query = builder.build();
            return new LuceneGraphIterable((Query)query, this.timepoint);
        }

        public String getName() {
            return this.name;
        }

        public IGraphIterable<GreycatNode> get(String key, Object valueExpr) {
            Query valueQuery = this.getValueQuery(key, valueExpr);
            BooleanQuery query = this.getIndexQueryBuilder().add(valueQuery, BooleanClause.Occur.FILTER).add(GreycatLuceneIndexer.this.findValidDocumentsAtTimepoint(this.getTimepoint()), BooleanClause.Occur.FILTER).build();
            return new LuceneGraphIterable((Query)query, this.timepoint);
        }

        public List<Long> getVersions(ITimeAwareGraphNode gn, String key, Object valueExpr, long startTimepointIncluded) {
            Query valueQuery = this.getValueQuery(key, valueExpr);
            BooleanQuery query = this.getIndexQueryBuilder().add(valueQuery, BooleanClause.Occur.FILTER).add(LongPoint.newRangeQuery((String)GreycatLuceneIndexer.VALIDTO_FIELD, (long)startTimepointIncluded, (long)Long.MAX_VALUE), BooleanClause.Occur.FILTER).add(LongPoint.newExactQuery((String)GreycatLuceneIndexer.NODEID_FIELD, (long)((Long)gn.getId())), BooleanClause.Occur.FILTER).build();
            try {
                Throwable throwable = null;
                Object var9_10 = null;
                try (SoftTxLucene.SearcherCloseable sc = GreycatLuceneIndexer.this.lucene.getSearcher();){
                    IndexSearcher searcher = sc.get();
                    IntervalCollector<Long> fc = new IntervalCollector<Long>(searcher, GreycatLuceneIndexer.VALIDFROM_FIELD, GreycatLuceneIndexer.VALIDTO_FIELD, f -> f.numericValue().longValue());
                    searcher.search((Query)query, fc);
                    List<IntervalCollector.Interval<Long>> intervals = fc.getValues();
                    Collections.sort(intervals, (a, b) -> -Long.compare((Long)a.getFrom(), (Long)b.getFrom()));
                    ArrayList<Long> timepoints = new ArrayList<Long>();
                    for (IntervalCollector.Interval<Long> interval : intervals) {
                        List intervalTimepoints = gn.getInstantsBetween(interval.getFrom().longValue(), interval.getTo().longValue());
                        timepoints.addAll(intervalTimepoints);
                    }
                    return timepoints;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to obtain result", (Throwable)e);
                return Collections.emptyList();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Long getEarliestVersionSince(ITimeAwareGraphNode gn, String key, Object valueExpr) {
            Query valueQuery = this.getValueQuery(key, valueExpr);
            BooleanQuery query = this.getIndexQueryBuilder().add(valueQuery, BooleanClause.Occur.FILTER).add(LongPoint.newExactQuery((String)GreycatLuceneIndexer.NODEID_FIELD, (long)((Long)gn.getId())), BooleanClause.Occur.FILTER).add(LongPoint.newRangeQuery((String)GreycatLuceneIndexer.VALIDFROM_FIELD, (long)gn.getTime(), (long)Long.MAX_VALUE), BooleanClause.Occur.FILTER).build();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (SoftTxLucene.SearcherCloseable sc = GreycatLuceneIndexer.this.lucene.getSearcher();){
                    long to;
                    IndexSearcher searcher = sc.get();
                    Sort sort = new Sort((SortField)new SortedNumericSortField(GreycatLuceneIndexer.VALIDFROM_FIELD, SortField.Type.LONG));
                    ScoreDoc[] hits = searcher.search((Query)query, (int)1, (Sort)sort).scoreDocs;
                    if (hits.length == 0) {
                        return null;
                    }
                    Document doc = searcher.doc(hits[0].doc);
                    long from = doc.getField(GreycatLuceneIndexer.VALIDFROM_FIELD).numericValue().longValue();
                    List versions = gn.getInstantsBetween(from, to = doc.getField(GreycatLuceneIndexer.VALIDTO_FIELD).numericValue().longValue());
                    if (!versions.isEmpty()) return (Long)versions.get(versions.size() - 1);
                    return null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to obtain result", (Throwable)e);
                return null;
            }
        }

        private Query getValueQuery(String key, Object valueExpr) {
            Query valueQuery;
            if (valueExpr instanceof Float || valueExpr instanceof Double) {
                valueQuery = DoublePoint.newExactQuery((String)(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + key), (double)((Number)valueExpr).doubleValue());
            } else if (valueExpr instanceof Number) {
                valueQuery = LongPoint.newExactQuery((String)(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + key), (long)((Number)valueExpr).longValue());
            } else {
                Term term = new Term(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + key, valueExpr.toString());
                valueQuery = new TermQuery(term);
            }
            return valueQuery;
        }

        public void flush() {
            GreycatLuceneIndexer.this.lucene.flush();
        }

        public void delete() {
            try {
                GreycatLuceneIndexer.this.lucene.delete((Query)new TermQuery(new Term(GreycatLuceneIndexer.INDEX_FIELD, this.name)));
                GreycatLuceneIndexer.this.nodeIndexCache.invalidate((Object)this.name);
            }
            catch (IOException e) {
                LOGGER.error("Could not delete index " + this.name, (Throwable)e);
            }
        }

        public void add(IGraphNode n, String key, Object value) {
            if (value != null) {
                this.add(n, Collections.singletonMap(key, value));
            }
        }

        public void add(IGraphNode n, Map<String, Object> values) {
            if (values == null) {
                return;
            }
            GreycatNode gn = (GreycatNode)n;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (SoftTxLucene.SearcherCloseable sc = GreycatLuceneIndexer.this.lucene.getSearcher();){
                    IndexSearcher searcher = sc.get();
                    BooleanQuery latestVersionQuery = this.getIndexQueryBuilder().add(this.findNodeQuery(gn), BooleanClause.Occur.FILTER).add(GreycatLuceneIndexer.this.findValidDocumentsAtTimepoint(gn.getTime()), BooleanClause.Occur.FILTER).build();
                    TopDocs results = searcher.search((Query)latestVersionQuery, 1);
                    Long validTo = null;
                    if (results.totalHits > 0L) {
                        Document oldDocument = searcher.doc(results.scoreDocs[0].doc);
                        if (this.differenceFound(oldDocument, values)) {
                            validTo = this.extendCurrentDocument(gn, values, searcher, results);
                        }
                    } else {
                        validTo = this.addNewDocument(gn, values, searcher);
                    }
                    if (validTo != null && validTo < Long.MAX_VALUE) {
                        this.extendFutureDocuments(gn, values, searcher, validTo);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }

        private boolean differenceFound(Document oldDocument, Map<String, Object> values) {
            for (Map.Entry<String, Object> e : values.entrySet()) {
                boolean matched = false;
                IndexableField[] indexableFieldArray = oldDocument.getFields(GreycatLuceneIndexer.ATTRIBUTE_PREFIX + e.getKey());
                int n = indexableFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IndexableField f = indexableFieldArray[n2];
                    matched = f.numericValue() == null ? matched || f.stringValue().equals(e.getValue()) : matched || f.numericValue().equals(e.getValue());
                    ++n2;
                }
                if (matched) continue;
                return true;
            }
            return false;
        }

        private void extendFutureDocuments(GreycatNode gn, Map<String, Object> values, IndexSearcher searcher, long validTo) throws IOException {
            BooleanQuery allFutureQuery = this.getIndexQueryBuilder().add(this.findNodeQuery(gn), BooleanClause.Occur.FILTER).add(LongPoint.newRangeQuery((String)GreycatLuceneIndexer.VALIDFROM_FIELD, (long)(validTo + 1L), (long)Long.MAX_VALUE), BooleanClause.Occur.FILTER).build();
            ListCollector lc = new ListCollector(searcher);
            searcher.search((Query)allFutureQuery, (Collector)lc);
            for (Document doc : lc.getDocuments()) {
                Document updatedFuture = GreycatLuceneIndexer.copy(doc);
                GreycatLuceneIndexer.addAttributes(updatedFuture, values);
                String uuid = updatedFuture.getField(GreycatLuceneIndexer.UUID_FIELD).stringValue();
                GreycatLuceneIndexer.this.lucene.update(new Term(GreycatLuceneIndexer.UUID_FIELD, uuid), doc, updatedFuture);
            }
        }

        private long addNewDocument(GreycatNode gn, Map<String, Object> values, IndexSearcher searcher) throws IOException {
            long validTo = this.computeValidToForNewDocument(gn, searcher);
            return this.addNewDocument(gn, values, validTo);
        }

        private long addNewDocument(GreycatNode gn, Map<String, Object> values, long validTo) throws IOException {
            String uuid = UUID.randomUUID().toString();
            Document newDocument = new Document();
            GreycatLuceneIndexer.addRawField(newDocument, GreycatLuceneIndexer.NODEID_FIELD, gn.getId());
            GreycatLuceneIndexer.addRawField(newDocument, GreycatLuceneIndexer.DOCTYPE_FIELD, NODE_DOCTYPE);
            GreycatLuceneIndexer.addRawField(newDocument, GreycatLuceneIndexer.INDEX_FIELD, this.name);
            GreycatLuceneIndexer.addRawField(newDocument, GreycatLuceneIndexer.UUID_FIELD, uuid);
            GreycatLuceneIndexer.addRawField(newDocument, GreycatLuceneIndexer.VALIDFROM_FIELD, gn.getTime());
            GreycatLuceneIndexer.addRawField(newDocument, GreycatLuceneIndexer.VALIDTO_FIELD, validTo);
            GreycatLuceneIndexer.addAttributes(newDocument, values);
            GreycatLuceneIndexer.this.lucene.update(new Term(GreycatLuceneIndexer.UUID_FIELD, uuid), null, newDocument);
            return validTo;
        }

        private long extendCurrentDocument(GreycatNode gn, Map<String, Object> values, IndexSearcher searcher, TopDocs results) throws IOException {
            Document oldDocument = searcher.doc(results.scoreDocs[0].doc);
            Document updatedDocument = new Document();
            GreycatLuceneIndexer.addRawField(updatedDocument, GreycatLuceneIndexer.NODEID_FIELD, gn.getId());
            GreycatLuceneIndexer.addRawField(updatedDocument, GreycatLuceneIndexer.DOCTYPE_FIELD, NODE_DOCTYPE);
            GreycatLuceneIndexer.addRawField(updatedDocument, GreycatLuceneIndexer.INDEX_FIELD, this.name);
            GreycatLuceneIndexer.addRawField(updatedDocument, GreycatLuceneIndexer.VALIDFROM_FIELD, gn.getTime());
            for (IndexableField oldField : oldDocument.getFields()) {
                String rawOldFieldName = oldField.name();
                if (!rawOldFieldName.startsWith(GreycatLuceneIndexer.ATTRIBUTE_PREFIX) && !rawOldFieldName.equals(GreycatLuceneIndexer.UUID_FIELD) && !rawOldFieldName.equals(GreycatLuceneIndexer.VALIDTO_FIELD)) continue;
                GreycatLuceneIndexer.copyField(oldField, updatedDocument);
            }
            GreycatLuceneIndexer.addAttributes(updatedDocument, values);
            this.replaceDocumentAtTimepoint(gn, oldDocument, updatedDocument);
            long validTo = updatedDocument.getField(GreycatLuceneIndexer.VALIDTO_FIELD).numericValue().longValue();
            return validTo;
        }

        private long computeValidToForNewDocument(GreycatNode gn, IndexSearcher searcher) throws IOException {
            BooleanQuery afterStartQuery = this.getIndexQueryBuilder().add(this.findNodeQuery(gn), BooleanClause.Occur.FILTER).add(LongPoint.newRangeQuery((String)GreycatLuceneIndexer.VALIDFROM_FIELD, (long)(gn.getTime() + 1L), (long)Long.MAX_VALUE), BooleanClause.Occur.FILTER).build();
            ListCollector lc = new ListCollector(searcher);
            searcher.search((Query)afterStartQuery, (Collector)lc);
            Long minFrom = null;
            for (Document dAfterStart : lc.getDocuments()) {
                long from = dAfterStart.getField(GreycatLuceneIndexer.VALIDFROM_FIELD).numericValue().longValue();
                minFrom = minFrom == null ? Long.valueOf(from) : Long.valueOf(Math.min(from, minFrom));
            }
            return minFrom == null ? Long.MAX_VALUE : minFrom - 1L;
        }

        public GreycatLuceneNodeIndex travelInTime(long timepoint) {
            return new GreycatLuceneNodeIndex(this.name, timepoint);
        }

        private long getTimepoint() {
            if (this.timepoint == null) {
                return GreycatLuceneIndexer.this.database.getTime();
            }
            return this.timepoint;
        }

        protected Query findNodeQuery(GreycatNode n) {
            return LongPoint.newExactQuery((String)GreycatLuceneIndexer.NODEID_FIELD, (long)n.getId());
        }

        protected BooleanQuery.Builder getIndexQueryBuilder() {
            return new BooleanQuery.Builder().add((Query)new TermQuery(new Term(GreycatLuceneIndexer.INDEX_FIELD, this.name)), BooleanClause.Occur.FILTER).add((Query)new TermQuery(new Term(GreycatLuceneIndexer.DOCTYPE_FIELD, NODE_DOCTYPE)), BooleanClause.Occur.FILTER);
        }

        public void annotate(IGraphNode n, String name) {
            try {
                GreycatNode gn = (GreycatNode)n;
                this.addNewDocument(gn, Collections.singletonMap(name, true), gn.getTime());
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected final class LuceneGraphIterable
    implements IGraphIterable<GreycatNode> {
        private final Query query;
        private final Long timepoint;

        protected LuceneGraphIterable(Query query, Long timepoint) {
            this.query = query;
            this.timepoint = timepoint;
        }

        public Iterator<GreycatNode> iterator() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (SoftTxLucene.SearcherCloseable sc = GreycatLuceneIndexer.this.lucene.getSearcher();){
                    IndexSearcher searcher = sc.get();
                    NodeListCollector lc = new NodeListCollector(searcher, this.timepoint);
                    searcher.search(this.query, (Collector)lc);
                    return lc.getNodeIterator();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to obtain result", (Throwable)e);
                return Collections.emptyIterator();
            }
        }

        public int size() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (SoftTxLucene.SearcherCloseable sc = GreycatLuceneIndexer.this.lucene.getSearcher();){
                    IndexSearcher searcher = sc.get();
                    TotalHitCountCollector collector = new TotalHitCountCollector();
                    searcher.search(this.query, (Collector)collector);
                    return collector.getTotalHits();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to obtain size", (Throwable)e);
                return 0;
            }
        }

        public GreycatNode getSingle() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (SoftTxLucene.SearcherCloseable sc = GreycatLuceneIndexer.this.lucene.getSearcher();){
                    IndexSearcher searcher = sc.get();
                    TopDocs results = searcher.search(this.query, 1);
                    if (results.totalHits > 0L) {
                        Document document = searcher.doc(results.scoreDocs[0].doc);
                        GreycatNode node = GreycatLuceneIndexer.this.getNodeByDocumentAt(document, this.timepoint);
                        return node;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to obtain single result", (Throwable)e);
            }
            throw new NoSuchElementException();
        }
    }

    protected class MatchExistsCollector
    extends SimpleCollector {
        private boolean matchFound = false;

        protected MatchExistsCollector() {
        }

        public boolean needsScores() {
            return false;
        }

        public void collect(int doc) throws IOException {
            this.matchFound = true;
            throw new CollectionTerminatedException();
        }

        public boolean isMatchFound() {
            return this.matchFound;
        }
    }

    protected final class NodeListCollector
    extends ListCollector {
        private final Long timepoint;

        protected NodeListCollector(IndexSearcher searcher, Long timepoint) {
            super(searcher);
            this.timepoint = timepoint;
        }

        public Iterator<GreycatNode> getNodeIterator() throws IOException {
            List<Document> docs = this.getDocuments();
            final Iterator<Document> itDocs = docs.iterator();
            return new Iterator<GreycatNode>(){

                @Override
                public boolean hasNext() {
                    return itDocs.hasNext();
                }

                @Override
                public GreycatNode next() {
                    Document document = (Document)itDocs.next();
                    return GreycatLuceneIndexer.this.getNodeByDocumentAt(document, NodeListCollector.this.timepoint);
                }
            };
        }
    }
}

