/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.greycat.tests;

import java.util.Collections;
import org.eclipse.hawk.backend.tests.TemporaryDatabaseTest;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphDatabase;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.greycat.lucene.GreycatLuceneIndexer;
import org.eclipse.hawk.greycat.tests.LevelDBGreycatDatabaseFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GreycatLuceneTestSuite
extends TemporaryDatabaseTest {
    private ITimeAwareGraphDatabase tadb;
    private ITimeAwareGraphNode n;

    @Parameterized.Parameters(name="{0}")
    public static Object[][] params() {
        return new Object[][]{{new LevelDBGreycatDatabaseFactory()}};
    }

    public GreycatLuceneTestSuite(IGraphDatabaseFactory dbf) {
        super(dbf);
    }

    @Before
    public void setup() throws Exception {
        super.setup();
        this.tadb = (ITimeAwareGraphDatabase)this.db;
        Throwable throwable = null;
        Object var2_3 = null;
        try (IGraphTransaction tx = this.tadb.beginTransaction();){
            this.n = this.tadb.createNode(Collections.emptyMap(), "testnodes");
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void addRemoveNode() throws Exception {
        IGraphTransaction tx;
        GreycatLuceneIndexer.GreycatLuceneNodeIndex idx = (GreycatLuceneIndexer.GreycatLuceneNodeIndex)this.tadb.getOrCreateNodeIndex("test");
        Throwable throwable = null;
        Object var3_6 = null;
        try {
            tx = this.tadb.beginTransaction();
            try {
                idx.add((IGraphNode)this.n, "x", (Object)1);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            tx = this.tadb.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)idx.query("x", (Object)1).size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            tx = this.tadb.beginTransaction();
            try {
                idx.remove((IGraphNode)this.n);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        Assert.assertEquals((long)0L, (long)idx.countAll());
    }

    @Test
    public void addRemoveNodeValue() throws Exception {
        IGraphTransaction tx;
        GreycatLuceneIndexer.GreycatLuceneNodeIndex idx = (GreycatLuceneIndexer.GreycatLuceneNodeIndex)this.tadb.getOrCreateNodeIndex("test");
        Throwable throwable = null;
        Object var3_6 = null;
        try {
            tx = this.tadb.beginTransaction();
            try {
                idx.add((IGraphNode)this.n, "x", (Object)1);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            tx = this.tadb.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)idx.query("x", (Object)1).size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            tx = this.tadb.beginTransaction();
            try {
                idx.remove((IGraphNode)this.n, "x", (Object)1);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        Assert.assertEquals((long)0L, (long)idx.countAll());
    }
}

