/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph;

public class ProxyReferenceTarget {
    private final String repoURL;
    private final String filePath;
    private final String fragment;

    public ProxyReferenceTarget(String uri, boolean ignoreFragment) {
        String uriWithoutFragment;
        int hashPos = uri.indexOf("#");
        if (hashPos == -1) {
            uriWithoutFragment = uri;
            this.fragment = null;
        } else {
            uriWithoutFragment = uri.substring(0, hashPos);
            this.fragment = ignoreFragment ? null : uri.substring(hashPos + 1);
        }
        int repoSeparatorPos = uriWithoutFragment.indexOf("||||");
        this.repoURL = uriWithoutFragment.substring(0, repoSeparatorPos);
        this.filePath = uriWithoutFragment.substring(repoSeparatorPos + "||||".length());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
        result = 31 * result + (this.repoURL == null ? 0 : this.repoURL.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProxyReferenceTarget other = (ProxyReferenceTarget)obj;
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment)) {
            return false;
        }
        return !(this.repoURL == null ? other.repoURL != null : !this.repoURL.equals(other.repoURL));
    }

    public String getRepositoryURL() {
        return this.repoURL;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getFileURI() {
        return String.valueOf(this.repoURL) + "||||" + this.filePath;
    }

    public String getElementURI() {
        if (this.fragment == null) {
            throw new IllegalStateException("Cannot provide element URI if fragment is null");
        }
        return String.valueOf(this.getFileURI()) + "#" + this.fragment;
    }

    public boolean isFragmentBased() {
        return this.filePath.equals("*");
    }

    public String toString() {
        return "ProxyReferenceTarget [repoURL=" + this.repoURL + ", filePath=" + this.filePath + ", fragment=" + this.fragment + "]";
    }
}

