/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.svn.tests.rules;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.rules.ExternalResource;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnLog;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnScheduleForAddition;
import org.tmatesoft.svn.core.wc2.SvnScheduleForRemoval;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUpdate;
import org.tmatesoft.svn.core.wc2.admin.SvnRepositoryCreate;

public class TemporarySVNRepository
extends ExternalResource {
    private File fSvnRepoDir;
    private File fSvnCheckoutDir;
    private SvnOperationFactory svnOperationFactory;
    private SVNClientManager svnClientManager;
    private SVNRepository svnRepository;
    private SVNURL svnRepoURL;

    public File getRepositoryDirectory() {
        return this.fSvnRepoDir;
    }

    public File getCheckoutDirectory() {
        return this.fSvnCheckoutDir;
    }

    public SVNRepository getRepository() {
        return this.svnRepository;
    }

    public SVNURL getRepositoryURL() {
        return this.svnRepoURL;
    }

    public Path write(String text, String firstPathComponent, String ... otherComponents) throws IOException {
        return this.write(new ByteArrayInputStream(text.getBytes()), Paths.get(firstPathComponent, otherComponents));
    }

    public Path write(InputStream is, String firstPathComponent, String ... otherComponents) throws IOException {
        return this.write(is, Paths.get(firstPathComponent, otherComponents));
    }

    public Path write(InputStream is, Path pathWithinWC) throws IOException {
        Path destinationPath = this.fSvnCheckoutDir.toPath().resolve(pathWithinWC);
        Files.copy(is, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        return destinationPath;
    }

    public void add(File ... files) throws SVNException {
        SvnScheduleForAddition svnAdd = this.svnOperationFactory.createScheduleForAddition();
        svnAdd.setAddParents(true);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            svnAdd.addTarget(SvnTarget.fromFile((File)f));
            ++n2;
        }
        svnAdd.run();
    }

    public void remove(File ... files) throws SVNException {
        SvnScheduleForRemoval svnRm = this.svnOperationFactory.createScheduleForRemoval();
        svnRm.setDeleteFiles(true);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            svnRm.addTarget(SvnTarget.fromFile((File)f));
            ++n2;
        }
        svnRm.run();
    }

    public SVNCommitInfo commit(String msg) throws SVNException {
        SvnTarget svnTarget = SvnTarget.fromFile((File)this.fSvnCheckoutDir);
        SvnCommit svnCommit = this.svnOperationFactory.createCommit();
        svnCommit.setSingleTarget(svnTarget);
        svnCommit.setCommitMessage(msg);
        SVNCommitInfo ciInfo = svnCommit.run();
        SvnUpdate svnUp = this.svnOperationFactory.createUpdate();
        svnUp.setSingleTarget(svnTarget);
        svnUp.run();
        return ciInfo;
    }

    public List<SVNLogEntry> log(long from, long to) throws SVNException {
        SvnRevisionRange svnRevisionRange = SvnRevisionRange.create((SVNRevision)SVNRevision.create((long)from), (SVNRevision)SVNRevision.create((long)to));
        SvnLog svnLog = this.svnOperationFactory.createLog();
        svnLog.setRevisionRanges(Collections.singleton(svnRevisionRange));
        svnLog.setSingleTarget(SvnTarget.fromFile((File)this.fSvnCheckoutDir));
        svnLog.setDiscoverChangedPaths(true);
        svnLog.setLimit(1L);
        ArrayList<SVNLogEntry> logEntries = new ArrayList<SVNLogEntry>();
        svnLog.run(logEntries);
        return logEntries;
    }

    protected void before() throws Throwable {
        this.fSvnRepoDir = Files.createTempDirectory("hawkSvnRepo", new FileAttribute[0]).toFile();
        this.fSvnCheckoutDir = Files.createTempDirectory("hawkSvnCo", new FileAttribute[0]).toFile();
        this.svnOperationFactory = new SvnOperationFactory();
        this.svnClientManager = SVNClientManager.newInstance();
        SvnRepositoryCreate svnCreate = this.svnOperationFactory.createRepositoryCreate();
        svnCreate.setRepositoryRoot(this.fSvnRepoDir);
        this.svnRepoURL = (SVNURL)svnCreate.run();
        SvnCheckout svnCheckout = this.svnOperationFactory.createCheckout();
        svnCheckout.setSource(SvnTarget.fromURL((SVNURL)this.svnRepoURL));
        svnCheckout.setSingleTarget(SvnTarget.fromFile((File)this.fSvnCheckoutDir));
        svnCheckout.run();
        this.svnRepository = this.svnClientManager.createRepository(SVNURL.fromFile((File)this.fSvnCheckoutDir), true);
    }

    protected void after() {
        try {
            this.svnRepository.closeSession();
            this.svnClientManager.dispose();
            this.svnOperationFactory.dispose();
            TemporarySVNRepository.deleteRecursively(this.fSvnRepoDir);
            TemporarySVNRepository.deleteRecursively(this.fSvnCheckoutDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void deleteRecursively(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        Files.walkFileTree(f.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

