/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.dialog;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hawk.core.IHawkFactory;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.util.HawkConfig;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.ui2.Activator;
import org.eclipse.hawk.ui2.util.HUIManager;
import org.eclipse.hawk.ui2.view.HView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class HImportDialog
extends Dialog {
    private ComboViewer cmbvInstanceType;
    private Text txtLocation;
    private CheckboxTableViewer tblvInstances;
    private IHawkFactory[] factories;
    private Button btnFetch;

    public HImportDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle());
        HUIManager manager = HUIManager.getInstance();
        Collection factories = manager.getHawkFactoryInstances().values();
        this.factories = factories.toArray(new IHawkFactory[factories.size()]);
        Arrays.sort(this.factories, (a, b) -> a.getHumanReadableName().compareTo(b.getHumanReadableName()));
    }

    private IHawkFactory getSelectedFactory() {
        IStructuredSelection sel = (IStructuredSelection)this.cmbvInstanceType.getSelection();
        return (IHawkFactory)sel.getFirstElement();
    }

    private String getLocation() {
        return this.txtLocation.getText();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        Label lblInstanceType = new Label(container, 0);
        lblInstanceType.setText("&Instance type:");
        Combo cmbInstanceType = new Combo(container, 8);
        GridData cmbInstanceTypeLayout = new GridData(4, 0x1000000, true, false);
        cmbInstanceTypeLayout.horizontalSpan = 2;
        cmbInstanceType.setLayoutData((Object)cmbInstanceTypeLayout);
        this.cmbvInstanceType = new ComboViewer(cmbInstanceType);
        this.cmbvInstanceType.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmbvInstanceType.setLabelProvider((IBaseLabelProvider)new HumanNameLabelProvider());
        this.cmbvInstanceType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HImportDialog.this.dialogChanged();
            }
        });
        this.cmbvInstanceType.setInput((Object)this.factories);
        if (this.factories.length > 0) {
            cmbInstanceType.select(0);
        }
        Label lblLocation = new Label(container, 0);
        lblLocation.setText("&Location:");
        this.txtLocation = new Text(container, 2048);
        this.txtLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnFetch = new Button(container, 0);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HImportDialog.this.dialogChanged();
            }
        });
        Table tblInstances = new Table(container, 2080);
        GridData tblInstancesLayout = new GridData(4, 4, true, true);
        tblInstancesLayout.horizontalSpan = 3;
        tblInstancesLayout.minimumHeight = 200;
        tblInstancesLayout.minimumWidth = 400;
        tblInstances.setLayoutData((Object)tblInstancesLayout);
        this.tblvInstances = new CheckboxTableViewer(tblInstances);
        this.tblvInstances.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IHawkFactory.InstanceInfo entry = (IHawkFactory.InstanceInfo)element;
                return String.valueOf(entry.name) + (entry.state != IStateListener.HawkState.STOPPED ? " (running)" : "");
            }
        });
        this.tblvInstances.setComparator(new ViewerComparator());
        this.tblvInstances.setFilters(new ViewerFilter[]{new RemoveExistingHawksFilter(), new RemoveHawksWithUnknownDBTypeFilter()});
        this.tblvInstances.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite batchSelectContainer = new Composite(container, 0);
        batchSelectContainer.setLayout((Layout)new FillLayout());
        GridData batchSelectContainerLayout = new GridData();
        batchSelectContainerLayout.horizontalSpan = 3;
        batchSelectContainer.setLayoutData((Object)batchSelectContainerLayout);
        Button btnSelectAll = new Button(batchSelectContainer, 0);
        btnSelectAll.setText("&Select All");
        btnSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HImportDialog.this.tblvInstances.setAllChecked(true);
            }
        });
        Button btnDeselectAll = new Button(batchSelectContainer, 0);
        btnDeselectAll.setText("&Deselect All");
        btnDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HImportDialog.this.tblvInstances.setAllChecked(false);
            }
        });
        this.dialogChanged();
        return container;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            btn.setText("Import");
        }
        return btn;
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.doImport();
        this.close();
    }

    private void dialogChanged() {
        IHawkFactory factory = this.getSelectedFactory();
        boolean instancesUseLocation = factory != null && factory.instancesUseLocation();
        this.txtLocation.setEnabled(instancesUseLocation);
        this.btnFetch.setEnabled(instancesUseLocation);
        try {
            this.tblvInstances.setInput(null);
            if (!factory.instancesUseLocation() || !"".equals(this.getLocation())) {
                this.tblvInstances.setInput((Object)factory.listInstances(this.getLocation()));
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)"Could not fetch entries", (String)e.getMessage());
            Activator.logError(e.getMessage(), e);
        }
    }

    private void doImport() {
        IHawkFactory factory = this.getSelectedFactory();
        String location = this.getLocation();
        File base = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        Object[] objectArray = this.tblvInstances.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            IHawkFactory.InstanceInfo instance = (IHawkFactory.InstanceInfo)o;
            File storage = new File(base, instance.name);
            try {
                List plugins = factory.listPlugins(location);
                if (plugins == null) {
                    plugins = HUIManager.getInstance().getAvailablePlugins();
                }
                List pluginTypes = plugins.stream().map(p -> p.getType()).collect(Collectors.toList());
                HawkConfig hc = new HawkConfig(instance.name, storage.getCanonicalPath(), location, factory.getClass().getName(), pluginTypes);
                HUIManager manager = HUIManager.getInstance();
                HModel hm = HModel.load((HawkConfig)hc, (HManager)manager);
                manager.addHawk(hm);
                manager.saveHawkToMetadata(hm);
                HView.updateAsync(this.getShell().getDisplay());
            }
            catch (Exception e) {
                Activator.logError(e.getMessage(), e);
            }
            ++n2;
        }
    }

    public static final class HumanNameLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            return ((IHawkFactory)element).getHumanReadableName();
        }
    }

    private static final class RemoveExistingHawksFilter
    extends ViewerFilter {
        private RemoveExistingHawksFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IHawkFactory.InstanceInfo entry = (IHawkFactory.InstanceInfo)element;
            HUIManager manager = HUIManager.getInstance();
            File base = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            File expectedFolder = new File(base, entry.name);
            for (HModel m : manager.getHawks()) {
                if (m.getName().equals(entry.name)) {
                    return false;
                }
                if (!new File(m.getFolder()).equals(expectedFolder)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class RemoveHawksWithUnknownDBTypeFilter
    extends ViewerFilter {
        private RemoveHawksWithUnknownDBTypeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IHawkFactory.InstanceInfo entry = (IHawkFactory.InstanceInfo)element;
            HUIManager manager = HUIManager.getInstance();
            return entry.dbType == null || manager.getIndexTypes().contains(entry.dbType);
        }
    }
}

