/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.api.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TZlibTransport;
import org.eclipse.hawk.service.api.File;
import org.eclipse.hawk.service.api.Subscription;
import org.eclipse.hawk.service.api.SubscriptionDurability;
import org.eclipse.hawk.service.api.utils.GZipRequestInterceptor;
import org.eclipse.hawk.service.api.utils.GZipResponseInterceptor;
import org.eclipse.hawk.service.artemis.consumer.Consumer;

public class APIUtils {
    private APIUtils() {
    }

    public static Consumer connectToArtemis(Subscription s, SubscriptionDurability sd) throws Exception {
        return Consumer.connectRemote((String)s.host, (int)s.port, (String)s.queueAddress, (String)s.queueName, (Consumer.QueueType)APIUtils.toQueueType(sd), (boolean)s.sslRequired);
    }

    public static <T extends TServiceClient> T connectTo(Class<T> clazz, String url) throws TTransportException, URISyntaxException {
        return APIUtils.connectTo(clazz, url, ThriftProtocol.TUPLE);
    }

    public static <T extends TServiceClient> T connectTo(Class<T> clazz, String url, ThriftProtocol thriftProtocol) throws TTransportException, URISyntaxException {
        return APIUtils.connectTo(clazz, url, thriftProtocol, null, null);
    }

    public static <T extends TServiceClient> T connectTo(Class<T> clazz, String url, ThriftProtocol thriftProtocol, String username, String password) throws TTransportException, URISyntaxException {
        UsernamePasswordCredentials credentials = username != null && password != null ? new UsernamePasswordCredentials(username, password) : null;
        return APIUtils.connectTo(clazz, url, thriftProtocol, (Credentials)credentials);
    }

    public static <T extends TServiceClient> T connectTo(Class<T> clazz, String url, ThriftProtocol thriftProtocol, Credentials credentials) throws TTransportException, URISyntaxException {
        try {
            THttpClient transport;
            URI parsed = new URI(url);
            if (parsed.getScheme().startsWith("http")) {
                DefaultHttpClient httpClient = APIUtils.createGZipAwareHttpClient();
                if (credentials != null) {
                    httpClient.getCredentialsProvider().setCredentials(new AuthScope(null, -1), credentials);
                }
                transport = new THttpClient(url, (HttpClient)httpClient);
            } else {
                TSocket socket = new TSocket(parsed.getHost(), parsed.getPort());
                transport = new TZlibTransport((TTransport)socket);
                try {
                    transport.open();
                }
                catch (Exception e) {
                    throw new TTransportException("Failed to connect to " + parsed, (Throwable)e);
                }
            }
            Constructor<T> constructor = clazz.getDeclaredConstructor(TProtocol.class);
            return (T)((TServiceClient)constructor.newInstance(thriftProtocol.getProtocolFactory().getProtocol((TTransport)transport)));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TTransportException((Throwable)e);
        }
    }

    public static File convertJavaFileToThriftFile(java.io.File rawFile) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream fIS = new FileInputStream(rawFile);){
            FileChannel chan = fIS.getChannel();
            ByteBuffer buf = ByteBuffer.allocate((int)chan.size());
            chan.read(buf);
            buf.flip();
            File mmFile = new File();
            mmFile.name = rawFile.getName();
            mmFile.contents = buf;
            return mmFile;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static DefaultHttpClient createGZipAwareHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        client.addRequestInterceptor((HttpRequestInterceptor)new GZipRequestInterceptor());
        client.addResponseInterceptor((HttpResponseInterceptor)new GZipResponseInterceptor());
        return client;
    }

    private static Consumer.QueueType toQueueType(SubscriptionDurability sd) {
        switch (sd) {
            case DEFAULT: {
                return Consumer.QueueType.DEFAULT;
            }
            case DURABLE: {
                return Consumer.QueueType.DURABLE;
            }
            case TEMPORARY: {
                return Consumer.QueueType.TEMPORARY;
            }
        }
        throw new IllegalArgumentException("Unknown subscription durability " + (Object)((Object)sd));
    }

    private static <T> String[] toStringArray(Object[] c) {
        String[] strings = new String[c.length];
        int i = 0;
        Object[] objectArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            strings[i++] = "" + o;
            ++n2;
        }
        return strings;
    }

    public static enum ThriftProtocol {
        BINARY((TProtocolFactory)new TBinaryProtocol.Factory()),
        COMPACT((TProtocolFactory)new TCompactProtocol.Factory()),
        TUPLE((TProtocolFactory)new TTupleProtocol.Factory()),
        JSON((TProtocolFactory)new TJSONProtocol.Factory());

        private final TProtocolFactory protocolFactory;

        private ThriftProtocol(TProtocolFactory factory) {
            this.protocolFactory = factory;
        }

        public static String[] strings() {
            return APIUtils.toStringArray((Object[])ThriftProtocol.values());
        }

        public static ThriftProtocol guessFromURL(String location) {
            ThriftProtocol proto = TUPLE;
            if (location.endsWith("compact")) {
                proto = COMPACT;
            } else if (location.endsWith("binary")) {
                proto = BINARY;
            } else if (location.endsWith("json")) {
                proto = JSON;
            }
            return proto;
        }

        public TProtocolFactory getProtocolFactory() {
            return this.protocolFactory;
        }
    }
}

