/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.sqlite.AbstractSQLiteDatabase;
import org.eclipse.hawk.sqlite.SQLiteDatabase;
import org.eclipse.hawk.sqlite.iteration.StatementGraphNodeIterable;
import org.eclipse.hawk.sqlite.iteration.StatementSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLiteNodeIndex
implements IGraphNodeIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLiteNodeIndex.class);
    private final SQLiteDatabase db;
    private final String name;

    public SQLiteNodeIndex(SQLiteDatabase db, String name) {
        this.db = db;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public IGraphIterable<? extends IGraphNode> query(String key, Object valueOrPattern) {
        if (valueOrPattern instanceof String && ((String)valueOrPattern).contains("*")) {
            String pattern = (String)valueOrPattern;
            if ("*".equals(key) && "*".equals(pattern)) {
                return new StatementGraphNodeIterable<IGraphNode>(() -> this.db.getConnection().getQueries().getQueryIndexValueAllPairsStatement(this.name), () -> this.db.getConnection().getQueries().getQueryIndexValueAllPairsCountStatement(this.name), () -> this.db.getConnection().getQueries().getQueryIndexValueAllPairsSingleStatement(this.name), this.db::getNodeById);
            }
            if ("*".equals(pattern)) {
                return new StatementGraphNodeIterable<IGraphNode>(() -> this.db.getConnection().getQueries().getQueryIndexValueAllValuesStatement(this.name, key), () -> this.db.getConnection().getQueries().getQueryIndexValueAllValuesCountStatement(this.name, key), () -> this.db.getConnection().getQueries().getQueryIndexValueAllValuesSingleStatement(this.name, key), this.db::getNodeById);
            }
            return new StatementGraphNodeIterable<IGraphNode>(() -> this.db.getConnection().getQueries().getQueryIndexValuePatternStatement(this.name, key, pattern), () -> this.db.getConnection().getQueries().getQueryIndexValuePatternCountStatement(this.name, key, pattern), () -> this.db.getConnection().getQueries().getQueryIndexValuePatternSingleStatement(this.name, key, pattern), this.db::getNodeById);
        }
        return this.get(key, valueOrPattern);
    }

    public IGraphIterable<? extends IGraphNode> query(String key, Number from, Number to, boolean fromInclusive, boolean toInclusive) {
        return new StatementGraphNodeIterable<IGraphNode>(() -> this.db.getConnection().getQueries().getQueryIndexNumberRangeStatement(this.name, key, fromInclusive, from, toInclusive, to), () -> this.db.getConnection().getQueries().getQueryIndexNumberRangeCountStatement(this.name, key, fromInclusive, from, toInclusive, to), () -> this.db.getConnection().getQueries().getQueryIndexNumberRangeSingleStatement(this.name, key, fromInclusive, from, toInclusive, to), this.db::getNodeById);
    }

    public IGraphIterable<? extends IGraphNode> get(String key, Object exactValue) {
        return new StatementGraphNodeIterable<IGraphNode>(() -> this.db.getConnection().getQueries().getQueryIndexValueExactStatement(this.name, key, exactValue), () -> this.db.getConnection().getQueries().getQueryIndexValueExactCountStatement(this.name, key, exactValue), () -> this.db.getConnection().getQueries().getQueryIndexValueExactSingleStatement(this.name, key, exactValue), this.db::getNodeById);
    }

    public void add(IGraphNode n, String key, Object value) {
        int rowCount = this.executeUpdate(() -> this.db.getConnection().getQueries().getAddNodeIndexEntryStatement(this.name, key, (Integer)n.getId(), value));
        assert (rowCount == 1) : "One row should be inserted when adding an index entry";
    }

    public void remove(IGraphNode n) {
        this.executeUpdate(() -> this.db.getConnection().getQueries().getRemoveNodeFromIndexStatement(this.name, (Integer)n.getId()));
    }

    public void remove(IGraphNode n, String key, Object value) {
        if (key == null) {
            if (value == null) {
                this.remove(n);
            } else {
                this.executeUpdate(() -> this.db.getConnection().getQueries().getRemoveNodeValueFromIndexStatement(this.name, (Integer)n.getId(), value));
            }
        } else if (value == null) {
            this.executeUpdate(() -> this.db.getConnection().getQueries().getRemoveNodeFieldFromIndexStatement(this.name, (Integer)n.getId(), key));
        }
        this.executeUpdate(() -> this.db.getConnection().getQueries().getRemoveNodeIndexEntryStatement(this.name, key, (Integer)n.getId(), value));
    }

    public void flush() {
    }

    public void delete() {
        try {
            AbstractSQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
            PreparedStatement stmt = this.db.getConnection().getQueries().getDeleteNodeIndexStatement(this.name);
            int rowCount = stmt.executeUpdate();
            assert (rowCount == 1) : "A row should have been deleted when deleting a node index";
            conn.getSchema().clearNodeIndexTable(this.name);
            conn.dropIndexTableOnCommit(this.name);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private int executeUpdate(StatementSupplier stmt) {
        try {
            return stmt.get().executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }
}

